/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.product;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.iproduct.IAboutInfo;
import org.eclipse.pde.internal.core.iproduct.IArgumentsInfo;
import org.eclipse.pde.internal.core.iproduct.IConfigurationFileInfo;
import org.eclipse.pde.internal.core.iproduct.IPluginConfiguration;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModelFactory;
import org.eclipse.pde.internal.core.iproduct.IProductPlugin;
import org.eclipse.pde.internal.core.iproduct.ISplashInfo;
import org.eclipse.pde.internal.core.iproduct.IWindowImages;
import org.eclipse.pde.internal.core.product.SplashInfo;
import org.eclipse.pde.internal.core.product.WorkspaceProductModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ISetSelectionTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseProductCreationOperation
extends WorkspaceModifyOperation {
    private IFile fFile;

    public BaseProductCreationOperation(IFile file) {
        this.fFile = file;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        monitor.beginTask(PDEUIMessages.BaseProductCreationOperation_taskName, 2);
        this.createContent();
        monitor.worked(1);
        this.openFile();
        monitor.done();
    }

    private void createContent() {
        WorkspaceProductModel model = new WorkspaceProductModel(this.fFile, false);
        this.initializeProduct(model.getProduct());
        model.save();
        model.dispose();
    }

    protected void initializeProduct(IProduct product) {
        IProductModelFactory factory = product.getModel().getFactory();
        IConfigurationFileInfo info = factory.createConfigFileInfo();
        info.setUse(null, "default");
        product.setConfigurationFileInfo(info);
        IArgumentsInfo args = factory.createLauncherArguments();
        args.setVMArguments("-XstartOnFirstThread -Dorg.eclipse.swt.internal.carbon.smallFonts", 2);
        product.setLauncherArguments(args);
    }

    private Properties getProductProperties(IPluginElement element) {
        Properties prop = new Properties();
        IPluginObject[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            IPluginElement child = (IPluginElement)children[i];
            if (child.getName().equals("property")) {
                String name = null;
                String value = null;
                IPluginAttribute attr = child.getAttribute("name");
                if (attr != null) {
                    name = attr.getValue();
                }
                if ((attr = child.getAttribute("value")) != null) {
                    value = attr.getValue();
                }
                if (name != null && value != null) {
                    prop.put(name, value);
                }
            }
            ++i;
        }
        return prop;
    }

    protected IPluginElement getProductExtension(String productId) {
        int lastDot = productId.lastIndexOf(46);
        if (lastDot == -1) {
            return null;
        }
        String pluginId = productId.substring(0, lastDot);
        IPluginModelBase model = PluginRegistry.findModel((String)pluginId);
        if (model != null) {
            IPluginExtension[] extensions = model.getPluginBase().getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IPluginElement object;
                IPluginObject[] children;
                if ("org.eclipse.core.runtime.products".equals(extensions[i].getPoint()) && productId.substring(lastDot + 1).equals(extensions[i].getId()) && (children = extensions[i].getChildren()).length > 0 && (object = (IPluginElement)children[0]).getName().equals("product")) {
                    return object;
                }
                ++i;
            }
        }
        return null;
    }

    protected void initializeProductInfo(IProductModelFactory factory, IProduct product, String id) {
        product.setProductId(id);
        product.setVersion("1.0.0.qualifier");
        IPluginElement element = this.getProductExtension(id);
        if (element != null) {
            IPluginAttribute attr = element.getAttribute("application");
            if (attr != null) {
                product.setApplication(attr.getValue());
            }
            if ((attr = element.getAttribute("name")) != null) {
                product.setName(attr.getValue());
            }
            Properties prop = this.getProductProperties(element);
            String aboutText = prop.getProperty("aboutText");
            String aboutImage = prop.getProperty("aboutImage");
            if (aboutText != null || aboutImage != null) {
                IAboutInfo info = factory.createAboutInfo();
                info.setText(aboutText);
                info.setImagePath(aboutImage);
                product.setAboutInfo(info);
            }
            IWindowImages winImages = factory.createWindowImages();
            String path = prop.getProperty("windowImages");
            if (path != null) {
                StringTokenizer tokenizer = new StringTokenizer(path, ",", true);
                int size = 0;
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if (token.equals(",")) {
                        ++size;
                        continue;
                    }
                    winImages.setImagePath(token, size);
                }
            }
            product.setWindowImages(winImages);
            ISplashInfo splashInfo = factory.createSplashInfo();
            splashInfo.setForegroundColor(prop.getProperty("startupForegroundColor"), true);
            int[] barGeo = SplashInfo.getGeometryArray((String)prop.getProperty("startupProgressRect"));
            splashInfo.setProgressGeometry(barGeo, true);
            int[] messageGeo = SplashInfo.getGeometryArray((String)prop.getProperty("startupMessageRect"));
            splashInfo.setMessageGeometry(messageGeo, true);
            product.setSplashInfo(splashInfo);
        }
    }

    protected void addPlugins(IProductModelFactory factory, IProduct product, Map<IPluginModelBase, String> plugins) {
        IProductPlugin[] pplugins = new IProductPlugin[plugins.size()];
        ArrayList<IPluginConfiguration> configurations = new ArrayList<IPluginConfiguration>(3);
        IPluginModelBase[] models = plugins.keySet().toArray(new IPluginModelBase[plugins.size()]);
        int i = 0;
        while (i < models.length) {
            IPluginModelBase model = models[i];
            IProductPlugin pplugin = factory.createPlugin();
            pplugin.setId(model.getPluginBase().getId());
            pplugins[i] = pplugin;
            String sl = plugins.get(model);
            if (!model.isFragmentModel() && !sl.equals("default:default")) {
                IPluginConfiguration configuration = factory.createPluginConfiguration();
                configuration.setId(model.getPluginBase().getId());
                String[] slinfo = sl.split(":");
                if (slinfo.length != 0) {
                    if (slinfo[0].equals("default")) {
                        slinfo[0] = "0";
                    }
                    configuration.setStartLevel(Integer.valueOf(slinfo[0]).intValue());
                    configuration.setAutoStart(slinfo[1].equals("true"));
                    configurations.add(configuration);
                }
            }
            ++i;
        }
        product.addPlugins(pplugins);
        int size = configurations.size();
        if (size > 0) {
            product.addPluginConfigurations(configurations.toArray(new IPluginConfiguration[size]));
        }
    }

    protected void addPlugins(IProductModelFactory factory, IProduct product, String[] plugins) {
        IProductPlugin[] pplugins = new IProductPlugin[plugins.length];
        int i = 0;
        while (i < plugins.length) {
            IProductPlugin pplugin = factory.createPlugin();
            pplugin.setId(plugins[i]);
            pplugins[i] = pplugin;
            ++i;
        }
        product.addPlugins(pplugins);
    }

    private void openFile() {
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow ww = PDEPlugin.getActiveWorkbenchWindow();
                if (ww == null) {
                    return;
                }
                IWorkbenchPage page = ww.getActivePage();
                if (page == null || !BaseProductCreationOperation.this.fFile.exists()) {
                    return;
                }
                IWorkbenchPart focusPart = page.getActivePart();
                if (focusPart instanceof ISetSelectionTarget) {
                    StructuredSelection selection = new StructuredSelection((Object)BaseProductCreationOperation.this.fFile);
                    ((ISetSelectionTarget)focusPart).selectReveal((ISelection)selection);
                }
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)BaseProductCreationOperation.this.fFile, (String)"org.eclipse.pde.ui.productEditor");
                }
                catch (PartInitException partInitException) {}
            }
        });
    }
}

