/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.preferences;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.maven.settings.building.SettingsProblem;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.embedder.MavenRuntime;
import org.eclipse.m2e.core.embedder.MavenRuntimeManager;
import org.eclipse.m2e.core.internal.embedder.MavenEmbeddedRuntime;
import org.eclipse.m2e.core.internal.index.IndexManager;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.ide.IDE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenInstallationsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final Logger log = LoggerFactory.getLogger(MavenInstallationsPreferencePage.class);
    final MavenRuntimeManager runtimeManager;
    final IMavenConfiguration mavenConfiguration;
    final IMaven maven;
    MavenRuntime defaultRuntime;
    List<MavenRuntime> runtimes;
    CheckboxTableViewer runtimesViewer;
    Text globalSettingsText;
    private String globalSettings;
    boolean dirty = false;
    private Link globalSettingsLink;
    private Button globalSettingsBrowseButton;
    private static final String P_MAVEN_CUSTOM_GLOBAL = "customGlobalSettingsFile";

    public MavenInstallationsPreferencePage() {
        this.setTitle(Messages.MavenInstallationsPreferencePage_title);
        this.runtimeManager = MavenPlugin.getMavenRuntimeManager();
        this.mavenConfiguration = MavenPlugin.getMavenConfiguration();
        this.maven = MavenPlugin.getMaven();
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.runtimeManager.reset();
        this.defaultRuntime = this.runtimeManager.getDefaultRuntime();
        this.runtimes = this.runtimeManager.getMavenRuntimes();
        this.runtimesViewer.setInput(this.runtimes);
        this.runtimesViewer.setChecked((Object)this.defaultRuntime, true);
        this.runtimesViewer.refresh();
        this.storeCustom("");
        this.globalSettingsText.setText("");
        try {
            this.mavenConfiguration.setGlobalSettingsFile("");
        }
        catch (CoreException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.updateGlobals(true);
        super.performDefaults();
        this.setDirty(true);
    }

    protected void storeCustom(String dir) {
        M2EUIPluginActivator.getDefault().getPreferenceStore().setValue(P_MAVEN_CUSTOM_GLOBAL, dir == null ? "" : dir);
    }

    protected void performApply() {
        this.updateSettings();
    }

    private void updateSettings() {
        new Job(Messages.MavenInstallationsPreferencePage_job_updating){

            protected IStatus run(IProgressMonitor monitor) {
                String dir = MavenInstallationsPreferencePage.this.getGlobalSettingsText();
                MavenInstallationsPreferencePage.this.runtimeManager.setRuntimes(MavenInstallationsPreferencePage.this.runtimes);
                MavenInstallationsPreferencePage.this.runtimeManager.setDefaultRuntime(MavenInstallationsPreferencePage.this.defaultRuntime);
                String oldSettings = MavenInstallationsPreferencePage.this.mavenConfiguration.getGlobalSettingsFile();
                try {
                    MavenInstallationsPreferencePage.this.mavenConfiguration.setGlobalSettingsFile(dir);
                }
                catch (CoreException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new RuntimeException(e.getMessage(), e);
                }
                if (MavenInstallationsPreferencePage.this.defaultRuntime == null || MavenInstallationsPreferencePage.this.defaultRuntime instanceof MavenEmbeddedRuntime) {
                    MavenInstallationsPreferencePage.this.storeCustom(dir);
                }
                IndexManager indexManager = MavenPlugin.getIndexManager();
                try {
                    indexManager.getWorkspaceIndex().updateIndex(true, monitor);
                }
                catch (CoreException ex) {
                    return ex.getStatus();
                }
                if ((dir != null || oldSettings == null) && dir != null) {
                    dir.equals(oldSettings);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public boolean performOk() {
        if (this.dirty) {
            this.updateSettings();
        }
        return true;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    protected boolean validateMavenInstall(String dir) {
        if (dir == null || dir.length() == 0) {
            return false;
        }
        File selectedDir = new File(dir);
        if (!selectedDir.isDirectory()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.MavenInstallationsPreferencePage_error_title, (String)Messages.MavenInstallationsPreferencePage_error_message);
            return false;
        }
        File binDir = new File(dir, "bin");
        File confDir = new File(dir, "conf");
        File libDir = new File(dir, "lib");
        if (!(binDir.exists() && confDir.exists() && libDir.exists())) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.MavenInstallationsPreferencePage_error_title, (String)Messages.MavenInstallationsPreferencePage_error2_message);
            return false;
        }
        return true;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginBottom = 5;
        gridLayout.marginRight = 5;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        Label link = new Label(composite, 0);
        link.setLayoutData((Object)new GridData(4, 128, false, false, 3, 1));
        link.setText(Messages.MavenInstallationsPreferencePage_link);
        this.createTable(composite);
        this.createGlobalSettings(composite);
        this.defaultRuntime = this.runtimeManager.getDefaultRuntime();
        this.runtimes = this.runtimeManager.getMavenRuntimes();
        this.runtimesViewer.setInput(this.runtimes);
        this.runtimesViewer.setChecked((Object)this.defaultRuntime, true);
        this.runtimesViewer.refresh();
        this.checkSettings();
        this.updateGlobals(false);
        this.globalSettingsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyevent) {
                MavenInstallationsPreferencePage.this.setGlobalSettingsText(MavenInstallationsPreferencePage.this.globalSettingsText.getText());
                MavenInstallationsPreferencePage.this.updateGlobalSettingsLink();
                MavenInstallationsPreferencePage.this.checkSettings();
                MavenInstallationsPreferencePage.this.setDirty(true);
            }
        });
        return composite;
    }

    private void updateGlobalSettingsText(boolean useLastCustomGlobal) {
        String globalSettings = this.getGlobalSettingsFile(useLastCustomGlobal);
        this.globalSettingsText.setText(globalSettings == null ? "" : globalSettings);
    }

    private String getGlobalSettingsFile(boolean useLastCustomGlobal) {
        if (this.defaultRuntime == null || this.defaultRuntime instanceof MavenEmbeddedRuntime) {
            String globalSettings = null;
            globalSettings = useLastCustomGlobal ? M2EUIPluginActivator.getDefault().getPreferenceStore().getString(P_MAVEN_CUSTOM_GLOBAL) : M2EUIPluginActivator.getDefault().getPreferenceStore().getString("eclipse.m2.globalSettingsFile");
            return globalSettings.trim().length() == 0 ? null : globalSettings;
        }
        return this.defaultRuntime == null ? null : this.defaultRuntime.getSettings();
    }

    public void setGlobalSettingsText(String settings) {
        this.globalSettings = settings;
    }

    public String getGlobalSettingsText() {
        return this.globalSettings;
    }

    private void updateGlobals(boolean useLastCustomGlobal) {
        this.updateGlobalSettingsText(useLastCustomGlobal);
        this.updateGlobalSettingsLink();
        this.updateGlobalSettingsBrowseButton();
    }

    private MavenRuntime getCheckedRuntime() {
        Object[] runtimes = this.runtimesViewer.getCheckedElements();
        if (runtimes != null && runtimes.length > 0) {
            return (MavenRuntime)runtimes[0];
        }
        return null;
    }

    protected MavenRuntime getSelectedMavenRuntime() {
        IStructuredSelection sel = (IStructuredSelection)this.runtimesViewer.getSelection();
        return (MavenRuntime)sel.getFirstElement();
    }

    private void updateGlobalSettingsLink() {
        MavenRuntime runtime = this.getCheckedRuntime();
        String text = "";
        String currText = this.globalSettingsText.getText();
        boolean showURL = false;
        File f = new File(currText);
        if (f.exists()) {
            showURL = true;
        }
        String openFile = showURL ? Messages.MavenInstallationsPreferencePage_link_open : "";
        text = runtime instanceof MavenEmbeddedRuntime ? NLS.bind((String)Messages.MavenInstallationsPreferencePage_settings, (Object)openFile) : NLS.bind((String)Messages.MavenInstallationsPreferencePage_settings_install, (Object)openFile);
        this.globalSettingsLink.setText(text);
    }

    private void updateGlobalSettingsBrowseButton() {
        MavenRuntime runtime = this.getCheckedRuntime();
        boolean enabled = runtime != null && runtime instanceof MavenEmbeddedRuntime;
        this.globalSettingsBrowseButton.setEnabled(enabled);
        this.globalSettingsText.setEditable(enabled);
    }

    private void createGlobalSettings(Composite composite) {
        this.globalSettingsLink = new Link(composite, 0);
        this.globalSettingsLink.setData("name", (Object)"globalSettingsLink");
        this.globalSettingsLink.setToolTipText(Messages.MavenInstallationsPreferencePage_link_global);
        GridData gd = new GridData(4, 0x1000000, true, false, 3, 1);
        gd.verticalIndent = 25;
        this.globalSettingsLink.setLayoutData((Object)gd);
        this.globalSettingsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String globalSettings = MavenInstallationsPreferencePage.this.getGlobalSettings();
                if (globalSettings.length() == 0) {
                    globalSettings = MavenInstallationsPreferencePage.this.defaultRuntime.getSettings();
                }
                if (globalSettings != null && globalSettings.length() > 0) {
                    MavenInstallationsPreferencePage.this.openEditor(globalSettings);
                }
            }
        });
        this.globalSettingsText = new Text(composite, 2048);
        this.globalSettingsText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.globalSettingsText.setData("name", (Object)"globalSettingsText");
        this.globalSettingsBrowseButton = new Button(composite, 0);
        GridData gd_globalSettingsBrowseButton = new GridData(4, 0x1000000, false, false);
        this.globalSettingsBrowseButton.setLayoutData((Object)gd_globalSettingsBrowseButton);
        this.globalSettingsBrowseButton.setText(Messages.MavenInstallationsPreferencePage_btnGlobalBrowse);
        this.globalSettingsBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String file;
                FileDialog dialog = new FileDialog(MavenInstallationsPreferencePage.this.getShell(), 4096);
                if (MavenInstallationsPreferencePage.this.getGlobalSettings().length() > 0) {
                    dialog.setFileName(MavenInstallationsPreferencePage.this.getGlobalSettings());
                }
                if ((file = dialog.open()) != null && (file = file.trim()).length() > 0) {
                    MavenInstallationsPreferencePage.this.globalSettingsText.setText(file);
                }
            }
        });
    }

    private void createTable(Composite composite) {
        this.runtimesViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)67584);
        this.runtimesViewer.setLabelProvider((IBaseLabelProvider)new RuntimesLabelProvider());
        this.runtimesViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object input) {
                List list;
                if (input instanceof List && (list = (List)input).size() > 0) {
                    return list.toArray(new MavenRuntime[list.size()]);
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        Table table = this.runtimesViewer.getTable();
        table.setLinesVisible(false);
        table.setHeaderVisible(false);
        GridData gd_table = new GridData(4, 4, true, false, 2, 3);
        gd_table.heightHint = 151;
        gd_table.widthHint = 333;
        table.setLayoutData((Object)gd_table);
        Button addButton = new Button(composite, 0);
        addButton.setLayoutData((Object)new GridData(4, 128, false, false));
        addButton.setText(Messages.MavenInstallationsPreferencePage_btnAdd);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dlg = new DirectoryDialog(MavenInstallationsPreferencePage.this.getShell());
                dlg.setText(Messages.MavenInstallationsPreferencePage_dialog_install_title);
                dlg.setMessage(Messages.MavenInstallationsPreferencePage_dialog_install_message);
                String dir = dlg.open();
                if (dir == null) {
                    return;
                }
                boolean ok = MavenInstallationsPreferencePage.this.validateMavenInstall(dir);
                if (ok) {
                    MavenRuntime runtime = MavenRuntimeManager.createExternalRuntime((String)dir);
                    if (MavenInstallationsPreferencePage.this.runtimes.contains(runtime)) {
                        MessageDialog.openError((Shell)MavenInstallationsPreferencePage.this.getShell(), (String)Messages.MavenInstallationsPreferencePage_error_title, (String)Messages.MavenInstallationsPreferencePage_error3_message);
                    } else {
                        MavenInstallationsPreferencePage.this.runtimes.add(runtime);
                        MavenInstallationsPreferencePage.this.runtimesViewer.refresh();
                        MavenInstallationsPreferencePage.this.runtimesViewer.setAllChecked(false);
                        MavenInstallationsPreferencePage.this.runtimesViewer.setChecked((Object)runtime, true);
                        if (runtime != null) {
                            MavenInstallationsPreferencePage.this.setCheckedRuntime(runtime);
                        }
                    }
                }
            }
        });
        final Button editButton = new Button(composite, 0);
        editButton.setLayoutData((Object)new GridData(4, 128, false, false));
        editButton.setEnabled(false);
        editButton.setText(Messages.MavenInstallationsPreferencePage_btnEdit);
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MavenRuntime runtime = MavenInstallationsPreferencePage.this.getSelectedMavenRuntime();
                DirectoryDialog dlg = new DirectoryDialog(Display.getCurrent().getActiveShell());
                dlg.setText(Messages.MavenInstallationsPreferencePage_dialog_title);
                dlg.setMessage(Messages.MavenInstallationsPreferencePage_dialog_message);
                dlg.setFilterPath(runtime.getLocation());
                String dir = dlg.open();
                boolean ok = MavenInstallationsPreferencePage.this.validateMavenInstall(dir);
                if (ok && !dir.equals(runtime.getLocation())) {
                    MavenRuntime newRuntime = MavenRuntimeManager.createExternalRuntime((String)dir);
                    if (MavenInstallationsPreferencePage.this.runtimes.contains(newRuntime)) {
                        MessageDialog.openError((Shell)MavenInstallationsPreferencePage.this.getShell(), (String)Messages.MavenInstallationsPreferencePage_error_title, (String)Messages.MavenInstallationsPreferencePage_error4_message);
                    } else {
                        MavenInstallationsPreferencePage.this.runtimes.set(MavenInstallationsPreferencePage.this.runtimes.indexOf(runtime), newRuntime);
                        MavenInstallationsPreferencePage.this.runtimesViewer.refresh();
                        MavenInstallationsPreferencePage.this.setDirty(true);
                        if (newRuntime != null) {
                            MavenInstallationsPreferencePage.this.setCheckedRuntime(newRuntime);
                        }
                    }
                }
            }
        });
        final Button removeButton = new Button(composite, 0);
        removeButton.setEnabled(false);
        removeButton.setLayoutData((Object)new GridData(4, 128, false, false));
        removeButton.setText(Messages.MavenInstallationsPreferencePage_btnRemove);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MavenRuntime runtime = MavenInstallationsPreferencePage.this.getSelectedMavenRuntime();
                MavenInstallationsPreferencePage.this.runtimes.remove(runtime);
                MavenInstallationsPreferencePage.this.runtimesViewer.refresh();
                Object[] checkedElements = MavenInstallationsPreferencePage.this.runtimesViewer.getCheckedElements();
                if (checkedElements == null || checkedElements.length == 0) {
                    MavenInstallationsPreferencePage.this.defaultRuntime = MavenInstallationsPreferencePage.this.runtimeManager.getRuntime("EMBEDDED");
                    MavenInstallationsPreferencePage.this.runtimesViewer.setChecked((Object)MavenInstallationsPreferencePage.this.defaultRuntime, true);
                    MavenInstallationsPreferencePage.this.setCheckedRuntime(MavenInstallationsPreferencePage.this.defaultRuntime);
                }
                MavenInstallationsPreferencePage.this.setDirty(true);
            }
        });
        this.runtimesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (MavenInstallationsPreferencePage.this.runtimesViewer.getSelection() instanceof IStructuredSelection) {
                    MavenRuntime runtime = MavenInstallationsPreferencePage.this.getSelectedMavenRuntime();
                    boolean isEnabled = runtime != null && runtime.isEditable();
                    removeButton.setEnabled(isEnabled);
                    editButton.setEnabled(isEnabled);
                }
            }
        });
        this.runtimesViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getElement() != null && event.getChecked()) {
                    MavenInstallationsPreferencePage.this.setCheckedRuntime((MavenRuntime)event.getElement());
                }
            }
        });
        Link noteLabel = new Link(composite, 72);
        GridData noteLabelData = new GridData(4, 128, false, false, 2, 1);
        noteLabelData.horizontalIndent = 15;
        noteLabelData.widthHint = 100;
        noteLabel.setLayoutData((Object)noteLabelData);
        noteLabel.setText(String.valueOf(Messages.MavenInstallationsPreferencePage_lblNote1) + Messages.MavenInstallationsPreferencePage_lblNote2);
        noteLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    URL url = new URL(e.text);
                    IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
                    browser.openURL(url);
                }
                catch (MalformedURLException ex) {
                    log.error("Malformed URL", (Throwable)ex);
                }
                catch (PartInitException ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                }
            }
        });
    }

    protected void setCheckedRuntime(MavenRuntime runtime) {
        this.runtimesViewer.setAllChecked(false);
        this.runtimesViewer.setChecked((Object)runtime, true);
        this.defaultRuntime = runtime;
        boolean useDefault = this.defaultRuntime == null || this.defaultRuntime instanceof MavenEmbeddedRuntime;
        this.updateGlobals(useDefault);
        this.setDirty(true);
    }

    void checkSettings() {
        List result;
        this.setErrorMessage(null);
        this.setMessage(null);
        String globalSettings = this.getGlobalSettings();
        if (globalSettings != null && globalSettings.length() > 0) {
            File globalSettingsFile = new File(globalSettings);
            if (!globalSettingsFile.exists()) {
                this.setMessage(Messages.MavenInstallationsPreferencePage_error_global_missing, 2);
                globalSettings = null;
            }
        } else {
            globalSettings = null;
        }
        if ((result = this.maven.validateSettings(globalSettings)).size() > 0) {
            this.setMessage(String.valueOf(Messages.MavenInstallationsPreferencePage_error_global_parse) + ((SettingsProblem)result.get(0)).getMessage(), 2);
        }
    }

    void openEditor(final String fileName) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor("settings.xml");
        File file = new File(fileName);
        IEditorInput input = null;
        try {
            Class<?> javaInput = null;
            try {
                javaInput = Class.forName("org.eclipse.ui.internal.editors.text.JavaFileEditorInput");
                Constructor<?> cons = javaInput.getConstructor(File.class);
                input = (IEditorInput)cons.newInstance(file);
            }
            catch (Exception exception) {
                try {
                    IFileStore fileStore = EFS.getLocalFileSystem().fromLocalFile(file);
                    Class<?> storeInput = Class.forName("org.eclipse.ui.ide.FileStoreEditorInput");
                    Constructor<?> cons = storeInput.getConstructor(IFileStore.class);
                    input = (IEditorInput)cons.newInstance(fileStore);
                }
                catch (Exception exception2) {}
            }
            final IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, input, (String)desc.getId());
            editor.addPropertyListener(new IPropertyListener(){

                public void propertyChanged(Object source, int propId) {
                    if (!editor.isDirty()) {
                        log.info("Refreshing settings " + fileName);
                        MavenInstallationsPreferencePage.this.invalidateMavenSettings(false);
                    }
                }
            });
        }
        catch (PartInitException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    void invalidateMavenSettings(boolean reindex) {
    }

    String getGlobalSettings() {
        return this.globalSettingsText.getText().trim();
    }

    static class RuntimesLabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        RuntimesLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            MavenRuntime runtime = (MavenRuntime)element;
            return runtime.toString();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            MavenRuntime runtime = (MavenRuntime)element;
            if (!runtime.isEditable()) {
                return Display.getCurrent().getSystemColor(16);
            }
            return null;
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

