/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.internal.utility.JavaProjectTools;
import org.eclipse.jpt.common.core.internal.utility.TypeTools;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaContextModel;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkCustomizer;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.EclipseLinkJavaTypeMapping;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.CustomizerAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.validation.JptJpaEclipseLinkCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkJavaCustomizer
extends AbstractJavaContextModel<EclipseLinkJavaTypeMapping>
implements EclipseLinkCustomizer {
    private String specifiedCustomizerClass = this.buildSpecifiedCustomizerClass();
    private String fullyQualifiedCustomizerClass;

    public EclipseLinkJavaCustomizer(EclipseLinkJavaTypeMapping parent) {
        super((JpaContextModel)parent);
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedCustomizerClass_(this.buildSpecifiedCustomizerClass());
    }

    public void update() {
        super.update();
        this.setFullyQualifiedCustomizerClass(this.buildFullyQualifiedCustomizerClass());
    }

    @Override
    public String getCustomizerClass() {
        return this.specifiedCustomizerClass != null ? this.specifiedCustomizerClass : null;
    }

    @Override
    public String getSpecifiedCustomizerClass() {
        return this.specifiedCustomizerClass;
    }

    @Override
    public void setSpecifiedCustomizerClass(String customizerClass) {
        if (this.valuesAreDifferent(customizerClass, this.specifiedCustomizerClass)) {
            CustomizerAnnotation annotation = this.getCustomizerAnnotation();
            if (customizerClass == null) {
                if (annotation != null) {
                    this.removeCustomizerAnnotation();
                }
            } else {
                if (annotation == null) {
                    annotation = this.addCustomizerAnnotation();
                }
                annotation.setValue(customizerClass);
            }
            this.setSpecifiedCustomizerClass_(customizerClass);
        }
    }

    protected void setSpecifiedCustomizerClass_(String customizerClass) {
        String old = this.specifiedCustomizerClass;
        this.specifiedCustomizerClass = customizerClass;
        this.firePropertyChanged("specifiedCustomizerClass", old, customizerClass);
    }

    protected String buildSpecifiedCustomizerClass() {
        CustomizerAnnotation annotation = this.getCustomizerAnnotation();
        return annotation == null ? null : annotation.getValue();
    }

    @Override
    public String getDefaultCustomizerClass() {
        return null;
    }

    @Override
    public String getFullyQualifiedCustomizerClass() {
        return this.fullyQualifiedCustomizerClass;
    }

    protected void setFullyQualifiedCustomizerClass(String customizerClass) {
        String old = this.fullyQualifiedCustomizerClass;
        this.fullyQualifiedCustomizerClass = customizerClass;
        this.firePropertyChanged("fullyQualifiedCustomizerClass", old, customizerClass);
    }

    protected String buildFullyQualifiedCustomizerClass() {
        CustomizerAnnotation annotation = this.getCustomizerAnnotation();
        return annotation == null ? null : annotation.getFullyQualifiedCustomizerClassName();
    }

    protected CustomizerAnnotation getCustomizerAnnotation() {
        return (CustomizerAnnotation)this.getJavaResourceType().getAnnotation(this.getCustomizerAnnotationName());
    }

    protected CustomizerAnnotation addCustomizerAnnotation() {
        return (CustomizerAnnotation)this.getJavaResourceType().addAnnotation(this.getCustomizerAnnotationName());
    }

    protected void removeCustomizerAnnotation() {
        this.getJavaResourceType().removeAnnotation(this.getCustomizerAnnotationName());
    }

    protected String getCustomizerAnnotationName() {
        return "org.eclipse.persistence.annotations.Customizer";
    }

    protected EclipseLinkJavaTypeMapping getTypeMapping() {
        return (EclipseLinkJavaTypeMapping)this.parent;
    }

    protected JavaResourceType getJavaResourceType() {
        return this.getTypeMapping().getJavaResourceType();
    }

    @Override
    public char getCustomizerClassEnclosingTypeSeparator() {
        return '.';
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateCustomizerClass(messages);
    }

    protected void validateCustomizerClass(List<IMessage> messages) {
        if (this.getFullyQualifiedCustomizerClass() == null) {
            return;
        }
        IType customizerJdtType = JavaProjectTools.findType((IJavaProject)this.getJavaProject(), (String)this.getFullyQualifiedCustomizerClass());
        if (customizerJdtType == null) {
            return;
        }
        if (!TypeTools.hasPublicZeroArgConstructor((IType)customizerJdtType)) {
            messages.add(this.buildValidationMessage(this.getCustomizerClassTextRange(), JptJpaEclipseLinkCoreValidationMessages.DESCRIPTOR_CUSTOMIZER_CLASS_NOT_VALID, new Object[]{this.getFullyQualifiedCustomizerClass()}));
        }
        if (!this.customizerClassImplementsInterface("org.eclipse.persistence.config.DescriptorCustomizer")) {
            messages.add(this.buildValidationMessage(this.getCustomizerClassTextRange(), JptJpaEclipseLinkCoreValidationMessages.DESCRIPTOR_CUSTOMIZER_CLASS_IMPLEMENTS_DESCRIPTOR_CUSTOMIZER, new Object[]{this.getFullyQualifiedCustomizerClass()}));
        }
    }

    protected boolean customizerClassImplementsInterface(String interfaceName) {
        return this.typeImplementsInterface(this.getFullyQualifiedCustomizerClass(), interfaceName);
    }

    protected boolean typeImplementsInterface(String typeName, String interfaceName) {
        return typeName != null && TypeTools.isSubType((String)typeName, (String)interfaceName, (IJavaProject)this.getJavaProject());
    }

    protected TextRange getCustomizerClassTextRange() {
        return this.getValidationTextRange(this.getCustomizerAnnotation().getValueTextRange());
    }

    public TextRange getValidationTextRange() {
        TextRange textRange = this.getCustomizerAnnotation().getTextRange();
        return textRange != null ? textRange : this.getTypeMapping().getValidationTextRange();
    }
}

