/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.java;

import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaContextModel;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkMutable;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.EclipseLinkJavaPersistentAttribute;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.MutableAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkJavaMutable
extends AbstractJavaContextModel<JavaAttributeMapping>
implements EclipseLinkMutable {
    protected Boolean specifiedMutable = this.buildSpecifiedMutable();
    protected boolean defaultMutable = this.buildDefaultMutable();

    public EclipseLinkJavaMutable(JavaAttributeMapping parent) {
        super((JpaContextModel)parent);
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedMutable_(this.buildSpecifiedMutable());
    }

    public void update() {
        super.update();
        this.setDefaultMutable(this.buildDefaultMutable());
    }

    @Override
    public boolean isMutable() {
        return this.specifiedMutable != null ? this.specifiedMutable : this.defaultMutable;
    }

    @Override
    public Boolean getSpecifiedMutable() {
        return this.specifiedMutable;
    }

    @Override
    public void setSpecifiedMutable(Boolean mutable) {
        if (this.valuesAreDifferent(mutable, this.specifiedMutable)) {
            MutableAnnotation annotation = this.getMutableAnnotation();
            if (mutable == null) {
                if (annotation != null) {
                    this.removeMutableAnnotation();
                }
            } else {
                Boolean annotationValue;
                boolean annotationBooleanValue;
                if (annotation == null) {
                    annotation = this.addMutableAnnotation();
                }
                boolean bl = annotationBooleanValue = (annotationValue = annotation.getValue()) == null ? true : annotationValue;
                if (annotationBooleanValue != mutable) {
                    annotation.setValue(mutable);
                }
            }
            this.setSpecifiedMutable_(mutable);
        }
    }

    protected void setSpecifiedMutable_(Boolean mutable) {
        Boolean old = this.specifiedMutable;
        this.specifiedMutable = mutable;
        this.firePropertyChanged("specifiedMutable", old, mutable);
    }

    protected Boolean buildSpecifiedMutable() {
        MutableAnnotation annotation = this.getMutableAnnotation();
        if (annotation == null) {
            return null;
        }
        Boolean annotationValue = annotation.getValue();
        return annotationValue == null ? Boolean.TRUE : annotationValue;
    }

    @Override
    public boolean isDefaultMutable() {
        return this.defaultMutable;
    }

    protected void setDefaultMutable(boolean mutable) {
        boolean old = this.defaultMutable;
        this.defaultMutable = mutable;
        this.firePropertyChanged("defaultMutable", old, mutable);
    }

    protected boolean buildDefaultMutable() {
        EclipseLinkJavaPersistentAttribute javaAttribute = this.getPersistentAttribute();
        if (javaAttribute.typeIsDateOrCalendar()) {
            Boolean puTemporalMutable = this.getPersistenceUnit().getEclipseLinkOptions().getTemporalMutable();
            return puTemporalMutable == null ? false : puTemporalMutable;
        }
        return javaAttribute.typeIsSerializable();
    }

    protected MutableAnnotation getMutableAnnotation() {
        return (MutableAnnotation)this.getResourceAttribute().getAnnotation(this.getMutableAnnotationName());
    }

    protected MutableAnnotation addMutableAnnotation() {
        return (MutableAnnotation)this.getResourceAttribute().addAnnotation(this.getMutableAnnotationName());
    }

    protected void removeMutableAnnotation() {
        this.getResourceAttribute().removeAnnotation(this.getMutableAnnotationName());
    }

    protected String getMutableAnnotationName() {
        return "org.eclipse.persistence.annotations.Mutable";
    }

    protected JavaAttributeMapping getAttributeMapping() {
        return (JavaAttributeMapping)this.parent;
    }

    protected JavaResourceAttribute getResourceAttribute() {
        return this.getAttributeMapping().getResourceAttribute();
    }

    protected EclipseLinkJavaPersistentAttribute getPersistentAttribute() {
        return (EclipseLinkJavaPersistentAttribute)this.getAttributeMapping().getPersistentAttribute();
    }

    public EclipseLinkPersistenceUnit getPersistenceUnit() {
        return (EclipseLinkPersistenceUnit)super.getPersistenceUnit();
    }

    public TextRange getValidationTextRange() {
        TextRange textRange = this.getAnnotationTextRange();
        return textRange != null ? textRange : this.getAttributeMapping().getValidationTextRange();
    }

    protected TextRange getAnnotationTextRange() {
        MutableAnnotation annotation = this.getMutableAnnotation();
        return annotation == null ? null : annotation.getTextRange();
    }
}

