/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm;

import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextModel;
import org.eclipse.jpt.jpa.core.internal.jpa2.context.orm.NullOrmCacheable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.Cacheable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.CacheableReference2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmCacheableReference2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.PersistenceUnit2_0;
import org.eclipse.jpt.jpa.core.resource.orm.XmlTypeMapping;
import org.eclipse.jpt.jpa.core.resource.orm.v2_0.XmlCacheable_2_0;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkCacheCoordinationType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkCacheIsolationType2_2;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkCacheType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkCaching;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkExistenceType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkTimeOfDay;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.EclipseLinkJavaCaching;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.EclipseLinkJavaNonEmbeddableTypeMapping;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.EclipseLinkOrmNonEmbeddableTypeMapping;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.EclipseLinkOrmTimeOfDay;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.EclipseLinkOrmFactory;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlCache;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlCacheHolder;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlTimeOfDay;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkOrmCachingImpl
extends AbstractOrmXmlContextModel<EclipseLinkOrmNonEmbeddableTypeMapping>
implements EclipseLinkCaching,
OrmCacheableReference2_0 {
    protected EclipseLinkCacheType specifiedType;
    protected EclipseLinkCacheType defaultType = DEFAULT_TYPE;
    protected Integer specifiedSize;
    protected int defaultSize = 100;
    protected Boolean specifiedShared;
    protected boolean defaultShared = true;
    protected Boolean specifiedAlwaysRefresh;
    protected boolean defaultAlwaysRefresh = false;
    protected Boolean specifiedRefreshOnlyIfNewer;
    protected boolean defaultRefreshOnlyIfNewer = false;
    protected Boolean specifiedDisableHits;
    protected boolean defaultDisableHits = false;
    protected EclipseLinkCacheCoordinationType specifiedCoordinationType;
    protected EclipseLinkCacheCoordinationType defaultCoordinationType = DEFAULT_COORDINATION_TYPE;
    protected Integer expiry;
    protected EclipseLinkOrmTimeOfDay expiryTimeOfDay;
    protected EclipseLinkExistenceType specifiedExistenceType;
    protected EclipseLinkExistenceType defaultExistenceType = DEFAULT_EXISTENCE_TYPE;
    protected final Cacheable2_0 cacheable;
    protected EclipseLinkCacheIsolationType2_2 specifiedIsolation;
    protected EclipseLinkCacheIsolationType2_2 defaultIsolation = DEFAULT_ISOLATION;

    public EclipseLinkOrmCachingImpl(EclipseLinkOrmNonEmbeddableTypeMapping parent) {
        super((JpaContextModel)parent);
        this.specifiedType = this.buildSpecifiedType();
        this.specifiedSize = this.buildSpecifiedSize();
        this.specifiedShared = this.buildSpecifiedShared();
        this.specifiedAlwaysRefresh = this.buildSpecifiedAlwaysRefresh();
        this.specifiedRefreshOnlyIfNewer = this.buildSpecifiedRefreshOnlyIfNewer();
        this.specifiedDisableHits = this.buildSpecifiedDisableHits();
        this.specifiedCoordinationType = this.buildSpecifiedCoordinationType();
        this.expiry = this.buildExpiry();
        this.expiryTimeOfDay = this.buildExpiryTimeOfDay();
        this.specifiedExistenceType = this.buildSpecifiedExistenceType();
        this.cacheable = this.buildCacheable();
        this.specifiedIsolation = this.buildSpecifiedIsolation();
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedType_(this.buildSpecifiedType());
        this.setSpecifiedSize_(this.buildSpecifiedSize());
        this.setSpecifiedShared_(this.buildSpecifiedShared());
        this.setSpecifiedAlwaysRefresh_(this.buildSpecifiedAlwaysRefresh());
        this.setSpecifiedRefreshOnlyIfNewer_(this.buildSpecifiedRefreshOnlyIfNewer());
        this.setSpecifiedDisableHits_(this.buildSpecifiedDisableHits());
        this.setSpecifiedCoordinationType_(this.buildSpecifiedCoordinationType());
        this.setExpiry_(this.buildExpiry());
        this.syncExpiryTimeOfDay();
        this.setSpecifiedExistenceType_(this.buildSpecifiedExistenceType());
        this.cacheable.synchronizeWithResourceModel();
        this.setSpecifiedIsolation_(this.buildSpecifiedIsolation());
    }

    public void update() {
        super.update();
        boolean xmlCacheNotSpecified = this.getXmlCache() == null;
        EclipseLinkJavaCaching javaCaching = this.getJavaCachingForDefaults();
        boolean javaCacheSpecified = javaCaching != null;
        boolean useJavaValue = xmlCacheNotSpecified && javaCacheSpecified;
        this.setDefaultType(useJavaValue ? javaCaching.getType() : DEFAULT_TYPE);
        this.setDefaultSize(useJavaValue ? javaCaching.getSize() : 100);
        this.setDefaultShared(useJavaValue ? javaCaching.isShared() : true);
        this.setDefaultAlwaysRefresh(useJavaValue ? javaCaching.isAlwaysRefresh() : false);
        this.setDefaultRefreshOnlyIfNewer(useJavaValue ? javaCaching.isRefreshOnlyIfNewer() : false);
        this.setDefaultDisableHits(useJavaValue ? javaCaching.isDisableHits() : false);
        this.setDefaultCoordinationType(useJavaValue ? javaCaching.getCoordinationType() : DEFAULT_COORDINATION_TYPE);
        if (this.expiryTimeOfDay != null) {
            this.expiryTimeOfDay.update();
        }
        this.setDefaultExistenceType(javaCacheSpecified ? javaCaching.getExistenceType() : DEFAULT_EXISTENCE_TYPE);
        this.cacheable.update();
        this.setDefaultIsolation(useJavaValue ? javaCaching.getIsolation() : DEFAULT_ISOLATION);
    }

    @Override
    public EclipseLinkCacheType getType() {
        return this.specifiedType != null ? this.specifiedType : this.defaultType;
    }

    @Override
    public EclipseLinkCacheType getSpecifiedType() {
        return this.specifiedType;
    }

    @Override
    public void setSpecifiedType(EclipseLinkCacheType type) {
        if (this.valuesAreDifferent((Object)this.specifiedType, (Object)type)) {
            XmlCache xmlCache = this.getXmlCacheForUpdate();
            this.setSpecifiedType_(type);
            xmlCache.setType(EclipseLinkCacheType.toOrmResourceModel(type));
            this.removeXmlCacheIfUnset();
        }
        if (type != null) {
            this.setSpecifiedShared(null);
        }
    }

    protected void setSpecifiedType_(EclipseLinkCacheType type) {
        EclipseLinkCacheType old = this.specifiedType;
        this.specifiedType = type;
        this.firePropertyChanged("specifiedType", (Object)old, (Object)type);
    }

    protected EclipseLinkCacheType buildSpecifiedType() {
        XmlCache xmlCache = this.getXmlCache();
        return xmlCache == null ? null : EclipseLinkCacheType.fromOrmResourceModel(xmlCache.getType());
    }

    @Override
    public EclipseLinkCacheType getDefaultType() {
        String puDefaultCacheTypeName = ((EclipseLinkPersistenceUnit)this.getPersistenceUnit()).getDefaultCacheTypePropertyValue();
        if (!StringTools.isBlank((String)puDefaultCacheTypeName)) {
            try {
                return EclipseLinkCacheType.valueOf(StringTools.convertCamelCaseToAllCaps((String)puDefaultCacheTypeName));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return this.defaultType;
    }

    protected void setDefaultType(EclipseLinkCacheType type) {
        EclipseLinkCacheType old = this.defaultType;
        this.defaultType = type;
        this.firePropertyChanged("defaultType", (Object)old, (Object)type);
    }

    @Override
    public int getSize() {
        return this.specifiedSize != null ? this.specifiedSize : this.defaultSize;
    }

    @Override
    public Integer getSpecifiedSize() {
        return this.specifiedSize;
    }

    @Override
    public void setSpecifiedSize(Integer size) {
        if (this.valuesAreDifferent(this.specifiedSize, size)) {
            XmlCache xmlCache = this.getXmlCacheForUpdate();
            this.setSpecifiedSize_(size);
            xmlCache.setSize(size);
            this.removeXmlCacheIfUnset();
        }
        if (size != null) {
            this.setSpecifiedShared(null);
        }
    }

    protected void setSpecifiedSize_(Integer size) {
        Integer old = this.specifiedSize;
        this.specifiedSize = size;
        this.firePropertyChanged("specifiedSize", old, size);
    }

    protected Integer buildSpecifiedSize() {
        XmlCache xmlCache = this.getXmlCache();
        return xmlCache == null ? null : xmlCache.getSize();
    }

    @Override
    public int getDefaultSize() {
        String puDefaultCacheSize = ((EclipseLinkPersistenceUnit)this.getPersistenceUnit()).getDefaultCacheSizePropertyValue();
        if (!StringTools.isBlank((String)puDefaultCacheSize)) {
            try {
                return Integer.valueOf(puDefaultCacheSize);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return this.defaultSize;
    }

    protected void setDefaultSize(int size) {
        int old = this.defaultSize;
        this.defaultSize = size;
        this.firePropertyChanged("defaultSize", old, size);
    }

    @Override
    public boolean isShared() {
        return this.specifiedShared != null ? this.specifiedShared : this.defaultShared;
    }

    @Override
    public Boolean getSpecifiedShared() {
        return this.specifiedShared;
    }

    @Override
    public void setSpecifiedShared(Boolean shared) {
        if (this.valuesAreDifferent(this.specifiedShared, shared)) {
            XmlCache xmlCache = this.getXmlCacheForUpdate();
            this.setSpecifiedShared_(shared);
            xmlCache.setShared(shared);
            this.removeXmlCacheIfUnset();
        }
        if (shared != null && !shared.booleanValue()) {
            this.setSpecifiedType(null);
            this.setSpecifiedSize(null);
            this.setSpecifiedAlwaysRefresh(null);
            this.setSpecifiedRefreshOnlyIfNewer(null);
            this.setSpecifiedDisableHits(null);
            this.setSpecifiedCoordinationType(null);
            this.setExpiry(null);
            this.removeExpiryTimeOfDayIfNecessary();
        }
    }

    protected void setSpecifiedShared_(Boolean shared) {
        Boolean old = this.specifiedShared;
        this.specifiedShared = shared;
        this.firePropertyChanged("specifiedShared", old, shared);
    }

    protected Boolean buildSpecifiedShared() {
        XmlCache xmlCache = this.getXmlCache();
        return xmlCache == null ? null : xmlCache.getShared();
    }

    @Override
    public boolean isDefaultShared() {
        String puDefaultSharedCache = ((EclipseLinkPersistenceUnit)this.getPersistenceUnit()).getDefaultCacheSharedPropertyValue();
        return !StringTools.isBlank((String)puDefaultSharedCache) ? Boolean.valueOf(puDefaultSharedCache) : this.defaultShared;
    }

    protected void setDefaultShared(boolean shared) {
        boolean old = this.defaultShared;
        this.defaultShared = shared;
        this.firePropertyChanged("defaultShared", old, shared);
    }

    @Override
    public boolean isAlwaysRefresh() {
        return this.specifiedAlwaysRefresh != null ? this.specifiedAlwaysRefresh : this.defaultAlwaysRefresh;
    }

    @Override
    public Boolean getSpecifiedAlwaysRefresh() {
        return this.specifiedAlwaysRefresh;
    }

    @Override
    public void setSpecifiedAlwaysRefresh(Boolean alwaysRefresh) {
        if (this.valuesAreDifferent(this.specifiedAlwaysRefresh, alwaysRefresh)) {
            XmlCache xmlCache = this.getXmlCacheForUpdate();
            this.setSpecifiedAlwaysRefresh_(alwaysRefresh);
            xmlCache.setAlwaysRefresh(alwaysRefresh);
            this.removeXmlCacheIfUnset();
        }
        if (alwaysRefresh != null) {
            this.setSpecifiedShared(null);
        }
    }

    protected void setSpecifiedAlwaysRefresh_(Boolean alwaysRefresh) {
        Boolean old = this.specifiedAlwaysRefresh;
        this.specifiedAlwaysRefresh = alwaysRefresh;
        this.firePropertyChanged("specifiedAlwaysRefresh", old, alwaysRefresh);
    }

    protected Boolean buildSpecifiedAlwaysRefresh() {
        XmlCache xmlCache = this.getXmlCache();
        return xmlCache == null ? null : xmlCache.getAlwaysRefresh();
    }

    @Override
    public boolean isDefaultAlwaysRefresh() {
        return this.defaultAlwaysRefresh;
    }

    protected void setDefaultAlwaysRefresh(boolean alwaysRefresh) {
        boolean old = this.defaultAlwaysRefresh;
        this.defaultAlwaysRefresh = alwaysRefresh;
        this.firePropertyChanged("defaultAlwaysRefresh", old, alwaysRefresh);
    }

    @Override
    public boolean isRefreshOnlyIfNewer() {
        return this.specifiedRefreshOnlyIfNewer != null ? this.specifiedRefreshOnlyIfNewer : this.defaultRefreshOnlyIfNewer;
    }

    @Override
    public Boolean getSpecifiedRefreshOnlyIfNewer() {
        return this.specifiedRefreshOnlyIfNewer;
    }

    @Override
    public void setSpecifiedRefreshOnlyIfNewer(Boolean refreshOnlyIfNewer) {
        if (this.valuesAreDifferent(this.specifiedRefreshOnlyIfNewer, refreshOnlyIfNewer)) {
            XmlCache xmlCache = this.getXmlCacheForUpdate();
            this.setSpecifiedRefreshOnlyIfNewer_(refreshOnlyIfNewer);
            xmlCache.setRefreshOnlyIfNewer(refreshOnlyIfNewer);
            this.removeXmlCacheIfUnset();
        }
        if (refreshOnlyIfNewer != null) {
            this.setSpecifiedShared(null);
        }
    }

    protected void setSpecifiedRefreshOnlyIfNewer_(Boolean refreshOnlyIfNewer) {
        Boolean old = this.specifiedRefreshOnlyIfNewer;
        this.specifiedRefreshOnlyIfNewer = refreshOnlyIfNewer;
        this.firePropertyChanged("specifiedRefreshOnlyIfNewer", old, refreshOnlyIfNewer);
    }

    protected Boolean buildSpecifiedRefreshOnlyIfNewer() {
        XmlCache xmlCache = this.getXmlCache();
        return xmlCache == null ? null : xmlCache.getRefreshOnlyIfNewer();
    }

    @Override
    public boolean isDefaultRefreshOnlyIfNewer() {
        return this.defaultRefreshOnlyIfNewer;
    }

    protected void setDefaultRefreshOnlyIfNewer(boolean refreshOnlyIfNewer) {
        boolean old = this.defaultRefreshOnlyIfNewer;
        this.defaultRefreshOnlyIfNewer = refreshOnlyIfNewer;
        this.firePropertyChanged("defaultRefreshOnlyIfNewer", old, refreshOnlyIfNewer);
    }

    @Override
    public boolean isDisableHits() {
        return this.specifiedDisableHits != null ? this.specifiedDisableHits : this.defaultDisableHits;
    }

    @Override
    public Boolean getSpecifiedDisableHits() {
        return this.specifiedDisableHits;
    }

    @Override
    public void setSpecifiedDisableHits(Boolean disableHits) {
        if (this.valuesAreDifferent(this.specifiedDisableHits, disableHits)) {
            XmlCache xmlCache = this.getXmlCacheForUpdate();
            this.setSpecifiedDisableHits_(disableHits);
            xmlCache.setDisableHits(disableHits);
            this.removeXmlCacheIfUnset();
        }
        if (disableHits != null) {
            this.setSpecifiedShared(null);
        }
    }

    protected void setSpecifiedDisableHits_(Boolean disableHits) {
        Boolean old = this.specifiedDisableHits;
        this.specifiedDisableHits = disableHits;
        this.firePropertyChanged("specifiedDisableHits", old, disableHits);
    }

    protected Boolean buildSpecifiedDisableHits() {
        XmlCache xmlCache = this.getXmlCache();
        return xmlCache == null ? null : xmlCache.getDisableHits();
    }

    @Override
    public boolean isDefaultDisableHits() {
        return this.defaultDisableHits;
    }

    protected void setDefaultDisableHits(boolean disableHits) {
        boolean old = this.defaultDisableHits;
        this.defaultDisableHits = disableHits;
        this.firePropertyChanged("defaultDisableHits", old, disableHits);
    }

    @Override
    public EclipseLinkCacheCoordinationType getCoordinationType() {
        return this.specifiedCoordinationType != null ? this.specifiedCoordinationType : this.defaultCoordinationType;
    }

    @Override
    public EclipseLinkCacheCoordinationType getSpecifiedCoordinationType() {
        return this.specifiedCoordinationType;
    }

    @Override
    public void setSpecifiedCoordinationType(EclipseLinkCacheCoordinationType type) {
        if (this.valuesAreDifferent((Object)this.specifiedCoordinationType, (Object)type)) {
            XmlCache xmlCache = this.getXmlCacheForUpdate();
            this.setSpecifiedCoordinationType_(type);
            xmlCache.setCoordinationType(EclipseLinkCacheCoordinationType.toOrmResourceModel(type));
            this.removeXmlCacheIfUnset();
        }
        if (type != null) {
            this.setSpecifiedShared(null);
        }
    }

    protected void setSpecifiedCoordinationType_(EclipseLinkCacheCoordinationType type) {
        EclipseLinkCacheCoordinationType old = this.specifiedCoordinationType;
        this.specifiedCoordinationType = type;
        this.firePropertyChanged("specifiedCoordinationType", (Object)old, (Object)type);
    }

    protected EclipseLinkCacheCoordinationType buildSpecifiedCoordinationType() {
        XmlCache xmlCache = this.getXmlCache();
        return xmlCache == null ? null : EclipseLinkCacheCoordinationType.fromOrmResourceModel(xmlCache.getCoordinationType());
    }

    @Override
    public EclipseLinkCacheCoordinationType getDefaultCoordinationType() {
        return this.defaultCoordinationType;
    }

    protected void setDefaultCoordinationType(EclipseLinkCacheCoordinationType type) {
        EclipseLinkCacheCoordinationType old = this.defaultCoordinationType;
        this.defaultCoordinationType = type;
        this.firePropertyChanged("defaultCoordinationType", (Object)old, (Object)type);
    }

    @Override
    public Integer getExpiry() {
        return this.expiry;
    }

    @Override
    public void setExpiry(Integer expiry) {
        if (this.valuesAreDifferent(this.expiry, expiry)) {
            XmlCache xmlCache = this.getXmlCacheForUpdate();
            this.setExpiry_(expiry);
            xmlCache.setExpiry(expiry);
            this.removeXmlCacheIfUnset();
        }
        if (expiry != null) {
            this.removeExpiryTimeOfDayIfNecessary();
            this.setSpecifiedShared(null);
        }
    }

    protected void setExpiry_(Integer expiry) {
        Integer old = this.expiry;
        this.expiry = expiry;
        this.firePropertyChanged("expiry", old, expiry);
    }

    protected Integer buildExpiry() {
        XmlCache xmlCache = this.getXmlCache();
        return xmlCache == null ? null : xmlCache.getExpiry();
    }

    @Override
    public EclipseLinkTimeOfDay getExpiryTimeOfDay() {
        return this.expiryTimeOfDay;
    }

    @Override
    public EclipseLinkTimeOfDay addExpiryTimeOfDay() {
        if (this.expiryTimeOfDay != null) {
            throw new IllegalStateException("expiry time of day already exists: " + this.expiryTimeOfDay);
        }
        XmlCache xmlCache = this.getXmlCacheForUpdate();
        XmlTimeOfDay xmlTimeOfDay = this.buildXmlTimeOfDay();
        EclipseLinkOrmTimeOfDay timeOfDay = this.buildExpiryTimeOfDay(xmlTimeOfDay);
        this.setExpiryTimeOfDay(timeOfDay);
        xmlCache.setExpiryTimeOfDay(xmlTimeOfDay);
        this.setExpiry(null);
        this.setSpecifiedShared(null);
        return timeOfDay;
    }

    protected XmlTimeOfDay buildXmlTimeOfDay() {
        return EclipseLinkOrmFactory.eINSTANCE.createXmlTimeOfDay();
    }

    @Override
    public void removeExpiryTimeOfDay() {
        if (this.expiryTimeOfDay == null) {
            throw new IllegalStateException("expiry time of day does not exist");
        }
        this.removeExpiryTimeOfDay_();
    }

    protected void removeExpiryTimeOfDayIfNecessary() {
        if (this.expiryTimeOfDay != null) {
            this.removeExpiryTimeOfDay_();
        }
    }

    protected void removeExpiryTimeOfDay_() {
        this.setExpiryTimeOfDay(null);
        this.getXmlCache().setExpiryTimeOfDay(null);
        this.removeXmlCacheIfUnset();
    }

    protected void setExpiryTimeOfDay(EclipseLinkOrmTimeOfDay timeOfDay) {
        EclipseLinkOrmTimeOfDay old = this.expiryTimeOfDay;
        this.expiryTimeOfDay = timeOfDay;
        this.firePropertyChanged("expiryTimeOfDay", old, timeOfDay);
    }

    protected void syncExpiryTimeOfDay() {
        XmlTimeOfDay xmlTimeOfDay = this.getXmlExpiryTimeOfDay();
        if (xmlTimeOfDay == null) {
            if (this.expiryTimeOfDay != null) {
                this.setExpiryTimeOfDay(null);
            }
        } else if (this.expiryTimeOfDay != null && this.expiryTimeOfDay.getXmlTimeOfDay() == xmlTimeOfDay) {
            this.expiryTimeOfDay.synchronizeWithResourceModel();
        } else {
            this.setExpiryTimeOfDay(this.buildExpiryTimeOfDay(xmlTimeOfDay));
        }
    }

    protected EclipseLinkOrmTimeOfDay buildExpiryTimeOfDay() {
        return this.buildExpiryTimeOfDay(this.getXmlExpiryTimeOfDay());
    }

    protected XmlTimeOfDay getXmlExpiryTimeOfDay() {
        XmlCache xmlCache = this.getXmlCache();
        return xmlCache == null ? null : xmlCache.getExpiryTimeOfDay();
    }

    protected EclipseLinkOrmTimeOfDay buildExpiryTimeOfDay(XmlTimeOfDay xmlTimeOfDay) {
        return xmlTimeOfDay == null ? null : new EclipseLinkOrmTimeOfDay(this, xmlTimeOfDay);
    }

    @Override
    public EclipseLinkExistenceType getExistenceType() {
        return this.specifiedExistenceType != null ? this.specifiedExistenceType : this.defaultExistenceType;
    }

    @Override
    public EclipseLinkExistenceType getSpecifiedExistenceType() {
        return this.specifiedExistenceType;
    }

    @Override
    public void setSpecifiedExistenceType(EclipseLinkExistenceType type) {
        if (this.setSpecifiedExistenceType_(type)) {
            this.getXmlCacheHolder().setExistenceChecking(EclipseLinkExistenceType.toOrmResourceModel(type));
        }
    }

    protected boolean setSpecifiedExistenceType_(EclipseLinkExistenceType type) {
        EclipseLinkExistenceType old = this.specifiedExistenceType;
        this.specifiedExistenceType = type;
        return this.firePropertyChanged("specifiedExistenceType", (Object)old, (Object)type);
    }

    protected EclipseLinkExistenceType buildSpecifiedExistenceType() {
        XmlCacheHolder xmlCacheHolder = this.getXmlCacheHolder();
        return xmlCacheHolder == null ? null : EclipseLinkExistenceType.fromOrmResourceModel(xmlCacheHolder.getExistenceChecking());
    }

    @Override
    public EclipseLinkExistenceType getDefaultExistenceType() {
        return this.defaultExistenceType;
    }

    protected void setDefaultExistenceType(EclipseLinkExistenceType type) {
        EclipseLinkExistenceType old = this.defaultExistenceType;
        this.defaultExistenceType = type;
        this.firePropertyChanged("defaultExistenceType", (Object)old, (Object)type);
    }

    public Cacheable2_0 getCacheable() {
        return this.cacheable;
    }

    protected Cacheable2_0 buildCacheable() {
        return this.isOrmXml2_0Compatible() ? this.getContextModelFactory2_0().buildOrmCacheable((OrmCacheableReference2_0)this) : new NullOrmCacheable2_0((OrmCacheableReference2_0)this);
    }

    public boolean calculateDefaultCacheable() {
        JavaPersistentType javaPersistentType;
        if (!this.getTypeMapping().isMetadataComplete() && (javaPersistentType = this.getTypeMapping().getPersistentType().getJavaPersistentType()) != null && javaPersistentType.getMapping() instanceof CacheableReference2_0) {
            return ((CacheableReference2_0)javaPersistentType.getMapping()).getCacheable().isCacheable();
        }
        CacheableReference2_0 superCacheableHolder = this.getCacheableSuperPersistentType((PersistentType)this.getTypeMapping().getPersistentType());
        return superCacheableHolder != null ? superCacheableHolder.getCacheable().isCacheable() : ((PersistenceUnit2_0)this.getPersistenceUnit()).calculateDefaultCacheable();
    }

    protected CacheableReference2_0 getCacheableSuperPersistentType(PersistentType persistentType) {
        PersistentType superPersistentType = persistentType.getSuperPersistentType();
        if (superPersistentType == null) {
            return null;
        }
        TypeMapping superMapping = superPersistentType.getMapping();
        return superMapping instanceof CacheableReference2_0 ? (CacheableReference2_0)superMapping : this.getCacheableSuperPersistentType(superPersistentType);
    }

    @Override
    public EclipseLinkCacheIsolationType2_2 getIsolation() {
        return this.specifiedIsolation != null ? this.specifiedIsolation : this.defaultIsolation;
    }

    @Override
    public EclipseLinkCacheIsolationType2_2 getSpecifiedIsolation() {
        return this.specifiedIsolation;
    }

    @Override
    public void setSpecifiedIsolation(EclipseLinkCacheIsolationType2_2 isolation) {
        if (this.valuesAreDifferent((Object)this.specifiedIsolation, (Object)isolation)) {
            XmlCache xmlCache = this.getXmlCacheForUpdate();
            this.setSpecifiedIsolation_(isolation);
            xmlCache.setIsolation(EclipseLinkCacheIsolationType2_2.toOrmResourceModel(isolation));
            this.removeXmlCacheIfUnset();
        }
        if (isolation != null) {
            this.setSpecifiedShared(null);
        }
    }

    protected void setSpecifiedIsolation_(EclipseLinkCacheIsolationType2_2 isolation) {
        EclipseLinkCacheIsolationType2_2 old = this.specifiedIsolation;
        this.specifiedIsolation = isolation;
        this.firePropertyChanged("specifiedIsolation", (Object)old, (Object)isolation);
    }

    protected EclipseLinkCacheIsolationType2_2 buildSpecifiedIsolation() {
        XmlCache xmlCache = this.getXmlCache();
        return xmlCache == null ? null : EclipseLinkCacheIsolationType2_2.fromOrmResourceModel(xmlCache.getIsolation());
    }

    @Override
    public EclipseLinkCacheIsolationType2_2 getDefaultIsolation() {
        return this.defaultIsolation;
    }

    protected void setDefaultIsolation(EclipseLinkCacheIsolationType2_2 isolation) {
        EclipseLinkCacheIsolationType2_2 old = this.defaultIsolation;
        this.defaultIsolation = isolation;
        this.firePropertyChanged("defaultIsolation", (Object)old, (Object)isolation);
    }

    protected XmlCache getXmlCache() {
        return this.getXmlCacheHolder().getCache();
    }

    protected XmlCache getXmlCacheForUpdate() {
        XmlCache xmlCache = this.getXmlCache();
        return xmlCache != null ? xmlCache : this.buildXmlCache();
    }

    protected XmlCache buildXmlCache() {
        XmlCache xmlCache = EclipseLinkOrmFactory.eINSTANCE.createXmlCache();
        this.getXmlCacheHolder().setCache(xmlCache);
        return xmlCache;
    }

    protected void removeXmlCacheIfUnset() {
        if (this.getXmlCache().isUnset()) {
            this.removeXmlCache();
        }
    }

    protected void removeXmlCache() {
        this.getXmlCacheHolder().setCache(null);
    }

    protected EclipseLinkOrmNonEmbeddableTypeMapping getTypeMapping() {
        return (EclipseLinkOrmNonEmbeddableTypeMapping)this.parent;
    }

    protected XmlTypeMapping getXmlTypeMapping() {
        return this.getTypeMapping().getXmlTypeMapping();
    }

    public XmlCacheable_2_0 getXmlCacheable() {
        return (XmlCacheable_2_0)this.getXmlTypeMapping();
    }

    protected XmlCacheHolder getXmlCacheHolder() {
        return (XmlCacheHolder)this.getXmlTypeMapping();
    }

    protected EclipseLinkJavaNonEmbeddableTypeMapping getJavaTypeMappingForDefaults() {
        return this.getTypeMapping().getJavaTypeMappingForDefaults();
    }

    protected EclipseLinkJavaCaching getJavaCachingForDefaults() {
        EclipseLinkJavaNonEmbeddableTypeMapping javaTypeMapping = this.getJavaTypeMappingForDefaults();
        return javaTypeMapping == null ? null : javaTypeMapping.getCaching();
    }

    public TextRange getValidationTextRange() {
        TextRange textRange = this.getXmlValidationTextRange();
        return textRange != null ? textRange : this.getTypeMapping().getValidationTextRange();
    }

    protected TextRange getXmlValidationTextRange() {
        XmlCache xmlCache = this.getXmlCache();
        return xmlCache == null ? null : xmlCache.getValidationTextRange();
    }
}

