/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.internal.jobs.IBackgroundProcessingQueue;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.jdt.MavenJdtPlugin;
import org.eclipse.m2e.jdt.internal.BuildPathManager;
import org.eclipse.m2e.jdt.internal.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DownloadSourcesJob
extends Job
implements IBackgroundProcessingQueue {
    private static Logger log = LoggerFactory.getLogger(DownloadSourcesJob.class);
    private static final long SCHEDULE_INTERVAL = 1000L;
    private final IMaven maven;
    private final BuildPathManager manager;
    private final IMavenProjectRegistry projectManager;
    private final ArrayList<DownloadRequest> queue = new ArrayList();

    public DownloadSourcesJob(BuildPathManager manager) {
        super(Messages.DownloadSourcesJob_job_download);
        this.manager = manager;
        this.maven = MavenPlugin.getMaven();
        this.projectManager = MavenPlugin.getMavenProjectRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus run(IProgressMonitor monitor) {
        ArrayList<DownloadRequest> downloadRequests;
        ArrayList<DownloadRequest> arrayList = this.queue;
        synchronized (arrayList) {
            downloadRequests = new ArrayList<DownloadRequest>(this.queue);
            this.queue.clear();
        }
        ArrayList<IStatus> exceptions = new ArrayList<IStatus>();
        LinkedHashSet<IProject> mavenProjects = new LinkedHashSet<IProject>();
        LinkedHashMap<IPackageFragmentRoot, File[]> nonMavenProjects = new LinkedHashMap<IPackageFragmentRoot, File[]>();
        for (DownloadRequest request : downloadRequests) {
            try {
                IMavenProjectFacade projectFacade = this.projectManager.create(request.project, monitor);
                if (projectFacade != null) {
                    this.downloadMaven(projectFacade, request.artifact, request.downloadSources, request.downloadJavaDoc, monitor);
                    mavenProjects.add(request.project);
                    continue;
                }
                if (request.artifact == null) continue;
                List repositories = this.maven.getArtifactRepositories();
                File[] files = this.downloadAttachments(request.artifact, repositories, request.downloadSources, request.downloadJavaDoc, monitor);
                nonMavenProjects.put(request.fragment, files);
            }
            catch (CoreException ex) {
                exceptions.add(ex.getStatus());
            }
        }
        if (!mavenProjects.isEmpty() || !nonMavenProjects.isEmpty()) {
            ISchedulingRule schedulingRule = ResourcesPlugin.getWorkspace().getRuleFactory().buildRule();
            DownloadSourcesJob.getJobManager().beginRule(schedulingRule, monitor);
            try {
                for (IProject iProject : mavenProjects) {
                    this.manager.updateClasspath(iProject, monitor);
                }
                for (Map.Entry entry : nonMavenProjects.entrySet()) {
                    File[] files = (File[])entry.getValue();
                    this.manager.attachSourcesAndJavadoc((IPackageFragmentRoot)entry.getKey(), files[0], files[1], monitor);
                }
            }
            finally {
                DownloadSourcesJob.getJobManager().endRule(schedulingRule);
            }
        }
        if (!exceptions.isEmpty()) {
            IStatus[] problems = exceptions.toArray(new IStatus[exceptions.size()]);
            return new MultiStatus(MavenJdtPlugin.PLUGIN_ID, -1, problems, "Could not download sources or javadoc", null);
        }
        return Status.OK_STATUS;
    }

    private void downloadMaven(IMavenProjectFacade projectFacade, ArtifactKey artifact, boolean downloadSources, boolean downloadJavadoc, IProgressMonitor monitor) throws CoreException {
        MavenProject mavenProject = projectFacade.getMavenProject(monitor);
        List repositories = mavenProject.getRemoteArtifactRepositories();
        if (artifact != null) {
            this.downloadAttachments(artifact, repositories, downloadSources, downloadJavadoc, monitor);
        } else {
            for (Artifact a : mavenProject.getArtifacts()) {
                ArtifactKey aKey = new ArtifactKey(a.getGroupId(), a.getArtifactId(), a.getBaseVersion(), a.getClassifier());
                this.downloadAttachments(aKey, repositories, downloadSources, downloadJavadoc, monitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File[] downloadAttachments(ArtifactKey artifact, List<ArtifactRepository> repositories, boolean downloadSources, boolean downloadJavadoc, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            String message = "Downloading of sources/javadocs was canceled";
            log.debug(message);
            ArrayList<DownloadRequest> arrayList = this.queue;
            synchronized (arrayList) {
                this.queue.clear();
            }
            throw new OperationCanceledException(message);
        }
        ArtifactKey[] attached = this.manager.getAttachedSourcesAndJavadoc(artifact, repositories, downloadSources, downloadJavadoc);
        File[] files = new File[2];
        if (attached[0] != null) {
            try {
                files[0] = this.download(attached[0], repositories, monitor);
                log.info("Downloaded sources for " + artifact.toString());
            }
            catch (CoreException e) {
                log.error("Could not download sources for " + artifact.toString(), (Throwable)e);
            }
        }
        if (attached[1] != null) {
            try {
                files[1] = this.download(attached[1], repositories, monitor);
                log.info("Downloaded javadoc for " + artifact.toString());
            }
            catch (CoreException e) {
                log.error("Could not download sources for " + artifact.toString(), (Throwable)e);
            }
        }
        return files;
    }

    private File download(ArtifactKey artifact, List<ArtifactRepository> repositories, IProgressMonitor monitor) throws CoreException {
        Artifact resolved = this.maven.resolve(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "jar", artifact.getClassifier(), repositories, monitor);
        return resolved.getFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleDownload(IProject project, IPackageFragmentRoot fragment, ArtifactKey artifact, boolean downloadSources, boolean downloadJavadoc) {
        if (project == null || !project.isAccessible()) {
            return;
        }
        ArrayList<DownloadRequest> arrayList = this.queue;
        synchronized (arrayList) {
            this.queue.add(new DownloadRequest(project, fragment, artifact, downloadSources, downloadJavadoc));
        }
        this.schedule(1000L);
    }

    public void scheduleDownload(IProject project, ArtifactKey artifact, boolean downloadSources, boolean downloadJavadoc) {
        this.scheduleDownload(project, null, artifact, downloadSources, downloadJavadoc);
    }

    public void scheduleDownload(IPackageFragmentRoot fragment, ArtifactKey artifact, boolean downloadSources, boolean downloadJavadoc) {
        IProject project = fragment.getJavaProject().getProject();
        this.scheduleDownload(project, fragment, artifact, downloadSources, downloadJavadoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        ArrayList<DownloadRequest> arrayList = this.queue;
        synchronized (arrayList) {
            return this.queue.isEmpty();
        }
    }

    private static class DownloadRequest {
        final IProject project;
        final IPackageFragmentRoot fragment;
        final ArtifactKey artifact;
        final boolean downloadSources;
        final boolean downloadJavaDoc;

        public DownloadRequest(IProject project, IPackageFragmentRoot fragment, ArtifactKey artifact, boolean downloadSources, boolean downloadJavaDoc) {
            this.project = project;
            this.fragment = fragment;
            this.artifact = artifact;
            this.downloadSources = downloadSources;
            this.downloadJavaDoc = downloadJavaDoc;
        }

        public int hashCode() {
            int hash = 17;
            hash = hash * 31 + this.project.hashCode();
            hash = hash * 31 + (this.fragment != null ? this.fragment.hashCode() : 0);
            hash = hash * 31 + (this.artifact != null ? this.artifact.hashCode() : 0);
            hash = hash * 31 + (this.downloadSources ? 1 : 0);
            hash = hash * 31 + (this.downloadJavaDoc ? 1 : 0);
            return hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DownloadRequest)) {
                return false;
            }
            DownloadRequest other = (DownloadRequest)o;
            return this.project.equals((Object)other.project) && (this.fragment != null ? this.fragment.equals(other.fragment) : other.fragment == null) && (this.artifact != null ? this.artifact.equals((Object)other.artifact) : other.artifact == null) && this.downloadSources == other.downloadSources && this.downloadJavaDoc == other.downloadJavaDoc;
        }
    }
}

