/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.ContentTypeReference;
import org.eclipse.jpt.common.core.JptResourceModel;
import org.eclipse.jpt.common.core.JptResourceModelListener;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryTypeCache;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceTypeCompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.ContentTypeTools;
import org.eclipse.jpt.common.core.internal.utility.ValidationMessageTools;
import org.eclipse.jpt.common.core.resource.ProjectResourceLocator;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackage;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackageFragmentRoot;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackageInfoCompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceTypeCache;
import org.eclipse.jpt.common.core.utility.ValidationMessage;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.command.CommandContext;
import org.eclipse.jpt.common.utility.command.ExtendedCommandContext;
import org.eclipse.jpt.common.utility.internal.BitTools;
import org.eclipse.jpt.common.utility.internal.command.ThreadLocalExtendedCommandContext;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jaxb.core.JaxbFile;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.SchemaLibrary;
import org.eclipse.jpt.jaxb.core.context.JaxbContextNode;
import org.eclipse.jpt.jaxb.core.context.JaxbContextRoot;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbPackageInfo;
import org.eclipse.jpt.jaxb.core.context.java.JavaType;
import org.eclipse.jpt.jaxb.core.internal.AbstractJaxbNode;
import org.eclipse.jpt.jaxb.core.internal.SchemaLibraryImpl;
import org.eclipse.jpt.jaxb.core.internal.platform.JaxbPlatformImpl;
import org.eclipse.jpt.jaxb.core.internal.plugin.JptJaxbCorePlugin;
import org.eclipse.jpt.jaxb.core.internal.utility.CallbackSynchronousSynchronizer;
import org.eclipse.jpt.jaxb.core.internal.utility.SynchronousSynchronizer;
import org.eclipse.jpt.jaxb.core.libprov.JaxbLibraryProviderInstallOperationConfig;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatform;
import org.eclipse.jpt.jaxb.core.resource.jaxbindex.JaxbIndexResource;
import org.eclipse.jpt.jaxb.core.resource.jaxbprops.JaxbPropertiesResource;
import org.eclipse.jpt.jaxb.core.utility.CallbackSynchronizer;
import org.eclipse.jpt.jaxb.core.utility.Synchronizer;
import org.eclipse.jpt.jaxb.core.validation.JptJaxbCoreValidationMessages;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJaxbProject
extends AbstractJaxbNode
implements JaxbProject {
    protected final IProject project;
    protected final JaxbPlatform jaxbPlatform;
    protected final SchemaLibraryImpl schemaLibrary;
    protected final Vector<JaxbFile> jaxbFiles = new Vector();
    protected final Vector<JavaResourceCompilationUnit> externalJavaResourceCompilationUnits = new Vector();
    protected final JavaResourceTypeCache externalJavaResourceTypeCache;
    protected final JptResourceModelListener resourceModelListener;
    protected final JaxbContextRoot contextRoot;
    protected volatile Synchronizer contextModelSynchronizer;
    protected volatile boolean synchronizingContextModel = false;
    protected volatile CallbackSynchronizer updateSynchronizer;
    protected final CallbackSynchronizer.Listener updateSynchronizerListener;
    protected final ThreadLocalExtendedCommandContext modifySharedDocumentCommandContext;

    protected AbstractJaxbProject(JaxbProject.Config config) {
        super(null);
        if (config.getProject() == null || config.getPlatformDefinition() == null) {
            throw new NullPointerException();
        }
        this.project = config.getProject();
        this.jaxbPlatform = new JaxbPlatformImpl(config.getPlatformDefinition());
        this.schemaLibrary = new SchemaLibraryImpl(this);
        this.modifySharedDocumentCommandContext = this.buildModifySharedDocumentCommandContext();
        this.resourceModelListener = this.buildResourceModelListener();
        InitialResourceProxyVisitor visitor = this.buildInitialResourceProxyVisitor();
        visitor.visitProject(this.project);
        this.externalJavaResourceTypeCache = this.buildExternalJavaResourceTypeCache();
        this.contextRoot = this.buildContextRoot();
        this.setContextModelSynchronizer_(this.buildSynchronousContextModelSynchronizer());
        this.updateSynchronizerListener = this.buildUpdateSynchronizerListener();
        this.setUpdateSynchronizer_(this.buildSynchronousUpdateSynchronizer());
        this.externalJavaResourceTypeCache.addResourceModelListener(this.resourceModelListener);
    }

    @Override
    protected boolean requiresParent() {
        return false;
    }

    @Override
    public IResource getResource() {
        return this.project;
    }

    protected ThreadLocalExtendedCommandContext buildModifySharedDocumentCommandContext() {
        return new ThreadLocalExtendedCommandContext();
    }

    protected InitialResourceProxyVisitor buildInitialResourceProxyVisitor() {
        return new InitialResourceProxyVisitor();
    }

    protected JavaResourceTypeCache buildExternalJavaResourceTypeCache() {
        return new BinaryTypeCache(this.jaxbPlatform.getAnnotationProvider());
    }

    protected JaxbContextRoot buildContextRoot() {
        return this.getFactory().buildContextRoot(this);
    }

    @Override
    protected void addNonUpdateAspectNamesTo(Set<String> nonUpdateAspectNames) {
        super.addNonUpdateAspectNamesTo(nonUpdateAspectNames);
        nonUpdateAspectNames.add("externalJavaResourceCompilationUnits");
    }

    @Override
    public JaxbProject getJaxbProject() {
        return this;
    }

    @Override
    public String getName() {
        return this.project.getName();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public IJavaProject getJavaProject() {
        return JavaCore.create((IProject)this.project);
    }

    @Override
    public JaxbPlatform getPlatform() {
        return this.jaxbPlatform;
    }

    @Override
    public SchemaLibrary getSchemaLibrary() {
        return this.schemaLibrary;
    }

    protected Iterable<JavaResourceCompilationUnit> getCombinedJavaResourceCompilationUnits() {
        return IterableTools.concatenate((Iterable[])new Iterable[]{this.getInternalJavaResourceCompilationUnits(), this.getExternalJavaResourceCompilationUnits()});
    }

    @Override
    public Iterable<JaxbFile> getJaxbFiles() {
        return IterableTools.cloneLive(this.jaxbFiles);
    }

    @Override
    public int getJaxbFilesSize() {
        return this.jaxbFiles.size();
    }

    protected Iterable<JaxbFile> getJaxbFiles(IContentType contentType) {
        return IterableTools.filter(this.getJaxbFiles(), (Predicate)new ContentTypeReference.ContentTypeIsKindOf(contentType));
    }

    @Override
    public JaxbFile getJaxbFile(IFile file) {
        for (JaxbFile jaxbFile : this.getJaxbFiles()) {
            if (!jaxbFile.getFile().equals((Object)file)) continue;
            return jaxbFile;
        }
        return null;
    }

    protected boolean addJaxbFile(IFile file) {
        JaxbFile jaxbFile = this.addJaxbFile_(file);
        if (jaxbFile != null) {
            this.fireItemAdded("jaxbFiles", jaxbFile);
            return true;
        }
        return false;
    }

    protected JaxbFile addJaxbFile_(IFile file) {
        if (this.isJavaFile(file) ? !this.getJavaProject().isOnClasspath((IResource)file) : !this.fileResourceLocationIsValid(file)) {
            return null;
        }
        JaxbFile jaxbFile = null;
        try {
            jaxbFile = this.getPlatform().buildJaxbFile(this, file);
        }
        catch (Exception e) {
            JptJaxbCorePlugin.instance().logError(e);
        }
        if (jaxbFile == null) {
            return null;
        }
        jaxbFile.getResourceModel().addResourceModelListener(this.resourceModelListener);
        this.jaxbFiles.add(jaxbFile);
        return jaxbFile;
    }

    protected boolean isJavaFile(IFile file) {
        IContentType contentType = ContentTypeTools.contentType((IFile)file);
        return contentType != null && (contentType.isKindOf(JavaResourceCompilationUnit.CONTENT_TYPE) || contentType.isKindOf(JavaResourcePackageFragmentRoot.JAR_CONTENT_TYPE));
    }

    protected boolean fileResourceLocationIsValid(IFile file) {
        return this.getProjectResourceLocator().locationIsValid(file.getParent());
    }

    protected ProjectResourceLocator getProjectResourceLocator() {
        return (ProjectResourceLocator)this.project.getAdapter(ProjectResourceLocator.class);
    }

    protected boolean removeJaxbFile(IFile file) {
        JaxbFile jaxbFile = this.getJaxbFile(file);
        if (jaxbFile != null) {
            this.removeJaxbFile(jaxbFile);
            return true;
        }
        return false;
    }

    protected void removeJaxbFile(JaxbFile jaxbFile) {
        jaxbFile.getResourceModel().removeResourceModelListener(this.resourceModelListener);
        if (!this.removeItemFromCollection(jaxbFile, this.jaxbFiles, "jaxbFiles")) {
            throw new IllegalArgumentException(jaxbFile.toString());
        }
    }

    protected JavaResourceAbstractType buildExternalJavaResourceType(String typeName) {
        if (typeName != null) {
            IType jdtType = this.findType(typeName);
            return jdtType == null ? null : this.buildExternalJavaResourceType(jdtType);
        }
        return null;
    }

    protected IType findType(String typeName) {
        try {
            return typeName.startsWith(".") ? null : this.getJavaProject().findType(typeName);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    protected JavaResourceAbstractType buildExternalJavaResourceType(IType jdtType) {
        return jdtType.isBinary() ? this.buildBinaryExternalJavaResourceType(jdtType) : this.buildSourceExternalJavaResourceType(jdtType);
    }

    protected JavaResourceAbstractType buildBinaryExternalJavaResourceType(IType jdtType) {
        return this.externalJavaResourceTypeCache.addType(jdtType);
    }

    protected JavaResourceAbstractType buildSourceExternalJavaResourceType(IType jdtType) {
        JavaResourceCompilationUnit jrcu = this.getExternalJavaResourceCompilationUnit(jdtType.getCompilationUnit());
        String jdtTypeName = jdtType.getFullyQualifiedName('.');
        for (JavaResourceAbstractType jrat : jrcu.getTypes()) {
            if (!jrat.getTypeBinding().getQualifiedName().equals(jdtTypeName)) continue;
            return jrat;
        }
        return null;
    }

    @Override
    public JavaResourceTypeCache getExternalJavaResourceTypeCache() {
        return this.externalJavaResourceTypeCache;
    }

    @Override
    public Iterable<JavaResourceCompilationUnit> getExternalJavaResourceCompilationUnits() {
        return IterableTools.cloneLive(this.externalJavaResourceCompilationUnits);
    }

    @Override
    public int getExternalJavaResourceCompilationUnitsSize() {
        return this.externalJavaResourceCompilationUnits.size();
    }

    protected JavaResourceCompilationUnit getExternalJavaResourceCompilationUnit(ICompilationUnit jdtCompilationUnit) {
        for (JavaResourceCompilationUnit jrcu : this.getExternalJavaResourceCompilationUnits()) {
            if (!jrcu.getCompilationUnit().equals(jdtCompilationUnit)) continue;
            return jrcu;
        }
        return this.addExternalJavaResourceCompilationUnit(jdtCompilationUnit);
    }

    protected JavaResourceCompilationUnit addExternalJavaResourceCompilationUnit(ICompilationUnit jdtCompilationUnit) {
        JavaResourceCompilationUnit jrcu = this.buildJavaResourceCompilationUnit(jdtCompilationUnit);
        this.addItemToCollection(jrcu, this.externalJavaResourceCompilationUnits, "externalJavaResourceCompilationUnits");
        jrcu.addResourceModelListener(this.resourceModelListener);
        return jrcu;
    }

    protected JavaResourceCompilationUnit buildJavaResourceCompilationUnit(ICompilationUnit jdtCompilationUnit) {
        return new SourceTypeCompilationUnit(jdtCompilationUnit, this.jaxbPlatform.getAnnotationProvider(), this.jaxbPlatform.getAnnotationEditFormatter(), (CommandContext)this.modifySharedDocumentCommandContext);
    }

    protected boolean removeExternalJavaResourceCompilationUnit(IFile file) {
        for (JavaResourceCompilationUnit jrcu : this.getExternalJavaResourceCompilationUnits()) {
            if (!jrcu.getFile().equals((Object)file)) continue;
            this.removeExternalJavaResourceCompilationUnit(jrcu);
            return true;
        }
        return false;
    }

    protected void removeExternalJavaResourceCompilationUnit(JavaResourceCompilationUnit jrcu) {
        jrcu.removeResourceModelListener(this.resourceModelListener);
        this.removeItemFromCollection(jrcu, this.externalJavaResourceCompilationUnits, "externalJavaResourceCompilationUnits");
    }

    @Override
    public JaxbContextRoot getContextRoot() {
        return this.contextRoot;
    }

    @Override
    public Iterable<? extends JaxbContextNode> getPrimaryJavaNodes(ICompilationUnit cu) {
        IFile file = this.getCorrespondingResource(cu);
        if (file == null) {
            return EmptyIterable.instance();
        }
        IContentType contentType = ContentTypeTools.contentType((IFile)file);
        if (contentType == null) {
            return EmptyIterable.instance();
        }
        if (contentType.isKindOf(JavaResourceCompilationUnit.PACKAGE_INFO_CONTENT_TYPE)) {
            try {
                return IterableTools.removeNulls((Iterable)IterableTools.transform((Iterable)IterableTools.iterable((Object[])cu.getPackageDeclarations()), (Transformer)new PackageDeclarationTransformer()));
            }
            catch (JavaModelException javaModelException) {
                return EmptyIterable.instance();
            }
        }
        if (contentType.isKindOf(JavaResourceCompilationUnit.CONTENT_TYPE)) {
            try {
                return IterableTools.removeNulls((Iterable)IterableTools.transform((Iterable)IterableTools.iterable((Object[])cu.getAllTypes()), (Transformer)new TypeTransformer()));
            }
            catch (JavaModelException javaModelException) {
                return EmptyIterable.instance();
            }
        }
        return EmptyIterable.instance();
    }

    private IFile getCorrespondingResource(ICompilationUnit cu) {
        try {
            return (IFile)cu.getCorrespondingResource();
        }
        catch (JavaModelException ex) {
            JptJaxbCorePlugin.instance().logError(ex);
            return null;
        }
    }

    @Override
    public Iterable<JavaResourceAbstractType> getJavaSourceResourceTypes() {
        return IterableTools.children(this.getInternalJavaResourceCompilationUnits(), (Transformer)JavaResourceModel.Root.TYPES_TRANSFORMER);
    }

    @Override
    public Iterable<JavaResourceAbstractType> getAnnotatedJavaSourceResourceTypes() {
        return IterableTools.filter(this.getJavaSourceResourceTypes(), (Predicate)JavaResourceAnnotatedElement.IS_ANNOTATED);
    }

    protected Iterable<JavaResourceCompilationUnit> getInternalJavaResourceCompilationUnits() {
        return IterableTools.downCast((Iterable)IterableTools.transform(this.getJavaSourceJaxbFiles(), JaxbFile.RESOURCE_MODEL_TRANSFORMER));
    }

    protected Iterable<JaxbFile> getJavaSourceJaxbFiles() {
        return this.getJaxbFiles(JavaResourceCompilationUnit.CONTENT_TYPE);
    }

    @Override
    public Iterable<JavaResourcePackage> getJavaResourcePackages() {
        return IterableTools.removeNulls((Iterable)IterableTools.transform(this.getPackageInfoSourceJaxbFiles(), (Transformer)new JaxbFileTransformer()));
    }

    @Override
    public JavaResourcePackage getJavaResourcePackage(String packageName) {
        for (JavaResourcePackage jrp : this.getJavaResourcePackages()) {
            if (!jrp.getName().equals(packageName)) continue;
            return jrp;
        }
        return null;
    }

    @Override
    public Iterable<JavaResourcePackage> getAnnotatedJavaResourcePackages() {
        return IterableTools.filter(this.getJavaResourcePackages(), (Predicate)JavaResourceAnnotatedElement.IS_ANNOTATED);
    }

    @Override
    public JavaResourcePackage getAnnotatedJavaResourcePackage(String packageName) {
        JavaResourcePackage jrp = this.getJavaResourcePackage(packageName);
        return jrp != null && jrp.isAnnotated() ? jrp : null;
    }

    protected Iterable<JaxbFile> getPackageInfoSourceJaxbFiles() {
        return this.getJaxbFiles(JavaResourceCompilationUnit.PACKAGE_INFO_CONTENT_TYPE);
    }

    @Override
    public JavaResourceAbstractType getJavaResourceType(String typeName) {
        for (JavaResourceAbstractType type : this.getJavaResourceTypes()) {
            if (!type.getTypeBinding().getQualifiedName().equals(typeName)) continue;
            return type;
        }
        return this.buildExternalJavaResourceType(typeName);
    }

    @Override
    public JavaResourceAbstractType getJavaResourceType(String typeName, JavaResourceAnnotatedElement.AstNodeType astNodeType) {
        JavaResourceAbstractType resourceType = this.getJavaResourceType(typeName);
        if (resourceType == null || resourceType.getAstNodeType() != astNodeType) {
            return null;
        }
        return resourceType;
    }

    protected Iterable<JavaResourceAbstractType> getJavaResourceTypes() {
        return IterableTools.children(this.getJavaResourceModelRoots(), (Transformer)JavaResourceModel.Root.TYPES_TRANSFORMER);
    }

    protected Iterable<JavaResourceModel.Root> getJavaResourceModelRoots() {
        return IterableTools.concatenate((Iterable[])new Iterable[]{this.getInternalJavaResourceCompilationUnits(), this.getExternalJavaResourceCompilationUnits(), Collections.singleton(this.externalJavaResourceTypeCache)});
    }

    @Override
    public Iterable<JaxbIndexResource> getJaxbIndexResources() {
        return IterableTools.downCast((Iterable)IterableTools.transform(this.getJaxbFiles(JaxbIndexResource.CONTENT_TYPE), JaxbFile.RESOURCE_MODEL_TRANSFORMER));
    }

    @Override
    public JaxbIndexResource getJaxbIndexResource(String packageName) {
        for (JaxbIndexResource jir : this.getJaxbIndexResources()) {
            if (!packageName.equals(jir.getPackageName())) continue;
            return jir;
        }
        return null;
    }

    @Override
    public Iterable<JaxbPropertiesResource> getJaxbPropertiesResources() {
        return IterableTools.downCast((Iterable)IterableTools.transform(this.getJaxbFiles(JaxbPropertiesResource.CONTENT_TYPE), JaxbFile.RESOURCE_MODEL_TRANSFORMER));
    }

    @Override
    public JaxbPropertiesResource getJaxbPropertiesResource(String packageName) {
        for (JaxbPropertiesResource jpr : this.getJaxbPropertiesResources()) {
            if (!packageName.equals(jpr.getPackageName())) continue;
            return jpr;
        }
        return null;
    }

    @Override
    public void javaElementChanged(ElementChangedEvent event) {
        this.processJavaDelta(event.getDelta());
    }

    protected void processJavaDelta(IJavaElementDelta delta) {
        switch (delta.getElement().getElementType()) {
            case 1: {
                this.processJavaModelDelta(delta);
                break;
            }
            case 2: {
                this.processJavaProjectDelta(delta);
                break;
            }
            case 3: {
                this.processJavaPackageFragmentRootDelta(delta);
                break;
            }
            case 4: {
                this.processJavaPackageFragmentDelta(delta);
                break;
            }
            case 5: {
                this.processJavaCompilationUnitDelta(delta);
                break;
            }
        }
    }

    protected void processJavaDeltaChildren(IJavaElementDelta delta) {
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta child = iJavaElementDeltaArray[n2];
            this.processJavaDelta(child);
            ++n2;
        }
    }

    protected boolean deltaFlagIsSet(IJavaElementDelta delta, int flag) {
        return delta.getKind() == 4 && BitTools.flagIsSet((int)delta.getFlags(), (int)flag);
    }

    protected void processJavaModelDelta(IJavaElementDelta delta) {
        this.processJavaDeltaChildren(delta);
    }

    protected void processJavaProjectDelta(IJavaElementDelta delta) {
        this.processJavaDeltaChildren(delta);
        if (this.classpathHasChanged(delta)) {
            this.rebuild((IJavaProject)delta.getElement());
        }
    }

    protected void rebuild(IJavaProject javaProject) {
        if (javaProject.equals(this.getJavaProject())) {
            this.removeDeadJpaFiles();
            this.synchronizeWithJavaSource(this.getInternalJavaResourceCompilationUnits());
        } else {
            this.synchronizeWithJavaSource(this.getExternalJavaResourceCompilationUnits());
        }
    }

    protected void removeDeadJpaFiles() {
        for (JaxbFile jaxbFile : this.getJaxbFiles()) {
            if (!this.jaxbFileIsDead(jaxbFile)) continue;
            this.removeJaxbFile(jaxbFile);
        }
    }

    protected boolean jaxbFileIsDead(JaxbFile jaxbFile) {
        return !this.jaxbFileIsAlive(jaxbFile);
    }

    protected boolean jaxbFileIsAlive(JaxbFile jaxbFile) {
        IFile file = jaxbFile.getFile();
        return this.getJavaProject().isOnClasspath((IResource)file) && file.exists();
    }

    protected boolean classpathHasChanged(IJavaElementDelta delta) {
        return this.deltaFlagIsSet(delta, 0x200000);
    }

    protected void synchronizeWithJavaSource(Iterable<JavaResourceCompilationUnit> javaResourceCompilationUnits) {
        for (JavaResourceCompilationUnit javaResourceCompilationUnit : javaResourceCompilationUnits) {
            javaResourceCompilationUnit.synchronizeWithJavaSource();
        }
    }

    protected void processJavaPackageFragmentRootDelta(IJavaElementDelta delta) {
        this.processJavaDeltaChildren(delta);
        if (!this.classpathEntryHasBeenAdded(delta)) {
            this.classpathEntryHasBeenRemoved(delta);
        }
    }

    protected boolean classpathEntryHasBeenAdded(IJavaElementDelta delta) {
        return this.deltaFlagIsSet(delta, 64);
    }

    protected boolean classpathEntryHasBeenRemoved(IJavaElementDelta delta) {
        return this.deltaFlagIsSet(delta, 128);
    }

    protected void processJavaPackageFragmentDelta(IJavaElementDelta delta) {
        this.processJavaDeltaChildren(delta);
    }

    protected void processJavaCompilationUnitDelta(IJavaElementDelta delta) {
        if (this.javaCompilationUnitDeltaIsRelevant(delta)) {
            ICompilationUnit compilationUnit = (ICompilationUnit)delta.getElement();
            for (JavaResourceCompilationUnit jrcu : this.getCombinedJavaResourceCompilationUnits()) {
                if (!jrcu.getCompilationUnit().equals(compilationUnit)) continue;
                jrcu.synchronizeWithJavaSource();
                break;
            }
        }
    }

    protected boolean javaCompilationUnitDeltaIsRelevant(IJavaElementDelta delta) {
        if (BitTools.onlyFlagIsSet((int)delta.getFlags(), (int)65536)) {
            return false;
        }
        return delta.getKind() == 4;
    }

    @Override
    public Iterable<IMessage> getValidationMessages(IReporter reporter) {
        ArrayList<IMessage> messages = new ArrayList<IMessage>();
        this.validate(messages, reporter);
        return IterableTools.cloneSnapshot(messages);
    }

    protected void validate(List<IMessage> messages, IReporter reporter) {
        if (reporter.isCancelled()) {
            throw new ValidationCancelledException();
        }
        this.getSchemaLibrary().refreshAllSchemas();
        this.validateLibraryProvider(messages);
        this.validateSchemaLibrary(messages);
        this.contextRoot.validate(messages, reporter);
    }

    protected void validateLibraryProvider(List<IMessage> messages) {
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)this.getProject());
        }
        catch (CoreException ce) {
            JptJaxbCorePlugin.instance().logError(ce);
            return;
        }
        IProjectFacetVersion facetVersion = facetedProject.getInstalledVersion(JaxbProject.FACET);
        LibraryInstallDelegate lid = new LibraryInstallDelegate((IFacetedProjectBase)facetedProject, facetVersion);
        ILibraryProvider lp = lid.getLibraryProvider();
        if (lid.getLibraryProviderOperationConfig() instanceof JaxbLibraryProviderInstallOperationConfig) {
            ((JaxbLibraryProviderInstallOperationConfig)lid.getLibraryProviderOperationConfig()).setJaxbPlatformConfig(this.getPlatform().getConfig());
        }
        if (!lp.isEnabledFor((IFacetedProjectBase)facetedProject, facetVersion) || !lid.validate().isOK()) {
            messages.add(ValidationMessageTools.buildValidationMessage((IResource)this.project, (ValidationMessage)JptJaxbCoreValidationMessages.PROJECT_INVALID_LIBRARY_PROVIDER));
        }
        lid.dispose();
    }

    protected void validateSchemaLibrary(List<IMessage> messages) {
        this.schemaLibrary.validate(messages);
    }

    @Override
    public void dispose() {
        this.contextModelSynchronizer.stop();
        this.updateSynchronizer.stop();
        this.updateSynchronizer.removeListener(this.updateSynchronizerListener);
        this.schemaLibrary.dispose();
        for (JaxbFile jaxbFile : this.getJaxbFiles()) {
            jaxbFile.getResourceModel().removeResourceModelListener(this.resourceModelListener);
        }
    }

    protected JptResourceModelListener buildResourceModelListener() {
        return new DefaultResourceModelListener();
    }

    protected void synchronizeContextModel(JptResourceModel jpaResourceModel) {
        this.synchronizeContextModel();
    }

    @Override
    public void projectChanged(IResourceDelta delta) {
        if (delta.getResource().equals((Object)this.getProject())) {
            this.internalProjectChanged(delta);
        } else {
            this.externalProjectChanged(delta);
        }
    }

    protected void internalProjectChanged(IResourceDelta delta) {
        ResourceDeltaVisitor resourceDeltaVisitor = this.buildInternalResourceDeltaVisitor();
        resourceDeltaVisitor.visitDelta(delta);
        if (resourceDeltaVisitor.encounteredSignificantChange()) {
            this.resolveInternalJavaTypes();
        }
    }

    protected ResourceDeltaVisitor buildInternalResourceDeltaVisitor() {
        return new ResourceDeltaVisitor(){

            public boolean fileChangeIsSignificant(IFile file, int deltaKind) {
                return AbstractJaxbProject.this.synchronizeJaxbFiles(file, deltaKind);
            }
        };
    }

    protected boolean synchronizeJaxbFiles(IFile file, int deltaKind) {
        switch (deltaKind) {
            case 1: {
                return this.addJaxbFile(file);
            }
            case 2: {
                return this.removeJaxbFile(file);
            }
            case 4: {
                return this.checkForChangedFileContent(file);
            }
            case 8: {
                break;
            }
            case 16: {
                break;
            }
        }
        return false;
    }

    protected boolean checkForChangedFileContent(IFile file) {
        JaxbFile jaxbFile = this.getJaxbFile(file);
        if (jaxbFile == null) {
            return this.addJaxbFile(file);
        }
        if (jaxbFile.getContentType().equals(ContentTypeTools.contentType((IFile)file))) {
            return false;
        }
        this.removeJaxbFile(jaxbFile);
        this.addJaxbFile(file);
        return true;
    }

    protected void resolveInternalJavaTypes() {
        for (JavaResourceCompilationUnit jrcu : this.getInternalJavaResourceCompilationUnits()) {
            jrcu.resolveTypes();
        }
    }

    protected void externalProjectChanged(IResourceDelta delta) {
        if (this.getJavaProject().isOnClasspath(delta.getResource())) {
            ResourceDeltaVisitor resourceDeltaVisitor = this.buildExternalResourceDeltaVisitor();
            resourceDeltaVisitor.visitDelta(delta);
            if (resourceDeltaVisitor.encounteredSignificantChange()) {
                this.update();
                this.resolveExternalJavaTypes();
                this.resolveInternalJavaTypes();
            }
        }
    }

    protected ResourceDeltaVisitor buildExternalResourceDeltaVisitor() {
        return new ResourceDeltaVisitor(){

            public boolean fileChangeIsSignificant(IFile file, int deltaKind) {
                return AbstractJaxbProject.this.synchronizeExternalFiles(file, deltaKind);
            }
        };
    }

    protected boolean synchronizeExternalFiles(IFile file, int deltaKind) {
        switch (deltaKind) {
            case 1: {
                return this.externalFileAdded(file);
            }
            case 2: {
                return this.externalFileRemoved(file);
            }
            case 4: {
                break;
            }
            case 8: {
                break;
            }
            case 16: {
                break;
            }
        }
        return false;
    }

    protected boolean externalFileAdded(IFile file) {
        IContentType contentType = ContentTypeTools.contentType((IFile)file);
        if (contentType == null) {
            return false;
        }
        if (contentType.equals(JavaResourceCompilationUnit.CONTENT_TYPE)) {
            return true;
        }
        return contentType.equals(JavaResourcePackageFragmentRoot.JAR_CONTENT_TYPE);
    }

    protected boolean externalFileRemoved(IFile file) {
        IContentType contentType = ContentTypeTools.contentType((IFile)file);
        if (contentType == null) {
            return false;
        }
        if (contentType.equals(JavaResourceCompilationUnit.CONTENT_TYPE)) {
            return this.removeExternalJavaResourceCompilationUnit(file);
        }
        if (contentType.equals(JavaResourcePackageFragmentRoot.JAR_CONTENT_TYPE)) {
            return this.externalJavaResourceTypeCache.removeTypes(file);
        }
        return false;
    }

    protected void resolveExternalJavaTypes() {
        for (JavaResourceCompilationUnit jrcu : this.getExternalJavaResourceCompilationUnits()) {
            jrcu.resolveTypes();
        }
    }

    @Override
    public void setThreadLocalModifySharedDocumentCommandContext(ExtendedCommandContext commandContext) {
        this.modifySharedDocumentCommandContext.set((CommandContext)commandContext);
    }

    @Override
    public ExtendedCommandContext getModifySharedDocumentCommandContext() {
        return this.modifySharedDocumentCommandContext;
    }

    @Override
    public Synchronizer getContextModelSynchronizer() {
        return this.contextModelSynchronizer;
    }

    @Override
    public void setContextModelSynchronizer(Synchronizer synchronizer) {
        if (synchronizer == null) {
            throw new NullPointerException();
        }
        this.contextModelSynchronizer.stop();
        this.setContextModelSynchronizer_(synchronizer);
    }

    protected void setContextModelSynchronizer_(Synchronizer synchronizer) {
        this.contextModelSynchronizer = synchronizer;
        this.contextModelSynchronizer.start();
    }

    @Override
    public void synchronizeContextModel() {
        this.synchronizingContextModel = true;
        this.contextModelSynchronizer.synchronize();
        this.synchronizingContextModel = false;
        this.update();
    }

    @Override
    public IStatus synchronizeContextModel(IProgressMonitor monitor) {
        this.contextRoot.synchronizeWithResourceModel();
        return Status.OK_STATUS;
    }

    @Override
    public void synchronizeContextModelAndWait() {
        Synchronizer temp = this.contextModelSynchronizer;
        this.setContextModelSynchronizer(this.buildSynchronousContextModelSynchronizer());
        this.synchronizeContextModel();
        this.setContextModelSynchronizer(temp);
    }

    protected Synchronizer buildSynchronousContextModelSynchronizer() {
        return new SynchronousSynchronizer(this.buildSynchronousContextModelSynchronizerCommand());
    }

    protected Command buildSynchronousContextModelSynchronizerCommand() {
        return new SynchronousContextModelSynchronizerCommand();
    }

    @Override
    public CallbackSynchronizer getUpdateSynchronizer() {
        return this.updateSynchronizer;
    }

    @Override
    public void setUpdateSynchronizer(CallbackSynchronizer synchronizer) {
        if (synchronizer == null) {
            throw new NullPointerException();
        }
        this.updateSynchronizer.stop();
        this.updateSynchronizer.removeListener(this.updateSynchronizerListener);
        this.setUpdateSynchronizer_(synchronizer);
    }

    protected void setUpdateSynchronizer_(CallbackSynchronizer synchronizer) {
        this.updateSynchronizer = synchronizer;
        this.updateSynchronizer.addListener(this.updateSynchronizerListener);
        this.updateSynchronizer.start();
    }

    @Override
    public void stateChanged() {
        super.stateChanged();
        this.update();
    }

    protected void update() {
        if (!this.synchronizingContextModel) {
            this.updateSynchronizer.synchronize();
        }
    }

    @Override
    public IStatus update(IProgressMonitor monitor) {
        this.contextRoot.update();
        return Status.OK_STATUS;
    }

    public void updateQuiesced() {
    }

    @Override
    public void updateAndWait() {
        CallbackSynchronizer temp = this.updateSynchronizer;
        this.setUpdateSynchronizer(this.buildSynchronousUpdateSynchronizer());
        this.update();
        this.setUpdateSynchronizer(temp);
    }

    protected CallbackSynchronizer buildSynchronousUpdateSynchronizer() {
        return new CallbackSynchronousSynchronizer(this.buildSynchronousUpdateSynchronizerCommand());
    }

    protected Command buildSynchronousUpdateSynchronizerCommand() {
        return new SynchronousUpdateSynchronizerCommand();
    }

    protected CallbackSynchronizer.Listener buildUpdateSynchronizerListener() {
        return new UpdateSynchronizerListener();
    }

    protected class DefaultResourceModelListener
    implements JptResourceModelListener {
        protected DefaultResourceModelListener() {
        }

        public void resourceModelChanged(JptResourceModel jpaResourceModel) {
            AbstractJaxbProject.this.synchronizeContextModel(jpaResourceModel);
        }

        public void resourceModelReverted(JptResourceModel jpaResourceModel) {
        }

        public void resourceModelUnloaded(JptResourceModel jpaResourceModel) {
        }
    }

    protected class InitialResourceProxyVisitor
    implements IResourceProxyVisitor {
        protected InitialResourceProxyVisitor() {
        }

        protected void visitProject(IProject p) {
            try {
                p.accept((IResourceProxyVisitor)this, 0);
            }
            catch (CoreException ex) {
                throw new RuntimeException(ex);
            }
        }

        public boolean visit(IResourceProxy resource) {
            switch (resource.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 1: {
                    AbstractJaxbProject.this.addJaxbFile_((IFile)resource.requestResource());
                    return false;
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JaxbFileTransformer
    extends TransformerAdapter<JaxbFile, JavaResourcePackage> {
        JaxbFileTransformer() {
        }

        public JavaResourcePackage transform(JaxbFile jaxbFile) {
            return ((JavaResourcePackageInfoCompilationUnit)jaxbFile.getResourceModel()).getPackage();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PackageDeclarationTransformer
    extends TransformerAdapter<IPackageDeclaration, JaxbPackageInfo> {
        PackageDeclarationTransformer() {
        }

        public JaxbPackageInfo transform(IPackageDeclaration o) {
            JaxbPackage jaxbPackage = AbstractJaxbProject.this.getContextRoot().getPackage(o.getElementName());
            return jaxbPackage != null ? jaxbPackage.getPackageInfo() : null;
        }
    }

    protected abstract class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        protected boolean encounteredSignificantChange = false;

        protected ResourceDeltaVisitor() {
        }

        protected void visitDelta(IResourceDelta delta) {
            try {
                delta.accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException ex) {
                throw new RuntimeException(ex);
            }
        }

        public boolean visit(IResourceDelta delta) {
            IResource res = delta.getResource();
            switch (res.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 1: {
                    this.fileChanged((IFile)res, delta.getKind());
                    return false;
                }
            }
            return false;
        }

        protected void fileChanged(IFile file, int deltaKind) {
            if (this.fileChangeIsSignificant(file, deltaKind)) {
                this.encounteredSignificantChange = true;
            }
        }

        protected abstract boolean fileChangeIsSignificant(IFile var1, int var2);

        protected boolean encounteredSignificantChange() {
            return this.encounteredSignificantChange;
        }
    }

    protected class SynchronousContextModelSynchronizerCommand
    implements Command {
        protected SynchronousContextModelSynchronizerCommand() {
        }

        public void execute() {
            AbstractJaxbProject.this.synchronizeContextModel((IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected class SynchronousUpdateSynchronizerCommand
    implements Command {
        protected SynchronousUpdateSynchronizerCommand() {
        }

        public void execute() {
            AbstractJaxbProject.this.update((IProgressMonitor)new NullProgressMonitor());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TypeTransformer
    extends TransformerAdapter<IType, JavaType> {
        TypeTransformer() {
        }

        public JavaType transform(IType o) {
            return AbstractJaxbProject.this.getContextRoot().getJavaType(o.getFullyQualifiedName('.'));
        }
    }

    protected class UpdateSynchronizerListener
    implements CallbackSynchronizer.Listener {
        protected UpdateSynchronizerListener() {
        }

        public void synchronizationQuiesced(CallbackSynchronizer synchronizer) {
            AbstractJaxbProject.this.updateQuiesced();
        }
    }
}

