/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.jpt.common.core.JptWorkspace;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jaxb.core.JaxbWorkspace;
import org.eclipse.jpt.jaxb.core.internal.InternalJaxbProjectManager;
import org.eclipse.jpt.jaxb.core.internal.platform.InternalJaxbPlatformManager;

public class InternalJaxbWorkspace
implements JaxbWorkspace {
    private final IWorkspace workspace;
    private final JptWorkspace jptWorkspace;
    private final InternalJaxbPlatformManager jaxbPlatformManager;
    private final InternalJaxbProjectManager jaxbProjectManager;

    public InternalJaxbWorkspace(IWorkspace workspace) {
        this.workspace = workspace;
        this.jptWorkspace = this.buildJptWorkspace();
        this.jaxbPlatformManager = this.buildJaxbPlatformManager();
        this.jaxbProjectManager = this.buildJaxbProjectManager();
        this.jaxbProjectManager.start();
    }

    public JptWorkspace getJptWorkspace() {
        return this.jptWorkspace;
    }

    private JptWorkspace buildJptWorkspace() {
        return (JptWorkspace)this.workspace.getAdapter(JptWorkspace.class);
    }

    public InternalJaxbPlatformManager getJaxbPlatformManager() {
        return this.jaxbPlatformManager;
    }

    private InternalJaxbPlatformManager buildJaxbPlatformManager() {
        return new InternalJaxbPlatformManager(this);
    }

    public InternalJaxbProjectManager getJaxbProjectManager() {
        return this.jaxbProjectManager;
    }

    private InternalJaxbProjectManager buildJaxbProjectManager() {
        return new InternalJaxbProjectManager(this);
    }

    public IWorkspace getWorkspace() {
        return this.workspace;
    }

    void initializeDefaultPreferences() {
        this.getJaxbPlatformManager().initializeDefaultPreferences();
    }

    public void dispose() {
        this.jaxbProjectManager.stop();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, (Object)this.workspace);
    }
}

