/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackage;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jaxb.core.SchemaEntry;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbPackageInfo;
import org.eclipse.jpt.jaxb.core.context.XmlNs;
import org.eclipse.jpt.jaxb.core.context.XmlNsForm;
import org.eclipse.jpt.jaxb.core.context.java.JavaXmlSchema;
import org.eclipse.jpt.jaxb.core.internal.AbstractJaxbNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.resource.java.XmlNsAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlSchemaAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.xsd.XSDForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaXmlSchema
extends AbstractJavaContextNode
implements JavaXmlSchema {
    protected String namespace;
    protected String specifiedNamespace;
    protected String location;
    protected XmlNsForm specifiedAttributeFormDefault;
    protected XmlNsForm specifiedElementFormDefault;
    protected final AbstractJaxbNode.ContextListContainer<XmlNs, XmlNsAnnotation> xmlNsPrefixContainer;

    public GenericJavaXmlSchema(JaxbPackageInfo parent) {
        super(parent);
        this.initNamespace();
        this.location = this.getResourceLocation();
        this.specifiedAttributeFormDefault = this.getResourceAttributeFormDefault();
        this.specifiedElementFormDefault = this.getResourceElementFormDefault();
        this.xmlNsPrefixContainer = this.buildXmlNsPrefixContainer();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncNamespace();
        this.setLocation_(this.getResourceLocation());
        this.setSpecifiedAttributeFormDefault_(this.getResourceAttributeFormDefault());
        this.setSpecifiedElementFormDefault_(this.getResourceElementFormDefault());
        this.syncXmlNsPrefixes();
    }

    @Override
    public void update() {
        super.update();
        this.updateNamespace();
        this.updateXmlNsPrefixes();
    }

    @Override
    public JaxbPackageInfo getJaxbPackageInfo() {
        return (JaxbPackageInfo)this.getParent();
    }

    public JaxbPackage getJaxbPackage() {
        return this.getJaxbPackageInfo().getJaxbPackage();
    }

    protected JavaResourcePackage getResourcePackage() {
        return this.getJaxbPackageInfo().getResourcePackage();
    }

    protected XmlSchemaAnnotation getXmlSchemaAnnotation() {
        return (XmlSchemaAnnotation)this.getResourcePackage().getNonNullAnnotation("javax.xml.bind.annotation.XmlSchema");
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    protected void setNamespace_(String namespace) {
        String oldNamespace = this.namespace;
        this.namespace = namespace;
        this.firePropertyChanged("namespace", oldNamespace, namespace);
    }

    @Override
    public String getSpecifiedNamespace() {
        return this.specifiedNamespace;
    }

    @Override
    public void setSpecifiedNamespace(String namespace) {
        this.getXmlSchemaAnnotation().setNamespace(namespace);
        this.setSpecifiedNamespace_(namespace);
    }

    protected void setSpecifiedNamespace_(String namespace) {
        String old = this.specifiedNamespace;
        this.specifiedNamespace = namespace;
        this.firePropertyChanged("specifiedNamespace", old, namespace);
    }

    protected String getResourceNamespace() {
        return this.getXmlSchemaAnnotation().getNamespace();
    }

    protected void initNamespace() {
        this.specifiedNamespace = this.getResourceNamespace();
    }

    protected void syncNamespace() {
        this.setSpecifiedNamespace_(this.getResourceNamespace());
    }

    protected void updateNamespace() {
        String namespace = this.specifiedNamespace != null ? this.specifiedNamespace : "";
        this.setNamespace_(namespace);
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(String location) {
        this.getXmlSchemaAnnotation().setLocation(location);
        this.setLocation_(location);
    }

    protected void setLocation_(String location) {
        String old = this.location;
        this.location = location;
        this.firePropertyChanged("location", old, location);
    }

    protected String getResourceLocation() {
        return this.getXmlSchemaAnnotation().getLocation();
    }

    @Override
    public XmlNsForm getAttributeFormDefault() {
        return this.specifiedAttributeFormDefault == null ? XmlNsForm.UNSET : this.specifiedAttributeFormDefault;
    }

    @Override
    public XmlNsForm getSpecifiedAttributeFormDefault() {
        return this.specifiedAttributeFormDefault;
    }

    @Override
    public void setSpecifiedAttributeFormDefault(XmlNsForm attributeFormDefault) {
        this.getXmlSchemaAnnotation().setAttributeFormDefault(XmlNsForm.toJavaResourceModel(attributeFormDefault));
        this.setSpecifiedAttributeFormDefault_(attributeFormDefault);
    }

    protected void setSpecifiedAttributeFormDefault_(XmlNsForm attributeFormDefault) {
        XmlNsForm old = this.specifiedAttributeFormDefault;
        this.specifiedAttributeFormDefault = attributeFormDefault;
        this.firePropertyChanged("attributeFormDefault", (Object)old, (Object)attributeFormDefault);
    }

    protected XmlNsForm getResourceAttributeFormDefault() {
        return XmlNsForm.fromJavaResourceModel(this.getXmlSchemaAnnotation().getAttributeFormDefault());
    }

    @Override
    public XmlNsForm getElementFormDefault() {
        return this.specifiedElementFormDefault == null ? XmlNsForm.UNSET : this.specifiedElementFormDefault;
    }

    @Override
    public XmlNsForm getSpecifiedElementFormDefault() {
        return this.specifiedElementFormDefault;
    }

    @Override
    public void setSpecifiedElementFormDefault(XmlNsForm elementFormDefault) {
        this.getXmlSchemaAnnotation().setElementFormDefault(XmlNsForm.toJavaResourceModel(elementFormDefault));
        this.setSpecifiedElementFormDefault_(elementFormDefault);
    }

    protected void setSpecifiedElementFormDefault_(XmlNsForm elementFormDefault) {
        XmlNsForm old = this.specifiedElementFormDefault;
        this.specifiedElementFormDefault = elementFormDefault;
        this.firePropertyChanged("elementFormDefault", (Object)old, (Object)elementFormDefault);
    }

    protected XmlNsForm getResourceElementFormDefault() {
        return XmlNsForm.fromJavaResourceModel(this.getXmlSchemaAnnotation().getElementFormDefault());
    }

    @Override
    public ListIterable<XmlNs> getXmlNsPrefixes() {
        return this.xmlNsPrefixContainer.getContextElements();
    }

    @Override
    public int getXmlNsPrefixesSize() {
        return this.xmlNsPrefixContainer.getContextElementsSize();
    }

    @Override
    public XmlNs addXmlNsPrefix(int index) {
        XmlNsAnnotation annotation = this.getXmlSchemaAnnotation().addXmlns(index);
        return (XmlNs)this.xmlNsPrefixContainer.addContextElement(index, annotation);
    }

    @Override
    public void removeXmlNsPrefix(XmlNs xmlNsPrefix) {
        this.removeXmlNsPrefix(this.xmlNsPrefixContainer.indexOfContextElement(xmlNsPrefix));
    }

    @Override
    public void removeXmlNsPrefix(int index) {
        this.getXmlSchemaAnnotation().removeXmlns(index);
        this.xmlNsPrefixContainer.removeContextElement(index);
    }

    @Override
    public void moveXmlNsPrefix(int targetIndex, int sourceIndex) {
        this.getXmlSchemaAnnotation().moveXmlns(targetIndex, sourceIndex);
        this.xmlNsPrefixContainer.moveContextElement(targetIndex, sourceIndex);
    }

    protected XmlNs buildXmlNs(XmlNsAnnotation xmlNsAnnotation) {
        return this.getFactory().buildJavaXmlNs(this, xmlNsAnnotation);
    }

    protected void syncXmlNsPrefixes() {
        this.xmlNsPrefixContainer.synchronizeWithResourceModel();
    }

    protected void updateXmlNsPrefixes() {
        this.xmlNsPrefixContainer.update();
    }

    protected ListIterable<XmlNsAnnotation> getXmlNsAnnotations() {
        return this.getXmlSchemaAnnotation().getXmlns();
    }

    protected AbstractJaxbNode.ContextListContainer<XmlNs, XmlNsAnnotation> buildXmlNsPrefixContainer() {
        XmlNsPrefixContainer container = new XmlNsPrefixContainer();
        container.initialize();
        return container;
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (!IterableTools.isEmpty(result)) {
            return result;
        }
        if (this.namespaceTouches(pos)) {
            return this.getNamespaceProposals();
        }
        for (XmlNs xmlns : this.getXmlNsPrefixes()) {
            result = xmlns.getCompletionProposals(pos);
            if (IterableTools.isEmpty(result)) continue;
            return result;
        }
        return EmptyIterable.instance();
    }

    protected boolean namespaceTouches(int pos) {
        return this.getXmlSchemaAnnotation().namespaceTouches(pos);
    }

    protected Iterable<String> getNamespaceProposals() {
        return IterableTools.transform((Iterable)IterableTools.transform(this.getJaxbProject().getSchemaLibrary().getSchemaEntries(), SchemaEntry.NAMESPACE_TRANSFORMER), (Transformer)StringTools.JAVA_STRING_LITERAL_CONTENT_TRANSFORMER);
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getXmlSchemaAnnotation().getTextRange();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
    }

    protected boolean formConflicts(XmlNsForm form, XSDForm xsdForm) {
        return form == XmlNsForm.QUALIFIED ^ xsdForm == XSDForm.QUALIFIED_LITERAL;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class XmlNsPrefixContainer
    extends AbstractJaxbNode.ContextListContainer<XmlNs, XmlNsAnnotation> {
        protected XmlNsPrefixContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "xmlNsPrefixes";
        }

        @Override
        protected XmlNs buildContextElement(XmlNsAnnotation resourceElement) {
            return GenericJavaXmlSchema.this.buildXmlNs(resourceElement);
        }

        @Override
        protected ListIterable<XmlNsAnnotation> getResourceElements() {
            return GenericJavaXmlSchema.this.getXmlNsAnnotations();
        }

        @Override
        protected XmlNsAnnotation getResourceElement(XmlNs contextElement) {
            return contextElement.getResourceXmlNs();
        }
    }
}

