/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.facet;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jaxb.core.JaxbWorkspace;
import org.eclipse.jpt.jaxb.core.JptJaxbCoreMessages;
import org.eclipse.jpt.jaxb.core.internal.facet.JaxbFacetDataModelProperties;
import org.eclipse.jpt.jaxb.core.internal.plugin.JptJaxbCorePlugin;
import org.eclipse.jpt.jaxb.core.libprov.JaxbLibraryProviderInstallOperationConfig;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformConfig;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformManager;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.IPropertyChangeListener;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderOperationConfig;
import org.eclipse.wst.common.componentcore.datamodel.FacetInstallDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JaxbFacetDataModelProvider
extends FacetInstallDataModelProvider
implements JaxbFacetDataModelProperties {
    protected static final DataModelPropertyDescriptor[] EMPTY_DMPD_ARRAY = new DataModelPropertyDescriptor[0];
    protected static final Comparator<DataModelPropertyDescriptor> DMPD_COMPARATOR = new Comparator<DataModelPropertyDescriptor>(){

        @Override
        public int compare(DataModelPropertyDescriptor dmpd1, DataModelPropertyDescriptor dmpd2) {
            return dmpd1.getPropertyDescription().compareTo(dmpd2.getPropertyDescription());
        }
    };
    private IFacetedProjectListener fprojListener = this.buildFprojListener();
    private LibraryInstallDelegate defaultLibraryInstallDelegate;
    protected static IStatus OK_STATUS = Status.OK_STATUS;

    protected JaxbFacetDataModelProvider() {
    }

    protected IFacetedProjectListener buildFprojListener() {
        return new IFacetedProjectListener(){

            public void handleEvent(IFacetedProjectEvent event) {
                JaxbFacetDataModelProvider.this.getLibraryInstallDelegate().refresh();
            }
        };
    }

    public Set getPropertyNames() {
        Set names = super.getPropertyNames();
        names.add(PLATFORM);
        names.add(LIBRARY_INSTALL_DELEGATE);
        return names;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IFacetDataModelProperties.FACET_ID")) {
            return "jpt.jaxb";
        }
        if (propertyName.equals(PLATFORM)) {
            return this.getDefaultPlatformConfig();
        }
        if (propertyName.equals(LIBRARY_INSTALL_DELEGATE)) {
            return this.getDefaultLibraryInstallDelegate();
        }
        return super.getDefaultProperty(propertyName);
    }

    protected JaxbPlatformConfig getDefaultPlatformConfig() {
        JaxbPlatformManager jaxbPlatformManager = this.getJaxbPlatformManager();
        return jaxbPlatformManager == null ? null : jaxbPlatformManager.getDefaultJaxbPlatformConfig(this.getProjectFacetVersion());
    }

    protected LibraryInstallDelegate getDefaultLibraryInstallDelegate() {
        if (this.defaultLibraryInstallDelegate == null) {
            this.defaultLibraryInstallDelegate = this.buildDefaultLibraryInstallDelegate();
        } else if (!this.defaultLibraryInstallDelegate.getProjectFacetVersion().equals(this.getProjectFacetVersion())) {
            this.defaultLibraryInstallDelegate.dispose();
            this.defaultLibraryInstallDelegate = this.buildDefaultLibraryInstallDelegate();
        }
        return this.defaultLibraryInstallDelegate;
    }

    protected LibraryInstallDelegate buildDefaultLibraryInstallDelegate() {
        IFacetedProjectWorkingCopy fpjwc = this.getFacetedProjectWorkingCopy();
        IProjectFacetVersion pfv = this.getProjectFacetVersion();
        if (fpjwc == null || pfv == null) {
            return null;
        }
        LibraryInstallDelegate lid = new LibraryInstallDelegate((IFacetedProjectBase)fpjwc, pfv);
        lid.addListener(this.buildLibraryInstallDelegateListener(), new String[0]);
        return lid;
    }

    protected IPropertyChangeListener buildLibraryInstallDelegateListener() {
        return new IPropertyChangeListener(){

            public void propertyChanged(String property, Object oldValue, Object newValue) {
                if (LibraryInstallDelegate.PROP_AVAILABLE_PROVIDERS.equals(property)) {
                    JaxbFacetDataModelProvider.this.adjustLibraryInstallDelegate();
                }
                JaxbFacetDataModelProvider.this.getDataModel().notifyPropertyChange(LIBRARY_INSTALL_DELEGATE, 1);
            }
        };
    }

    protected void adjustLibraryInstallDelegate() {
        LibraryInstallDelegate lid = this.getLibraryInstallDelegate();
        if (lid != null) {
            ArrayList<JaxbLibraryProviderInstallOperationConfig> jaxbConfigs = new ArrayList<JaxbLibraryProviderInstallOperationConfig>();
            JaxbLibraryProviderInstallOperationConfig currentJaxbConfig = null;
            LibraryProviderOperationConfig config = lid.getLibraryProviderOperationConfig();
            if (config instanceof JaxbLibraryProviderInstallOperationConfig) {
                currentJaxbConfig = (JaxbLibraryProviderInstallOperationConfig)config;
                jaxbConfigs.add(currentJaxbConfig);
            }
            for (ILibraryProvider lp : lid.getLibraryProviders()) {
                config = lid.getLibraryProviderOperationConfig(lp);
                if (!(config instanceof JaxbLibraryProviderInstallOperationConfig) || config.equals(currentJaxbConfig)) continue;
                jaxbConfigs.add((JaxbLibraryProviderInstallOperationConfig)config);
            }
            for (JaxbLibraryProviderInstallOperationConfig jaxbConfig : jaxbConfigs) {
                jaxbConfig.setJaxbPlatformConfig(this.getPlatformConfig());
            }
        }
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean ok = super.propertySet(propertyName, propertyValue);
        if (propertyName.equals("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY")) {
            IFacetedProjectWorkingCopy fproj = (IFacetedProjectWorkingCopy)propertyValue;
            fproj.addListener(this.fprojListener, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.PRIMARY_RUNTIME_CHANGED});
        } else if (propertyName.equals("IFacetDataModelPropeties.FACET_VERSION")) {
            this.adjustLibraryInstallDelegate();
            this.model.notifyPropertyChange(PLATFORM, 2);
            this.model.notifyPropertyChange(LIBRARY_INSTALL_DELEGATE, 2);
        } else if (propertyName.equals(PLATFORM)) {
            this.adjustLibraryInstallDelegate();
        }
        return ok;
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if (propertyName.equals(PLATFORM)) {
            return this.buildValidPlatformDescriptors();
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    protected DataModelPropertyDescriptor[] buildValidPlatformDescriptors() {
        TransformationIterable validPlatformDescriptors = IterableTools.transform(this.buildValidPlatformConfigs(), (Transformer)new JaxbPlatformConfigTransformer());
        return (DataModelPropertyDescriptor[])ArrayTools.sort((Object[])((DataModelPropertyDescriptor[])ArrayTools.array((Iterable)validPlatformDescriptors, (Object[])EMPTY_DMPD_ARRAY)), DMPD_COMPARATOR);
    }

    protected Iterable<JaxbPlatformConfig> buildValidPlatformConfigs() {
        return IterableTools.filter(this.getJaxbPlatformConfigs(), (Predicate)new JaxbPlatformConfig.SupportsJaxbFacetVersion(this.getProjectFacetVersion()));
    }

    protected Iterable<JaxbPlatformConfig> getJaxbPlatformConfigs() {
        JaxbPlatformManager jaxbPlatformManager = this.getJaxbPlatformManager();
        return jaxbPlatformManager != null ? jaxbPlatformManager.getJaxbPlatformConfigs() : IterableTools.emptyIterable();
    }

    protected JaxbPlatformManager getJaxbPlatformManager() {
        JaxbWorkspace jaxbWorkspace = this.getJaxbWorkspace();
        return jaxbWorkspace == null ? null : jaxbWorkspace.getJaxbPlatformManager();
    }

    protected JaxbWorkspace getJaxbWorkspace() {
        return (JaxbWorkspace)this.getWorkspace().getAdapter(JaxbWorkspace.class);
    }

    protected IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public DataModelPropertyDescriptor getPropertyDescriptor(String propertyName) {
        if (propertyName.equals(PLATFORM)) {
            return this.buildPlatformDescriptor(this.getPlatformConfig());
        }
        return super.getPropertyDescriptor(propertyName);
    }

    protected DataModelPropertyDescriptor buildPlatformDescriptor(JaxbPlatformConfig config) {
        return new DataModelPropertyDescriptor((Object)config, config.getLabel());
    }

    protected static IStatus buildErrorStatus(String message) {
        return JaxbFacetDataModelProvider.buildStatus(4, message);
    }

    protected static IStatus buildStatus(int severity, String message) {
        return JptJaxbCorePlugin.instance().buildStatus(severity, message);
    }

    public IStatus validate(String propertyName) {
        if (propertyName.equals(PLATFORM)) {
            return this.validatePlatform();
        }
        if (propertyName.equals(LIBRARY_INSTALL_DELEGATE)) {
            return this.getLibraryInstallDelegate().validate();
        }
        return super.validate(propertyName);
    }

    protected IStatus validatePlatform() {
        return this.getPlatformConfig() == null ? JaxbFacetDataModelProvider.buildErrorStatus(JptJaxbCoreMessages.JAXB_FACET_CONFIG_VALIDATE_PLATFORM_NOT_SPECIFIED) : OK_STATUS;
    }

    protected IFacetedProjectWorkingCopy getFacetedProjectWorkingCopy() {
        return (IFacetedProjectWorkingCopy)this.getProperty("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY");
    }

    protected IProjectFacetVersion getProjectFacetVersion() {
        return (IProjectFacetVersion)this.getProperty("IFacetDataModelPropeties.FACET_VERSION");
    }

    protected JaxbPlatformConfig getPlatformConfig() {
        return (JaxbPlatformConfig)this.getProperty(PLATFORM);
    }

    protected LibraryInstallDelegate getLibraryInstallDelegate() {
        return (LibraryInstallDelegate)this.getProperty(LIBRARY_INSTALL_DELEGATE);
    }

    public void dispose() {
        super.dispose();
        this.getFacetedProjectWorkingCopy().removeListener(this.fprojListener);
        this.defaultLibraryInstallDelegate.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class JaxbPlatformConfigTransformer
    extends TransformerAdapter<JaxbPlatformConfig, DataModelPropertyDescriptor> {
        public DataModelPropertyDescriptor transform(JaxbPlatformConfig config) {
            return JaxbFacetDataModelProvider.this.buildPlatformDescriptor(config);
        }
    }
}

