/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.egit.ui.internal.FileRevisionTypedElement;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.ui.synchronize.EditableSharedDocumentAdapter;

public class EditableRevision
extends FileRevisionTypedElement
implements IEditableContent,
IContentChangeNotifier {
    private byte[] modifiedContent;
    private ContentChangeNotifier fChangeNotifier;
    private EditableSharedDocumentAdapter sharedDocumentAdapter;

    public EditableRevision(IFileRevision fileRevision, String encoding) {
        super(fileRevision, encoding);
    }

    public boolean isEditable() {
        return true;
    }

    public ITypedElement replace(ITypedElement dest, ITypedElement src) {
        return null;
    }

    public InputStream getContents() throws CoreException {
        if (this.modifiedContent != null) {
            return new ByteArrayInputStream(this.modifiedContent);
        }
        return super.getContents();
    }

    public void setContent(byte[] newContent) {
        if (newContent != null) {
            this.modifiedContent = new byte[newContent.length];
            System.arraycopy(newContent, 0, this.modifiedContent, 0, newContent.length);
        } else {
            this.modifiedContent = null;
        }
        this.fireContentChanged();
    }

    public byte[] getModifiedContent() {
        byte[] result = new byte[this.modifiedContent.length];
        System.arraycopy(this.modifiedContent, 0, result, 0, this.modifiedContent.length);
        return result;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ISharedDocumentAdapter.class) {
            return this.getSharedDocumentAdapter();
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    private synchronized ISharedDocumentAdapter getSharedDocumentAdapter() {
        if (this.sharedDocumentAdapter == null) {
            this.sharedDocumentAdapter = new EditableSharedDocumentAdapter(new EditableSharedDocumentAdapter.ISharedDocumentAdapterListener(){

                public void handleDocumentConnected() {
                }

                public void handleDocumentFlushed() {
                }

                public void handleDocumentDeleted() {
                }

                public void handleDocumentSaved() {
                }

                public void handleDocumentDisconnected() {
                }
            });
        }
        return this.sharedDocumentAdapter;
    }

    public void addContentChangeListener(IContentChangeListener listener) {
        if (this.fChangeNotifier == null) {
            this.fChangeNotifier = new ContentChangeNotifier(this);
        }
        this.fChangeNotifier.addContentChangeListener(listener);
    }

    public void removeContentChangeListener(IContentChangeListener listener) {
        if (this.fChangeNotifier != null) {
            this.fChangeNotifier.removeContentChangeListener(listener);
            if (this.fChangeNotifier.isEmpty()) {
                this.fChangeNotifier = null;
            }
        }
    }

    protected void fireContentChanged() {
        if (this.fChangeNotifier == null || this.fChangeNotifier.isEmpty()) {
            return;
        }
        this.fChangeNotifier.fireContentChanged();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    private static final class ContentChangeNotifier
    implements IContentChangeNotifier {
        private ListenerList fListenerList;
        private final IContentChangeNotifier element;

        public ContentChangeNotifier(IContentChangeNotifier element) {
            this.element = element;
        }

        public void addContentChangeListener(IContentChangeListener listener) {
            if (this.fListenerList == null) {
                this.fListenerList = new ListenerList();
            }
            this.fListenerList.add((Object)listener);
        }

        public void removeContentChangeListener(IContentChangeListener listener) {
            if (this.fListenerList != null) {
                this.fListenerList.remove((Object)listener);
                if (this.fListenerList.isEmpty()) {
                    this.fListenerList = null;
                }
            }
        }

        public void fireContentChanged() {
            if (this.isEmpty()) {
                return;
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    Object[] listeners = ContentChangeNotifier.this.fListenerList.getListeners();
                    int i = 0;
                    while (i < listeners.length) {
                        final IContentChangeListener contentChangeListener = (IContentChangeListener)listeners[i];
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void run() throws Exception {
                                contentChangeListener.contentChanged(ContentChangeNotifier.this.element);
                            }

                            public void handleException(Throwable exception) {
                            }
                        });
                        ++i;
                    }
                }
            };
            if (Display.getCurrent() == null) {
                Display.getDefault().syncExec(runnable);
            } else {
                runnable.run();
            }
        }

        public boolean isEmpty() {
            return this.fListenerList == null || this.fListenerList.isEmpty();
        }
    }
}

