/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.op.TagOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.decorators.GitLightweightDecorator;
import org.eclipse.egit.ui.internal.dialogs.CreateTagDialog;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TagBuilder;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateTagCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String currentBranchName;
        RepositoryTreeNode node = (RepositoryTreeNode)this.getSelectedNodes(event).get(0);
        final Repository repo = node.getRepository();
        if (!repo.getRepositoryState().canCheckout()) {
            MessageDialog.openError((Shell)this.getShell(event), (String)UIText.TagAction_cannotCheckout, (String)NLS.bind((String)UIText.TagAction_repositoryState, (Object)repo.getRepositoryState().getDescription()));
            return null;
        }
        try {
            currentBranchName = repo.getBranch();
        }
        catch (IOException e) {
            Activator.handleError(e.getMessage(), e, true);
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        CreateTagDialog dialog = new CreateTagDialog(this.getView(event).getSite().getShell(), currentBranchName, repo);
        if (dialog.open() != 0) {
            return null;
        }
        final TagBuilder tag = new TagBuilder();
        PersonIdent personIdent = new PersonIdent(repo);
        String tagName = dialog.getTagName();
        tag.setTag(tagName);
        tag.setTagger(personIdent);
        tag.setMessage(dialog.getTagMessage());
        tag.setObjectId(this.getTagTarget(dialog.getTagCommit(), repo));
        String tagJobName = NLS.bind((String)UIText.TagAction_creating, (Object)tagName);
        final boolean shouldMoveTag = dialog.shouldOverWriteTag();
        Job tagJob = new Job(tagJobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        new TagOperation(repo, tag, shouldMoveTag).execute(monitor);
                    }
                    catch (CoreException e) {
                        IStatus iStatus = Activator.createErrorStatus(UIText.TagAction_taggingFailed, e);
                        GitLightweightDecorator.refresh();
                        return iStatus;
                    }
                }
                finally {
                    GitLightweightDecorator.refresh();
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (family.equals(JobFamilies.TAG)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        tagJob.setUser(true);
        tagJob.schedule();
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        this.enableWhenRepositoryHaveHead(evaluationContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RevObject getTagTarget(ObjectId objectId, Repository repo) throws ExecutionException {
        try {
            RevWalk rw = new RevWalk(repo);
            try {
                if (objectId == null) {
                    RevObject revObject = rw.parseAny((AnyObjectId)repo.resolve("HEAD"));
                    return revObject;
                }
                RevObject revObject = rw.parseAny((AnyObjectId)objectId);
                return revObject;
            }
            finally {
                rw.release();
            }
        }
        catch (IOException e) {
            throw new ExecutionException(UIText.TagAction_unableToResolveHeadObjectId, (Throwable)e);
        }
    }
}

