/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.preview.internal;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.ByteArrayISO8859Writer;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.wst.server.preview.internal.Module;

public class WTPDefaultHandler
extends AbstractHandler {
    protected int port;
    protected Module[] modules;

    public WTPDefaultHandler(int port, Module[] modules) {
        this.port = port;
        this.modules = modules;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (response.isCommitted() || baseRequest.isHandled()) {
            return;
        }
        baseRequest.setHandled(true);
        response.setStatus(404);
        response.setContentType("text/html");
        ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer(1500);
        String uri = request.getRequestURI();
        uri = StringUtil.replace((String)uri, (String)"<", (String)"&lt;");
        uri = StringUtil.replace((String)uri, (String)">", (String)"&gt;");
        writer.write("<HTML>\n<HEAD>\n<TITLE>Error 404 - Not Found");
        writer.write("</TITLE>\n<BODY>\n<H2>Error 404 - Not Found</H2>\n");
        writer.write("No context on this server matched or handled this request.<BR>");
        writer.write("Contexts known to this server are: <ul>");
        Module[] moduleArray = this.modules;
        int n = this.modules.length;
        int n2 = 0;
        while (n2 < n) {
            Module module = moduleArray[n2];
            writer.write("<li>");
            writer.write(module.getName());
            writer.write("(<a href=\"http://localhost:" + this.port + module.getContext() + "\">");
            writer.write(module.getContext());
            writer.write("</a>)</li>");
            ++n2;
        }
        int i = 0;
        while (i < 10) {
            writer.write("\n<!-- Padding for IE                  -->");
            ++i;
        }
        writer.write("\n</BODY>\n</HTML>\n");
        writer.flush();
        response.setContentLength(writer.size());
        ServletOutputStream out = response.getOutputStream();
        writer.writeTo((OutputStream)out);
        out.close();
    }
}

