/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.internal.project;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

final class ModuleCoreSupportDelegate {
    private static final String SLASH = "/";
    private static Map fResolvedMap = new HashMap();

    ModuleCoreSupportDelegate() {
    }

    static IPath getRuntimePath(IPath path) {
        if (path == null) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
        if (!ModuleCoreNature.isFlexibleProject((IProject)project)) {
            return null;
        }
        IVirtualResource[] virtualResources = ComponentCore.createResources((IResource)ResourcesPlugin.getWorkspace().getRoot().getFile(path));
        if (virtualResources != null && virtualResources.length > 0) {
            return virtualResources[0].getRuntimePath();
        }
        return null;
    }

    static IPath getWebContentRootPath(IProject project) {
        if (project == null) {
            return null;
        }
        if (!ModuleCoreNature.isFlexibleProject((IProject)project)) {
            return null;
        }
        IPath path = null;
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null && component.exists()) {
            path = component.getRootFolder().getWorkspaceRelativePath();
        }
        return path;
    }

    static IPath resolve(IPath basePath, String reference) {
        if (reference == null || basePath == null || basePath.segmentCount() == 0) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(basePath.segment(0));
        if (!ModuleCoreNature.isFlexibleProject((IProject)project)) {
            return null;
        }
        if (basePath.segmentCount() > 1) {
            IPath resolved = null;
            HashMap<String, SoftReference<IPath>> mapForBaseResource = null;
            mapForBaseResource = (HashMap<String, SoftReference<IPath>>)fResolvedMap.get(basePath);
            if (mapForBaseResource != null) {
                Reference resolvedReference = (Reference)mapForBaseResource.get(reference);
                if (resolvedReference != null) {
                    resolved = (IPath)resolvedReference.get();
                }
            } else {
                mapForBaseResource = new HashMap<String, SoftReference<IPath>>();
                fResolvedMap.put(basePath, mapForBaseResource);
            }
            if (resolved == null) {
                IFile baseFile = ResourcesPlugin.getWorkspace().getRoot().getFile(basePath);
                IVirtualResource[] virtualResources = ComponentCore.createResources((IResource)baseFile);
                int i = 0;
                while (i < virtualResources.length) {
                    IPath baseRuntimePath = virtualResources[i].getRuntimePath();
                    Object referenceRuntimePath = null;
                    referenceRuntimePath = reference.startsWith(SLASH) ? new Path(reference) : baseRuntimePath.removeLastSegments(1).append(reference);
                    IVirtualFile virtualFile = ComponentCore.createFile((IProject)project, (IPath)referenceRuntimePath);
                    if (virtualFile != null && virtualFile.exists()) {
                        IFile[] underlyingFiles = virtualFile.getUnderlyingFiles();
                        int j = 0;
                        while (j < underlyingFiles.length) {
                            if (underlyingFiles[j].getProject().equals((Object)project) && underlyingFiles[j].exists()) {
                                mapForBaseResource.put(reference, new SoftReference<IPath>(underlyingFiles[j].getFullPath()));
                                resolved = underlyingFiles[j].getFullPath();
                            }
                            ++j;
                        }
                    } else {
                        IVirtualFolder virtualFolder = ComponentCore.createFolder((IProject)project, (IPath)referenceRuntimePath);
                        if (virtualFolder != null && virtualFolder.exists()) {
                            IContainer[] underlyingFolders = virtualFolder.getUnderlyingFolders();
                            int j = 0;
                            while (j < underlyingFolders.length) {
                                if (underlyingFolders[j].getProject().equals((Object)project) && underlyingFolders[j].isAccessible()) {
                                    return underlyingFolders[j].getFullPath();
                                }
                                ++j;
                            }
                        }
                    }
                    ++i;
                }
            }
            return resolved;
        }
        IVirtualFile virtualFile = ComponentCore.createFile((IProject)project, (IPath)new Path(reference));
        if (virtualFile != null && virtualFile.exists()) {
            return virtualFile.getUnderlyingFile().getFullPath();
        }
        return null;
    }
}

