/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.text.FastJavaPartitionScanner;
import org.eclipse.jdt.internal.ui.text.JavaHeuristicScanner;
import org.eclipse.jdt.internal.ui.text.JavaIndenter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.texteditor.ITextEditorExtension3;

public class JavaAutoIndentStrategy
extends DefaultIndentLineAutoEditStrategy {
    private static final String LINE_COMMENT = "//";
    private boolean fCloseBrace;
    private boolean fIsSmartMode;
    private boolean fIsSmartTab;
    private boolean fIsSmartIndentAfterNewline;
    private String fPartitioning;
    private final IJavaProject fProject;
    private static IScanner fgScanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
    private final ISourceViewer fViewer;

    public JavaAutoIndentStrategy(String partitioning, IJavaProject project, ISourceViewer viewer) {
        this.fPartitioning = partitioning;
        this.fProject = project;
        this.fViewer = viewer;
    }

    private int getBracketCount(IDocument d, int startOffset, int endOffset, boolean ignoreCloseBrackets) throws BadLocationException {
        int bracketCount = 0;
        block7: while (startOffset < endOffset) {
            char curr = d.getChar(startOffset);
            ++startOffset;
            switch (curr) {
                case '/': {
                    if (startOffset >= endOffset) break;
                    char next = d.getChar(startOffset);
                    if (next == '*') {
                        startOffset = this.getCommentEnd(d, startOffset + 1, endOffset);
                        break;
                    }
                    if (next != '/') break;
                    startOffset = endOffset;
                    break;
                }
                case '*': {
                    char next;
                    if (startOffset >= endOffset || (next = d.getChar(startOffset)) != '/') continue block7;
                    bracketCount = 0;
                    ++startOffset;
                    break;
                }
                case '{': {
                    ++bracketCount;
                    ignoreCloseBrackets = false;
                    break;
                }
                case '}': {
                    if (ignoreCloseBrackets) break;
                    --bracketCount;
                    break;
                }
                case '\"': 
                case '\'': {
                    startOffset = this.getStringEnd(d, startOffset, endOffset, curr);
                }
            }
        }
        return bracketCount;
    }

    private int getCommentEnd(IDocument d, int offset, int endOffset) throws BadLocationException {
        while (offset < endOffset) {
            char curr = d.getChar(offset);
            if (curr != '*' || ++offset >= endOffset || d.getChar(offset) != '/') continue;
            return offset + 1;
        }
        return endOffset;
    }

    private String getIndentOfLine(IDocument d, int line) throws BadLocationException {
        if (line > -1) {
            int start = d.getLineOffset(line);
            int end = start + d.getLineLength(line) - 1;
            int whiteEnd = this.findEndOfWhiteSpace(d, start, end);
            return d.get(start, whiteEnd - start);
        }
        return "";
    }

    private int getStringEnd(IDocument d, int offset, int endOffset, char ch) throws BadLocationException {
        while (offset < endOffset) {
            char curr = d.getChar(offset);
            ++offset;
            if (curr == '\\') {
                ++offset;
                continue;
            }
            if (curr != ch) continue;
            return offset;
        }
        return endOffset;
    }

    private void smartIndentAfterClosingBracket(IDocument d, DocumentCommand c) {
        if (c.offset == -1 || d.getLength() == 0) {
            return;
        }
        try {
            int reference;
            int indLine;
            int p = c.offset == d.getLength() ? c.offset - 1 : c.offset;
            int line = d.getLineOfOffset(p);
            int start = d.getLineOffset(line);
            int whiteend = this.findEndOfWhiteSpace(d, start, c.offset);
            JavaHeuristicScanner scanner = new JavaHeuristicScanner(d);
            JavaIndenter indenter = new JavaIndenter(d, scanner, this.fProject);
            if (whiteend == c.offset && (indLine = d.getLineOfOffset(reference = indenter.findReferencePosition(c.offset, false, true, false, false))) != -1 && indLine != line) {
                StringBuffer replaceText = new StringBuffer(this.getIndentOfLine(d, indLine));
                replaceText.append(d.get(whiteend, c.offset - whiteend));
                replaceText.append(c.text);
                c.length += c.offset - start;
                c.offset = start;
                c.text = replaceText.toString();
            }
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
    }

    private void smartIndentAfterOpeningBracket(IDocument d, DocumentCommand c) {
        if (c.offset < 1 || d.getLength() == 0) {
            return;
        }
        JavaHeuristicScanner scanner = new JavaHeuristicScanner(d);
        int p = c.offset == d.getLength() ? c.offset - 1 : c.offset;
        try {
            int line = d.getLineOfOffset(p);
            int lineOffset = d.getLineOffset(line);
            if (d.get(lineOffset, p - lineOffset).trim().length() != 0) {
                return;
            }
            int pos = scanner.findNonWhitespaceBackward(p, -2);
            if (pos == -1) {
                return;
            }
            int lastLine = d.getLineOfOffset(pos);
            if (lastLine < line) {
                JavaIndenter indenter = new JavaIndenter(d, scanner, this.fProject);
                StringBuffer indent = indenter.computeIndentation(p, true);
                String toDelete = d.get(lineOffset, c.offset - lineOffset);
                if (indent != null && !indent.toString().equals(toDelete)) {
                    c.text = indent.append(c.text).toString();
                    c.length += c.offset - lineOffset;
                    c.offset = lineOffset;
                }
            }
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
    }

    private void smartIndentAfterNewLine(IDocument d, DocumentCommand c) {
        JavaHeuristicScanner scanner = new JavaHeuristicScanner(d);
        JavaIndenter indenter = new JavaIndenter(d, scanner, this.fProject);
        StringBuffer indent = indenter.computeIndentation(c.offset);
        if (indent == null) {
            indent = new StringBuffer();
        }
        int docLength = d.getLength();
        if (c.offset == -1 || docLength == 0) {
            return;
        }
        try {
            int firstCharPos;
            int p = c.offset == docLength ? c.offset - 1 : c.offset;
            int line = d.getLineOfOffset(p);
            StringBuffer buf = new StringBuffer(String.valueOf(c.text) + indent);
            IRegion reg = d.getLineInformation(line);
            int lineEnd = reg.getOffset() + reg.getLength();
            int contentStart = this.findEndOfWhiteSpace(d, c.offset, lineEnd);
            c.length = Math.max(contentStart - c.offset, 0);
            int start = reg.getOffset();
            ITypedRegion region = TextUtilities.getPartition((IDocument)d, (String)this.fPartitioning, (int)start, (boolean)true);
            if ("__java_javadoc".equals(region.getType())) {
                start = d.getLineInformationOfOffset(region.getOffset()).getOffset();
            }
            if (this.getBracketCount(d, start, c.offset, true) > 0 && this.closeBrace() && !this.isClosed(d, c.offset, c.length)) {
                c.caretOffset = c.offset + buf.length();
                c.shiftsCaret = false;
                int pos = c.offset - 1;
                char ch = d.getChar(pos);
                while (ch == ' ' || ch == '\t') {
                    ch = d.getChar(--pos);
                }
                if ((c.offset == 0 || this.copyContent(d, pos + 1, this.fPartitioning, lineEnd)) && lineEnd - contentStart > 0) {
                    c.length = lineEnd - c.offset;
                    buf.append(d.get(contentStart, lineEnd - contentStart).toCharArray());
                }
                buf.append(TextUtilities.getDefaultLineDelimiter((IDocument)d));
                StringBuffer reference = null;
                int nonWS = this.findEndOfWhiteSpace(d, start, lineEnd);
                reference = nonWS < c.offset && d.getChar(nonWS) == '{' ? new StringBuffer(d.get(start, nonWS - start)) : indenter.getReferenceIndentation(c.offset);
                if (reference != null) {
                    buf.append(reference);
                }
                buf.append('}');
            } else if (c.offset > start && contentStart < lineEnd && d.getChar(contentStart) == '}' && (firstCharPos = scanner.findNonWhitespaceBackward(c.offset - 1, start)) != -1 && d.getChar(firstCharPos) == '{') {
                c.caretOffset = c.offset + buf.length();
                c.shiftsCaret = false;
                StringBuffer reference = null;
                int nonWS = this.findEndOfWhiteSpace(d, start, lineEnd);
                reference = nonWS < c.offset && d.getChar(nonWS) == '{' ? new StringBuffer(d.get(start, nonWS - start)) : indenter.getReferenceIndentation(c.offset);
                buf.append(TextUtilities.getDefaultLineDelimiter((IDocument)d));
                if (reference != null) {
                    buf.append(reference);
                }
            }
            c.text = buf.toString();
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
    }

    private boolean copyContent(IDocument document, int offset, String partitioning, int max) {
        block8: {
            JavaHeuristicScanner scanner = new JavaHeuristicScanner(document);
            int pos = offset;
            int length = max;
            int scanTo = scanner.scanForward(pos, length, '}');
            if (scanTo == -1) {
                scanTo = length;
            }
            int closingParen = JavaAutoIndentStrategy.findClosingParenToLeft(scanner, pos) - 1;
            int openingParen = -1;
            while (true) {
                int startScan;
                if ((closingParen = scanner.scanForward(startScan = closingParen + 1, scanTo, ')')) == -1) {
                    if (openingParen != -1) {
                        return false;
                    }
                    try {
                        int p = this.findEndOfWhiteSpace(document, pos, scanTo);
                        char ch = document.getChar(p);
                        if (ch == ',' || ch == ';') {
                            return false;
                        }
                        break block8;
                    }
                    catch (BadLocationException badLocationException) {
                        break block8;
                    }
                }
                openingParen = scanner.findOpeningPeer(closingParen - 1, '(', ')');
                if (openingParen < 1) break block8;
                if (openingParen > pos) {
                    openingParen = -1;
                    continue;
                }
                if (JavaAutoIndentStrategy.looksLikeAnonymousClassDef(document, partitioning, scanner, openingParen - 1)) break;
            }
            return false;
        }
        return true;
    }

    private static int findClosingParenToLeft(JavaHeuristicScanner scanner, int position) {
        if (position < 1) {
            return position;
        }
        if (scanner.previousToken(position - 1, -2) == 6) {
            return scanner.getPosition() + 1;
        }
        return position;
    }

    private static boolean isNewMatch(IDocument document, int offset, int length, String partitioning) {
        int pos;
        String text;
        block6: {
            block5: {
                Assert.isTrue((length >= 0 ? 1 : 0) != 0);
                Assert.isTrue((offset >= 0 ? 1 : 0) != 0);
                Assert.isTrue((offset + length < document.getLength() + 1 ? 1 : 0) != 0);
                try {
                    text = document.get(offset, length);
                    pos = text.indexOf("new");
                    while (pos != -1 && !JavaAutoIndentStrategy.isDefaultPartition(document, pos + offset, partitioning)) {
                        pos = text.indexOf("new", pos + 2);
                    }
                    if (pos >= 0) break block5;
                    return false;
                }
                catch (BadLocationException badLocationException) {
                    return false;
                }
            }
            if (pos == 0 || !Character.isJavaIdentifierPart(text.charAt(pos - 1))) break block6;
            return false;
        }
        return pos + 3 >= length || !Character.isJavaIdentifierPart(text.charAt(pos + 3));
    }

    private static boolean looksLikeAnonymousClassDef(IDocument document, String partitioning, JavaHeuristicScanner scanner, int position) {
        int previousCommaParenEqual = scanner.scanBackward(position - 1, -2, new char[]{',', '(', '='});
        if (previousCommaParenEqual == -1 || position < previousCommaParenEqual + 5) {
            return false;
        }
        return JavaAutoIndentStrategy.isNewMatch(document, previousCommaParenEqual + 1, position - previousCommaParenEqual - 2, partitioning);
    }

    private static boolean isDefaultPartition(IDocument document, int position, String partitioning) {
        Assert.isTrue((position >= 0 ? 1 : 0) != 0);
        Assert.isTrue((position <= document.getLength() ? 1 : 0) != 0);
        try {
            ITypedRegion region = TextUtilities.getPartition((IDocument)document, (String)partitioning, (int)position, (boolean)false);
            return region.getType().equals("__dftl_partition_content_type");
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private boolean isClosed(IDocument document, int offset, int length) {
        CompilationUnitInfo info = JavaAutoIndentStrategy.getCompilationUnitForMethod(document, offset);
        if (info == null) {
            return false;
        }
        CompilationUnit compilationUnit = null;
        try {
            ASTParser parser = ASTParser.newParser((int)4);
            parser.setSource(info.buffer);
            compilationUnit = (CompilationUnit)parser.createAST(null);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
        IProblem[] problems = compilationUnit.getProblems();
        int i = 0;
        while (i != problems.length) {
            if (problems[i].getID() == 1610612956) {
                return true;
            }
            ++i;
        }
        int relativeOffset = offset - info.delta;
        ASTNode node = NodeFinder.perform((ASTNode)compilationUnit, (int)relativeOffset, (int)length);
        if (length == 0) {
            while (node != null && (relativeOffset == node.getStartPosition() || relativeOffset == node.getStartPosition() + node.getLength())) {
                node = node.getParent();
            }
        }
        if (node == null) {
            return false;
        }
        switch (node.getNodeType()) {
            case 8: {
                return JavaAutoIndentStrategy.getBlockBalance(document, offset, this.fPartitioning) <= 0;
            }
            case 25: {
                int sourceLength;
                IfStatement ifStatement = (IfStatement)node;
                Expression expression = ifStatement.getExpression();
                IRegion expressionRegion = JavaAutoIndentStrategy.createRegion((ASTNode)expression, info.delta);
                Statement thenStatement = ifStatement.getThenStatement();
                IRegion thenRegion = JavaAutoIndentStrategy.createRegion((ASTNode)thenStatement, info.delta);
                if (expressionRegion.getOffset() + expressionRegion.getLength() <= offset && offset + length <= thenRegion.getOffset()) {
                    return thenStatement != null;
                }
                Statement elseStatement = ifStatement.getElseStatement();
                IRegion elseRegion = JavaAutoIndentStrategy.createRegion((ASTNode)elseStatement, info.delta);
                if (elseStatement == null) break;
                int sourceOffset = thenRegion.getOffset() + thenRegion.getLength();
                IRegion elseToken = JavaAutoIndentStrategy.getToken(document, (IRegion)new Region(sourceOffset, sourceLength = elseRegion.getOffset() - sourceOffset), 213);
                return elseToken != null && elseToken.getOffset() + elseToken.getLength() <= offset && offset + length < elseRegion.getOffset();
            }
            case 24: 
            case 61: {
                Expression expression = node.getNodeType() == 61 ? ((WhileStatement)node).getExpression() : ((ForStatement)node).getExpression();
                IRegion expressionRegion = JavaAutoIndentStrategy.createRegion((ASTNode)expression, info.delta);
                Statement body = node.getNodeType() == 61 ? ((WhileStatement)node).getBody() : ((ForStatement)node).getBody();
                IRegion bodyRegion = JavaAutoIndentStrategy.createRegion((ASTNode)body, info.delta);
                if (expressionRegion.getOffset() + expressionRegion.getLength() > offset || offset + length > bodyRegion.getOffset()) break;
                return body != null;
            }
            case 19: {
                DoStatement doStatement = (DoStatement)node;
                IRegion doRegion = JavaAutoIndentStrategy.createRegion((ASTNode)doStatement, info.delta);
                Statement body = doStatement.getBody();
                IRegion bodyRegion = JavaAutoIndentStrategy.createRegion((ASTNode)body, info.delta);
                if (doRegion.getOffset() + doRegion.getLength() > offset || offset + length > bodyRegion.getOffset()) break;
                return body != null;
            }
        }
        return true;
    }

    private static void installJavaStuff(Document document) {
        String[] types = new String[]{"__java_javadoc", "__java_multiline_comment", "__java_singleline_comment", "__java_string", "__java_character", "__dftl_partition_content_type"};
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new FastJavaPartitionScanner(), types);
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner("___java_partitioning", (IDocumentPartitioner)partitioner);
    }

    private static void removeJavaStuff(Document document) {
        document.setDocumentPartitioner("___java_partitioning", null);
    }

    private void smartPaste(IDocument document, DocumentCommand command) {
        int newOffset = command.offset;
        int newLength = command.length;
        String newText = command.text;
        try {
            JavaHeuristicScanner scanner = new JavaHeuristicScanner(document);
            JavaIndenter indenter = new JavaIndenter(document, scanner, this.fProject);
            int offset = newOffset;
            int refOffset = indenter.findReferencePosition(offset);
            if (refOffset == -1) {
                return;
            }
            int peerOffset = this.getPeerPosition(document, command);
            if ((peerOffset = indenter.findReferencePosition(peerOffset)) != -1) {
                refOffset = Math.min(refOffset, peerOffset);
            }
            int firstLine = 1;
            IRegion line = document.getLineInformationOfOffset(offset);
            String notSelected = document.get(line.getOffset(), offset - line.getOffset());
            if (notSelected.trim().length() == 0) {
                newLength += notSelected.length();
                newOffset = line.getOffset();
                firstLine = 0;
            }
            IRegion refLine = document.getLineInformationOfOffset(refOffset);
            String prefix = document.get(refLine.getOffset(), newOffset - refLine.getOffset());
            Document temp = new Document(String.valueOf(prefix) + newText);
            DocumentRewriteSession session = temp.startRewriteSession(DocumentRewriteSessionType.STRICTLY_SEQUENTIAL);
            scanner = new JavaHeuristicScanner((IDocument)temp);
            indenter = new JavaIndenter((IDocument)temp, scanner, this.fProject);
            JavaAutoIndentStrategy.installJavaStuff(temp);
            boolean isIndentDetected = false;
            StringBuffer addition = new StringBuffer();
            int insertLength = 0;
            int firstLineInsertLength = 0;
            int firstLineIndent = 0;
            int first = document.computeNumberOfLines(prefix) + firstLine;
            int lines = temp.getNumberOfLines();
            int tabLength = this.getVisualTabLengthPreference();
            boolean changed = false;
            int l = first;
            while (l < lines) {
                IRegion r = temp.getLineInformation(l);
                int lineOffset = r.getOffset();
                int lineLength = r.getLength();
                if (lineLength != 0) {
                    if (!isIndentDetected) {
                        String current = JavaAutoIndentStrategy.getCurrentIndent(temp, l);
                        StringBuffer correct = indenter.computeIndentation(lineOffset);
                        if (correct == null) {
                            return;
                        }
                        insertLength = this.subtractIndent(correct, current, addition, tabLength);
                        if (l == first) {
                            firstLineInsertLength = insertLength;
                            firstLineIndent = current.length();
                        }
                        if (l != first && temp.get(lineOffset, lineLength).trim().length() != 0) {
                            isIndentDetected = true;
                            if (firstLineIndent >= current.length()) {
                                insertLength = firstLineInsertLength;
                            }
                            if (insertLength == 0) {
                                if (firstLine == 0) {
                                    command.offset = newOffset;
                                    command.length = newLength;
                                    if (changed) break;
                                }
                                return;
                            }
                        } else {
                            boolean bl = changed = insertLength != 0;
                        }
                    }
                    if (insertLength > 0) {
                        this.addIndent(temp, l, addition, tabLength);
                    } else if (insertLength < 0) {
                        this.cutIndent(temp, l, -insertLength, tabLength);
                    }
                }
                ++l;
            }
            JavaAutoIndentStrategy.removeJavaStuff(temp);
            temp.stopRewriteSession(session);
            newText = temp.get(prefix.length(), temp.getLength() - prefix.length());
            command.offset = newOffset;
            command.length = newLength;
            command.text = newText;
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
    }

    private static String getCurrentIndent(Document document, int line) throws BadLocationException {
        String type;
        IRegion region = document.getLineInformation(line);
        int from = region.getOffset();
        int endOffset = region.getOffset() + region.getLength();
        int to = from;
        while (to < endOffset - 2 && document.get(to, 2).equals(LINE_COMMENT)) {
            to += 2;
        }
        while (to < endOffset) {
            char ch = document.getChar(to);
            if (!Character.isWhitespace(ch)) break;
            ++to;
        }
        if (to > from && to < endOffset - 1 && document.get(to - 1, 2).equals(" *") && ((type = TextUtilities.getContentType((IDocument)document, (String)"___java_partitioning", (int)to, (boolean)true)).equals("__java_javadoc") || type.equals("__java_multiline_comment"))) {
            --to;
        }
        return document.get(from, to - from);
    }

    private int subtractIndent(CharSequence correct, CharSequence current, StringBuffer difference, int tabLength) {
        int c2;
        int c1 = this.computeVisualLength(correct, tabLength);
        int diff = c1 - (c2 = this.computeVisualLength(current, tabLength));
        if (diff <= 0) {
            return diff;
        }
        difference.setLength(0);
        int len = 0;
        int i = 0;
        while (len < diff) {
            char c = correct.charAt(i++);
            difference.append(c);
            len += this.computeVisualLength(c, tabLength);
        }
        return diff;
    }

    private void addIndent(Document document, int line, CharSequence indent, int tabLength) throws BadLocationException {
        IRegion region = document.getLineInformation(line);
        int insert = region.getOffset();
        int endOffset = region.getOffset() + region.getLength();
        int newInsert = insert;
        while (newInsert < endOffset - 2 && document.get(newInsert, 2).equals(LINE_COMMENT)) {
            newInsert += 2;
        }
        if (newInsert > insert) {
            int whitespaceCount = 0;
            int i = newInsert;
            while (i < endOffset - 1) {
                char ch = document.get(i, 1).charAt(0);
                if (!Character.isWhitespace(ch)) break;
                whitespaceCount += this.computeVisualLength(ch, tabLength);
                ++i;
            }
            if (whitespaceCount != 0 && whitespaceCount >= CodeFormatterUtil.getIndentWidth(this.fProject)) {
                insert = newInsert;
            }
        }
        document.replace(insert, 0, indent.toString());
    }

    private void cutIndent(Document document, int line, int toDelete, int tabLength) throws BadLocationException {
        IRegion region = document.getLineInformation(line);
        int from = region.getOffset();
        int endOffset = region.getOffset() + region.getLength();
        while (from < endOffset - 2 && document.get(from, 2).equals(LINE_COMMENT)) {
            from += 2;
        }
        int to = from;
        while (toDelete > 0 && to < endOffset) {
            char ch = document.getChar(to);
            if (!Character.isWhitespace(ch) || (toDelete -= this.computeVisualLength(ch, tabLength)) < 0) break;
            ++to;
        }
        document.replace(from, to - from, "");
    }

    private int computeVisualLength(CharSequence seq, int tabLength) {
        int size = 0;
        int i = 0;
        while (i < seq.length()) {
            char ch = seq.charAt(i);
            if (ch == '\t') {
                if (tabLength != 0) {
                    size += tabLength - size % tabLength;
                }
            } else {
                ++size;
            }
            ++i;
        }
        return size;
    }

    private int computeVisualLength(char ch, int tabLength) {
        if (ch == '\t') {
            return tabLength;
        }
        return 1;
    }

    private int getVisualTabLengthPreference() {
        return CodeFormatterUtil.getTabWidth(this.fProject);
    }

    private boolean isInsertingSpacesForTab() {
        return "space".equals(JavaAutoIndentStrategy.getCoreOption(this.fProject, "org.eclipse.jdt.core.formatter.tabulation.char"));
    }

    private static String getCoreOption(IJavaProject project, String key) {
        if (project == null) {
            return JavaCore.getOption((String)key);
        }
        return project.getOption(key, true);
    }

    private int getPeerPosition(IDocument document, DocumentCommand command) {
        if (document.getLength() == 0) {
            return 0;
        }
        Document pasted = new Document(command.text);
        JavaAutoIndentStrategy.installJavaStuff(pasted);
        int firstPeer = command.offset;
        JavaHeuristicScanner pScanner = new JavaHeuristicScanner((IDocument)pasted);
        JavaHeuristicScanner dScanner = new JavaHeuristicScanner(document);
        int afterToken = dScanner.nextToken(command.offset + command.length, -2);
        try {
            switch (afterToken) {
                case 2: {
                    pasted.replace(pasted.getLength(), 0, "}");
                    break;
                }
                case 6: {
                    pasted.replace(pasted.getLength(), 0, ")");
                    break;
                }
                case 4: {
                    pasted.replace(pasted.getLength(), 0, "]");
                }
            }
        }
        catch (BadLocationException badLocationException) {
            Assert.isTrue((boolean)false);
        }
        int pPos = 0;
        int dPos = Math.max(0, command.offset - 1);
        block15: while (true) {
            int token = pScanner.nextToken(pPos, -2);
            pPos = pScanner.getPosition();
            switch (token) {
                case 1: 
                case 3: 
                case 5: {
                    if ((pPos = JavaAutoIndentStrategy.skipScope(pScanner, pPos, token)) != -1) continue block15;
                    return firstPeer;
                }
                case 2: {
                    int peer = dScanner.findOpeningPeer(dPos, '{', '}');
                    dPos = peer - 1;
                    if (peer == -1) {
                        return firstPeer;
                    }
                    firstPeer = peer;
                    continue block15;
                }
                case 4: {
                    int peer = dScanner.findOpeningPeer(dPos, '[', ']');
                    dPos = peer - 1;
                    if (peer == -1) {
                        return firstPeer;
                    }
                    firstPeer = peer;
                    continue block15;
                }
                case 6: {
                    int peer = dScanner.findOpeningPeer(dPos, '(', ')');
                    dPos = peer - 1;
                    if (peer == -1) {
                        return firstPeer;
                    }
                    firstPeer = peer;
                    continue block15;
                }
                case 1013: 
                case 1024: {
                    JavaIndenter indenter = new JavaIndenter(document, dScanner, this.fProject);
                    int peer = indenter.findReferencePosition(dPos, false, false, false, true);
                    if (peer == -1) {
                        return firstPeer;
                    }
                    firstPeer = peer;
                    continue block15;
                }
                case -1: {
                    return firstPeer;
                }
            }
        }
    }

    private static int skipScope(JavaHeuristicScanner scanner, int start, int token) {
        int closeToken;
        int openToken = token;
        switch (token) {
            case 5: {
                closeToken = 6;
                break;
            }
            case 3: {
                closeToken = 4;
                break;
            }
            case 1: {
                closeToken = 2;
                break;
            }
            default: {
                Assert.isTrue((boolean)false);
                return -1;
            }
        }
        int depth = 1;
        int p = start;
        while (true) {
            int tok = scanner.nextToken(p, -2);
            p = scanner.getPosition();
            if (tok == openToken) {
                ++depth;
                continue;
            }
            if (tok == closeToken) {
                if (--depth != 0) continue;
                return p + 1;
            }
            if (tok == -1) break;
        }
        return -1;
    }

    private boolean isLineDelimiter(IDocument document, String text) {
        String[] delimiters = document.getLegalLineDelimiters();
        if (delimiters != null) {
            return TextUtilities.equals((String[])delimiters, (String)text) > -1;
        }
        return false;
    }

    private void smartIndentOnKeypress(IDocument document, DocumentCommand command) {
        switch (command.text.charAt(0)) {
            case '}': {
                this.smartIndentAfterClosingBracket(document, command);
                break;
            }
            case '{': {
                this.smartIndentAfterOpeningBracket(document, command);
                break;
            }
            case 'e': {
                this.smartIndentUponE(document, command);
            }
        }
    }

    private void smartIndentUponE(IDocument d, DocumentCommand c) {
        if (c.offset < 4 || d.getLength() == 0) {
            return;
        }
        try {
            String content = d.get(c.offset - 3, 3);
            if (content.equals("els")) {
                JavaHeuristicScanner scanner = new JavaHeuristicScanner(d);
                int p = c.offset - 3;
                int line = d.getLineOfOffset(p);
                int lineOffset = d.getLineOffset(line);
                if (d.get(lineOffset, p - lineOffset).trim().length() != 0) {
                    return;
                }
                int pos = scanner.findNonWhitespaceBackward(p - 1, -2);
                if (pos == -1) {
                    return;
                }
                int lastLine = d.getLineOfOffset(pos);
                if (lastLine < line) {
                    JavaIndenter indenter = new JavaIndenter(d, scanner, this.fProject);
                    int ref = indenter.findReferencePosition(p, true, false, false, false);
                    if (ref == -1) {
                        return;
                    }
                    int refLine = d.getLineOfOffset(ref);
                    String indent = this.getIndentOfLine(d, refLine);
                    if (indent != null) {
                        c.text = String.valueOf(indent.toString()) + "else";
                        c.length += c.offset - lineOffset;
                        c.offset = lineOffset;
                    }
                }
                return;
            }
            if (content.equals("cas")) {
                JavaHeuristicScanner scanner = new JavaHeuristicScanner(d);
                int p = c.offset - 3;
                int line = d.getLineOfOffset(p);
                int lineOffset = d.getLineOffset(line);
                if (d.get(lineOffset, p - lineOffset).trim().length() != 0) {
                    return;
                }
                int pos = scanner.findNonWhitespaceBackward(p - 1, -2);
                if (pos == -1) {
                    return;
                }
                int lastLine = d.getLineOfOffset(pos);
                if (lastLine < line) {
                    JavaIndenter indenter = new JavaIndenter(d, scanner, this.fProject);
                    int ref = indenter.findReferencePosition(p, false, false, false, true);
                    if (ref == -1) {
                        return;
                    }
                    int refLine = d.getLineOfOffset(ref);
                    int nextToken = scanner.nextToken(ref, -2);
                    String indent = nextToken == 1013 || nextToken == 1024 ? this.getIndentOfLine(d, refLine) : indenter.computeIndentation(p).toString();
                    if (indent != null) {
                        c.text = String.valueOf(indent.toString()) + "case";
                        c.length += c.offset - lineOffset;
                        c.offset = lineOffset;
                    }
                }
                return;
            }
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
    }

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (!c.doit) {
            return;
        }
        this.clearCachedValues();
        if (!this.fIsSmartMode) {
            super.customizeDocumentCommand(d, c);
            return;
        }
        if (!this.fIsSmartTab && this.isRepresentingTab(c.text)) {
            return;
        }
        if (c.length == 0 && c.text != null && this.isLineDelimiter(d, c.text)) {
            if (this.fIsSmartIndentAfterNewline) {
                this.smartIndentAfterNewLine(d, c);
            } else {
                super.customizeDocumentCommand(d, c);
            }
        } else if (c.text.length() == 1) {
            this.smartIndentOnKeypress(d, c);
        } else if (c.text.length() > 1 && JavaAutoIndentStrategy.getPreferenceStore().getBoolean("smartPaste") && (this.fViewer == null || this.fViewer.getTextWidget() == null || !this.fViewer.getTextWidget().getBlockSelection())) {
            this.smartPaste(d, c);
        }
    }

    private boolean isRepresentingTab(String text) {
        if (text == null) {
            return false;
        }
        if (this.isInsertingSpacesForTab()) {
            if (text.length() == 0 || text.length() > this.getVisualTabLengthPreference()) {
                return false;
            }
            int i = 0;
            while (i < text.length()) {
                if (text.charAt(i) != ' ') {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return text.length() == 1 && text.charAt(0) == '\t';
    }

    private static IPreferenceStore getPreferenceStore() {
        return JavaPlugin.getDefault().getCombinedPreferenceStore();
    }

    private boolean closeBrace() {
        return this.fCloseBrace;
    }

    private void clearCachedValues() {
        IPreferenceStore preferenceStore = JavaAutoIndentStrategy.getPreferenceStore();
        this.fCloseBrace = preferenceStore.getBoolean("closeBraces");
        this.fIsSmartTab = preferenceStore.getBoolean("smart_tab");
        this.fIsSmartIndentAfterNewline = preferenceStore.getBoolean("smartIndentAfterNewline");
        this.fIsSmartMode = this.computeSmartMode();
    }

    private boolean computeSmartMode() {
        IWorkbenchPage page = JavaPlugin.getActivePage();
        if (page != null) {
            ITextEditorExtension3 extension;
            IEditorPart part = page.getActiveEditor();
            if (part instanceof ITextEditorExtension3) {
                ITextEditorExtension3 extension2 = (ITextEditorExtension3)part;
                return extension2.getInsertMode() == ITextEditorExtension3.SMART_INSERT;
            }
            if (part != null && EditorUtility.isCompareEditorInput(part.getEditorInput()) && (extension = (ITextEditorExtension3)part.getAdapter(ITextEditorExtension3.class)) != null) {
                return extension.getInsertMode() == ITextEditorExtension3.SMART_INSERT;
            }
        }
        return false;
    }

    private static CompilationUnitInfo getCompilationUnitForMethod(IDocument document, int offset) {
        IRegion sourceRange;
        block3: {
            try {
                JavaHeuristicScanner scanner = new JavaHeuristicScanner(document);
                sourceRange = scanner.findSurroundingBlock(offset);
                if (sourceRange != null) break block3;
                return null;
            }
            catch (BadLocationException e) {
                JavaPlugin.log(e);
                return null;
            }
        }
        String source = document.get(sourceRange.getOffset(), sourceRange.getLength());
        StringBuffer contents = new StringBuffer();
        contents.append("class ____C{void ____m()");
        int methodOffset = contents.length();
        contents.append(source);
        contents.append('}');
        char[] buffer = contents.toString().toCharArray();
        return new CompilationUnitInfo(buffer, sourceRange.getOffset() - methodOffset);
    }

    private static int getBlockBalance(IDocument document, int offset, String partitioning) {
        if (offset < 1) {
            return -1;
        }
        if (offset >= document.getLength()) {
            return 1;
        }
        int begin = offset;
        int end = offset - 1;
        JavaHeuristicScanner scanner = new JavaHeuristicScanner(document);
        do {
            begin = scanner.findOpeningPeer(begin - 1, '{', '}');
            end = scanner.findClosingPeer(end + 1, '{', '}');
            if (begin == -1 && end == -1) {
                return 0;
            }
            if (begin != -1) continue;
            return -1;
        } while (end != -1);
        return 1;
    }

    private static IRegion createRegion(ASTNode node, int delta) {
        return node == null ? null : new Region(node.getStartPosition() + delta, node.getLength());
    }

    private static IRegion getToken(IDocument document, IRegion scanRegion, int tokenId) {
        block5: {
            String source = document.get(scanRegion.getOffset(), scanRegion.getLength());
            fgScanner.setSource(source.toCharArray());
            int id = fgScanner.getNextToken();
            while (id != 158 && id != tokenId) {
                id = fgScanner.getNextToken();
            }
            if (id != 158) break block5;
            return null;
        }
        try {
            int tokenOffset = fgScanner.getCurrentTokenStartPosition();
            int tokenLength = fgScanner.getCurrentTokenEndPosition() + 1 - tokenOffset;
            return new Region(tokenOffset + scanRegion.getOffset(), tokenLength);
        }
        catch (InvalidInputException invalidInputException) {
            return null;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private static class CompilationUnitInfo {
        char[] buffer;
        int delta;

        CompilationUnitInfo(char[] buffer, int delta) {
            this.buffer = buffer;
            this.delta = delta;
        }
    }
}

