/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.eclipselink.core.internal.libval;

import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.IFieldInfo;
import org.eclipse.jpt.common.eclipselink.core.JptCommonEclipseLinkCoreMessages;
import org.eclipse.jpt.common.eclipselink.core.internal.plugin.JptCommonEclipseLinkCorePlugin;
import org.eclipse.jst.common.project.facet.core.libprov.user.UserLibraryProviderInstallOperationConfig;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkLibraryValidatorTools {
    private static final String VERSION_FIELD_NAME = "version";
    private static final char[] VERSION_FIELD_NAME_CHAR_ARRAY = "version".toCharArray();
    private static final String VERSION_CLASS_PATH = "org/eclipse/persistence/Version.class";

    public static IStatus validateEclipseLinkVersion(UserLibraryProviderInstallOperationConfig config, VersionRange versionRange) {
        return EclipseLinkLibraryValidatorTools.validateEclipseLinkVersion(config.resolve(), versionRange);
    }

    private static IStatus validateEclipseLinkVersion(Iterable<IClasspathEntry> libraryEntries, VersionRange versionRange) {
        Version version = null;
        for (IClasspathEntry libraryEntry : libraryEntries) {
            if (libraryEntry.getEntryKind() != 1) continue;
            String versionString = null;
            IClassFileReader classReader = EclipseLinkLibraryValidatorTools.buildClassFileReader(libraryEntry);
            if (classReader != null) {
                IFieldInfo[] iFieldInfoArray = classReader.getFieldInfos();
                int n = iFieldInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IFieldInfo field = iFieldInfoArray[n2];
                    if (Arrays.equals(field.getName(), VERSION_FIELD_NAME_CHAR_ARRAY)) {
                        try {
                            versionString = field.getConstantValueAttribute().getConstantValue().getStringValue();
                        }
                        catch (RuntimeException runtimeException) {}
                        break;
                    }
                    ++n2;
                }
            }
            if (versionString == null) continue;
            if (version != null) {
                return EclipseLinkLibraryValidatorTools.buildErrorStatus(JptCommonEclipseLinkCoreMessages.ECLIPSELINK_LIBRARY_VALIDATOR__MULTIPLE_ECLIPSELINK_VERSIONS);
            }
            version = new Version(versionString);
        }
        if (version == null) {
            return EclipseLinkLibraryValidatorTools.buildErrorStatus(JptCommonEclipseLinkCoreMessages.ECLIPSELINK_LIBRARY_VALIDATOR__NO_ECLIPSELINK_VERSION);
        }
        if (!versionRange.isIncluded(version)) {
            return EclipseLinkLibraryValidatorTools.buildErrorStatus(JptCommonEclipseLinkCoreMessages.ECLIPSELINK_LIBRARY_VALIDATOR__IMPROPER_ECLIPSELINK_VERSION);
        }
        return Status.OK_STATUS;
    }

    private static IClassFileReader buildClassFileReader(IClasspathEntry entry) {
        return ToolFactory.createDefaultClassFileReader((String)entry.getPath().toFile().getAbsolutePath(), (String)VERSION_CLASS_PATH, (int)5);
    }

    private static IStatus buildErrorStatus(String message) {
        return JptCommonEclipseLinkCorePlugin.instance().buildErrorStatus(message);
    }
}

