/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

import java.util.Vector;
import org.eclipse.jpt.common.utility.ExceptionHandler;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SnapshotCloneListIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectingExceptionHandler
implements ExceptionHandler {
    private final Vector<Throwable> exceptions = new Vector();

    @Override
    public void handleException(Throwable t) {
        this.exceptions.add(t);
    }

    public Iterable<Throwable> getExceptions() {
        return IterableTools.cloneSnapshot(this.exceptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Throwable> clearExceptions() {
        Vector<Throwable> vector = this.exceptions;
        synchronized (vector) {
            SnapshotCloneListIterable<Throwable> result = IterableTools.cloneSnapshot(this.exceptions);
            this.exceptions.clear();
            return result;
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.exceptions);
    }
}

