/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

import org.eclipse.jpt.common.utility.MultiThreadExceptionHandler;

public class ExceptionHandlerThreadGroup
extends ThreadGroup {
    private final MultiThreadExceptionHandler exceptionHandler;

    public ExceptionHandlerThreadGroup(String name, MultiThreadExceptionHandler exceptionHandler) {
        super(name);
        if (exceptionHandler == null) {
            throw new NullPointerException();
        }
        this.exceptionHandler = exceptionHandler;
    }

    public ExceptionHandlerThreadGroup(ThreadGroup parent, String name, MultiThreadExceptionHandler exceptionHandler) {
        super(parent, name);
        if (exceptionHandler == null) {
            throw new NullPointerException();
        }
        this.exceptionHandler = exceptionHandler;
    }

    public synchronized void uncaughtException(Thread t, Throwable e) {
        this.exceptionHandler.handleException(t, e);
    }

    public MultiThreadExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }
}

