/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.command;

import java.util.concurrent.ThreadFactory;
import org.eclipse.jpt.common.utility.ExceptionHandler;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.command.StatefulCommandContext;
import org.eclipse.jpt.common.utility.internal.ConsumerThreadCoordinator;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.RuntimeExceptionHandler;
import org.eclipse.jpt.common.utility.internal.SimpleThreadFactory;
import org.eclipse.jpt.common.utility.internal.collection.SynchronizedQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAsynchronousCommandContext<E extends StatefulCommandContext>
implements StatefulCommandContext {
    protected final E commandContext;
    private final SynchronizedQueue<Command> commands = new SynchronizedQueue();
    private final ConsumerThreadCoordinator consumerThreadCoordinator;

    protected AbstractAsynchronousCommandContext(Config<E> config) {
        this(config.getCommandContext(), config.getThreadFactory(), config.getThreadName(), config.getExceptionHandler());
    }

    protected AbstractAsynchronousCommandContext(E commandContext, ThreadFactory threadFactory, String threadName, ExceptionHandler exceptionHandler) {
        if (commandContext == null) {
            throw new NullPointerException();
        }
        this.commandContext = commandContext;
        this.consumerThreadCoordinator = this.buildConsumerThreadCoordinator(threadFactory, threadName, exceptionHandler);
    }

    private ConsumerThreadCoordinator buildConsumerThreadCoordinator(ThreadFactory threadFactory, String threadName, ExceptionHandler exceptionHandler) {
        return new ConsumerThreadCoordinator(this.buildConsumer(), threadFactory, threadName, exceptionHandler);
    }

    private ConsumerThreadCoordinator.Consumer buildConsumer() {
        return new Consumer();
    }

    @Override
    public synchronized void start() {
        this.commandContext.start();
        this.consumerThreadCoordinator.start();
    }

    @Override
    public synchronized void execute(Command command) {
        this.commands.enqueue(command);
    }

    @Override
    public synchronized void stop() throws InterruptedException {
        this.consumerThreadCoordinator.stop();
        this.commandContext.stop();
    }

    void waitForCommand() throws InterruptedException {
        this.commands.waitUntilNotEmpty();
    }

    void executeNextCommand() {
        this.commandContext.execute(this.commands.dequeue());
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.commands);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Config<E extends StatefulCommandContext> {
        public E getCommandContext();

        public ThreadFactory getThreadFactory();

        public String getThreadName();

        public ExceptionHandler getExceptionHandler();
    }

    class Consumer
    implements ConsumerThreadCoordinator.Consumer {
        Consumer() {
        }

        public void waitForProducer() throws InterruptedException {
            AbstractAsynchronousCommandContext.this.waitForCommand();
        }

        public void consume() {
            AbstractAsynchronousCommandContext.this.executeNextCommand();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class SimpleConfig<E extends StatefulCommandContext>
    implements Config<E> {
        private volatile E commandContext;
        private volatile ThreadFactory threadFactory;
        private volatile String threadName;
        private volatile ExceptionHandler exceptionHandler;

        protected SimpleConfig() {
            this.commandContext = this.buildDefaultCommandContext();
            this.threadFactory = this.buildDefaultThreadFactory();
            this.threadName = this.buildDefaultThreadName();
            this.exceptionHandler = this.buildDefaultExceptionHandler();
        }

        protected SimpleConfig(E commandContext, ThreadFactory threadFactory, String threadName, ExceptionHandler exceptionHandler) {
            this.commandContext = commandContext;
            this.threadFactory = threadFactory;
            this.threadName = threadName;
            this.exceptionHandler = exceptionHandler;
        }

        public void setCommandContext(E commandContext) {
            this.commandContext = commandContext;
        }

        @Override
        public E getCommandContext() {
            return this.commandContext;
        }

        protected abstract E buildDefaultCommandContext();

        public void setThreadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
        }

        @Override
        public ThreadFactory getThreadFactory() {
            return this.threadFactory;
        }

        protected ThreadFactory buildDefaultThreadFactory() {
            return SimpleThreadFactory.instance();
        }

        public void setThreadName(String threadName) {
            this.threadName = threadName;
        }

        @Override
        public String getThreadName() {
            return this.threadName;
        }

        protected String buildDefaultThreadName() {
            return null;
        }

        public void setExceptionHandler(ExceptionHandler exceptionHandler) {
            this.exceptionHandler = exceptionHandler;
        }

        @Override
        public ExceptionHandler getExceptionHandler() {
            return this.exceptionHandler;
        }

        protected ExceptionHandler buildDefaultExceptionHandler() {
            return RuntimeExceptionHandler.instance();
        }
    }
}

