/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.jdbc;

import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import org.eclipse.jpt.common.utility.JavaType;
import org.eclipse.jpt.common.utility.internal.SimpleJavaType;
import org.eclipse.jpt.common.utility.internal.jdbc.JDBCType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JDBCTools {
    private static HashMap<String, JDBCToJavaTypeMapping> JDBC_TO_JAVA_TYPE_MAPPINGS;
    private static final JavaType DEFAULT_JAVA_TYPE;
    private static HashMap<String, JavaToJDBCTypeMapping> JAVA_TO_JDBC_TYPE_MAPPINGS;
    private static final JDBCType DEFAULT_JDBC_TYPE;

    static {
        DEFAULT_JAVA_TYPE = new SimpleJavaType(Object.class);
        DEFAULT_JDBC_TYPE = JDBCType.type(12);
    }

    public static JDBCType jdbcTypeForClassNamed(String className) {
        JavaToJDBCTypeMapping mapping = JDBCTools.getJavaToJDBCTypeMapping(className);
        return mapping == null ? DEFAULT_JDBC_TYPE : mapping.getJDBCType();
    }

    public static JDBCType jdbcType(Class<?> javaClass) {
        return JDBCTools.jdbcTypeForClassNamed(javaClass.getName());
    }

    public static JDBCType jdbcType(JavaType javaType) {
        return JDBCTools.jdbcTypeForClassNamed(javaType.getJavaClassName());
    }

    public static JavaType javaTypeForJDBCTypeNamed(String jdbcTypeName) {
        JDBCToJavaTypeMapping mapping = JDBCTools.getJDBCToJavaTypeMapping(jdbcTypeName);
        return mapping == null ? DEFAULT_JAVA_TYPE : mapping.getJavaType();
    }

    public static JavaType javaType(JDBCType jdbcType) {
        return JDBCTools.javaTypeForJDBCTypeNamed(jdbcType.name());
    }

    public static JavaType javaTypeForJDBCTypeCode(int jdbcTypeCode) {
        return JDBCTools.javaType(JDBCType.type(jdbcTypeCode));
    }

    private static JDBCToJavaTypeMapping getJDBCToJavaTypeMapping(String jdbcTypeName) {
        return JDBCTools.getJDBCToJavaTypeMappings().get(jdbcTypeName);
    }

    private static synchronized HashMap<String, JDBCToJavaTypeMapping> getJDBCToJavaTypeMappings() {
        if (JDBC_TO_JAVA_TYPE_MAPPINGS == null) {
            JDBC_TO_JAVA_TYPE_MAPPINGS = JDBCTools.buildJDBCToJavaTypeMappings();
        }
        return JDBC_TO_JAVA_TYPE_MAPPINGS;
    }

    private static HashMap<String, JDBCToJavaTypeMapping> buildJDBCToJavaTypeMappings() {
        HashMap<String, JDBCToJavaTypeMapping> mappings = new HashMap<String, JDBCToJavaTypeMapping>();
        JDBCTools.addJDBCToJavaTypeMappings(mappings);
        return mappings;
    }

    private static void addJDBCToJavaTypeMappings(HashMap<String, JDBCToJavaTypeMapping> mappings) {
        JDBCTools.addJDBCToJavaTypeMapping(2003, Array.class, mappings);
        JDBCTools.addJDBCToJavaTypeMapping(-5, Long.TYPE, mappings);
        JDBCTools.addJDBCToJavaTypeMapping(-2, byte[].class, mappings);
        JDBCTools.addJDBCToJavaTypeMapping(-7, Boolean.TYPE, mappings);
        JDBCTools.addJDBCToJavaTypeMapping(2004, Blob.class, mappings);
        JDBCTools.addJDBCToJavaTypeMapping(16, Boolean.TYPE, mappings);
        JDBCTools.addJDBCToJavaTypeMapping(1, String.class, mappings);
        JDBCTools.addJDBCToJavaTypeMapping(2005, Clob.class, mappings);
        JDBCTools.addJDBCToJavaTypeMapping(70, URL.class, mappings);
        JDBCTools.addJDBCToJavaTypeMapping(91, Date.class, mappings);
        JDBCTools.addJDBCToJavaTypeMapping(3, BigDecimal.class, mappings);
        JDBCTools.addJDBCToJavaTypeMapping(2001, Object.class, mappings);
        JDBCTools.addJDBCToJavaTypeMapping(8, Double.TYPE, mappings);
        JDBCTools.addJDBCToJavaTypeMapping(6, Double.TYPE, mappings);
        JDBCTools.addJDBCToJavaTypeMapping(4, Integer.TYPE, mappings);
        JDBCTools.addJDBCToJavaTypeMapping(2000, Object.class, mappings);
        JDBCTools.addJDBCToJavaTypeMapping(-4, byte[].class, mappings);
        JDBCTools.addJDBCToJavaTypeMapping(-1, String.class, mappings);
        JDBCTools.addJDBCToJavaTypeMapping(2, BigDecimal.class, mappings);
        JDBCTools.addJDBCToJavaTypeMapping(1111, Object.class, mappings);
        JDBCTools.addJDBCToJavaTypeMapping(7, Float.TYPE, mappings);
        JDBCTools.addJDBCToJavaTypeMapping(2006, Ref.class, mappings);
        JDBCTools.addJDBCToJavaTypeMapping(5, Short.TYPE, mappings);
        JDBCTools.addJDBCToJavaTypeMapping(2002, Struct.class, mappings);
        JDBCTools.addJDBCToJavaTypeMapping(92, Time.class, mappings);
        JDBCTools.addJDBCToJavaTypeMapping(93, Timestamp.class, mappings);
        JDBCTools.addJDBCToJavaTypeMapping(-6, Byte.TYPE, mappings);
        JDBCTools.addJDBCToJavaTypeMapping(-3, byte[].class, mappings);
        JDBCTools.addJDBCToJavaTypeMapping(12, String.class, mappings);
    }

    private static void addJDBCToJavaTypeMapping(int jdbcTypeCode, Class<?> javaClass, HashMap<String, JDBCToJavaTypeMapping> mappings) {
        JDBCType jdbcType = JDBCType.type(jdbcTypeCode);
        JDBCToJavaTypeMapping prev = mappings.put(jdbcType.name(), JDBCTools.buildJDBCToJavaTypeMapping(jdbcType, javaClass));
        if (prev != null) {
            throw new IllegalArgumentException("duplicate JDBC type: " + jdbcType.name());
        }
    }

    private static JDBCToJavaTypeMapping buildJDBCToJavaTypeMapping(JDBCType jdbcType, Class<?> javaClass) {
        return new JDBCToJavaTypeMapping(jdbcType, new SimpleJavaType(javaClass));
    }

    private static JavaToJDBCTypeMapping getJavaToJDBCTypeMapping(String className) {
        return JDBCTools.getJavaToJDBCTypeMappings().get(className);
    }

    private static synchronized HashMap<String, JavaToJDBCTypeMapping> getJavaToJDBCTypeMappings() {
        if (JAVA_TO_JDBC_TYPE_MAPPINGS == null) {
            JAVA_TO_JDBC_TYPE_MAPPINGS = JDBCTools.buildJavaToJDBCTypeMappings();
        }
        return JAVA_TO_JDBC_TYPE_MAPPINGS;
    }

    private static HashMap<String, JavaToJDBCTypeMapping> buildJavaToJDBCTypeMappings() {
        HashMap<String, JavaToJDBCTypeMapping> mappings = new HashMap<String, JavaToJDBCTypeMapping>();
        JDBCTools.addJavaToJDBCTypeMappings(mappings);
        return mappings;
    }

    private static void addJavaToJDBCTypeMappings(HashMap<String, JavaToJDBCTypeMapping> mappings) {
        JDBCTools.addJavaToJDBCTypeMapping(Boolean.TYPE, -7, mappings);
        JDBCTools.addJavaToJDBCTypeMapping(Byte.TYPE, -6, mappings);
        JDBCTools.addJavaToJDBCTypeMapping(Double.TYPE, 8, mappings);
        JDBCTools.addJavaToJDBCTypeMapping(Float.TYPE, 7, mappings);
        JDBCTools.addJavaToJDBCTypeMapping(Integer.TYPE, 4, mappings);
        JDBCTools.addJavaToJDBCTypeMapping(Long.TYPE, -5, mappings);
        JDBCTools.addJavaToJDBCTypeMapping(Short.TYPE, 5, mappings);
        JDBCTools.addJavaToJDBCTypeMapping(Boolean.class, -7, mappings);
        JDBCTools.addJavaToJDBCTypeMapping(Byte.class, -6, mappings);
        JDBCTools.addJavaToJDBCTypeMapping(Double.class, 8, mappings);
        JDBCTools.addJavaToJDBCTypeMapping(Float.class, 7, mappings);
        JDBCTools.addJavaToJDBCTypeMapping(Integer.class, 4, mappings);
        JDBCTools.addJavaToJDBCTypeMapping(Long.class, -5, mappings);
        JDBCTools.addJavaToJDBCTypeMapping(Short.class, 5, mappings);
        JDBCTools.addJavaToJDBCTypeMapping(String.class, 12, mappings);
        JDBCTools.addJavaToJDBCTypeMapping(BigDecimal.class, 2, mappings);
        JDBCTools.addJavaToJDBCTypeMapping(URL.class, 70, mappings);
        JDBCTools.addJavaToJDBCTypeMapping(Array.class, 2003, mappings);
        JDBCTools.addJavaToJDBCTypeMapping(Blob.class, 2004, mappings);
        JDBCTools.addJavaToJDBCTypeMapping(Clob.class, 2005, mappings);
        JDBCTools.addJavaToJDBCTypeMapping(Date.class, 91, mappings);
        JDBCTools.addJavaToJDBCTypeMapping(Ref.class, 2006, mappings);
        JDBCTools.addJavaToJDBCTypeMapping(Struct.class, 2002, mappings);
        JDBCTools.addJavaToJDBCTypeMapping(Time.class, 92, mappings);
        JDBCTools.addJavaToJDBCTypeMapping(Timestamp.class, 93, mappings);
        JDBCTools.addJavaToJDBCTypeMapping(byte[].class, -3, mappings);
        JDBCTools.addJavaToJDBCTypeMapping(Byte[].class, -3, mappings);
    }

    private static void addJavaToJDBCTypeMapping(Class<?> javaClass, int jdbcTypeCode, HashMap<String, JavaToJDBCTypeMapping> mappings) {
        JavaToJDBCTypeMapping prev = mappings.put(javaClass.getName(), JDBCTools.buildJavaToJDBCTypeMapping(javaClass, jdbcTypeCode));
        if (prev != null) {
            throw new IllegalArgumentException("duplicate Java class: " + prev.getJavaType().declaration());
        }
    }

    private static JavaToJDBCTypeMapping buildJavaToJDBCTypeMapping(Class<?> javaClass, int jdbcTypeCode) {
        return new JavaToJDBCTypeMapping(new SimpleJavaType(javaClass), JDBCType.type(jdbcTypeCode));
    }

    private JDBCTools() {
        throw new UnsupportedOperationException();
    }

    static class JDBCToJavaTypeMapping {
        private final JDBCType jdbcType;
        private final JavaType javaType;

        JDBCToJavaTypeMapping(JDBCType jdbcType, JavaType javaType) {
            this.jdbcType = jdbcType;
            this.javaType = javaType;
        }

        public JDBCType getJDBCType() {
            return this.jdbcType;
        }

        public JavaType getJavaType() {
            return this.javaType;
        }

        public boolean maps(int jdbcTypeCode) {
            return this.jdbcType.code() == jdbcTypeCode;
        }

        public boolean maps(String jdbcTypeName) {
            return this.jdbcType.name().equals(jdbcTypeName);
        }

        public boolean maps(JDBCType type) {
            return this.jdbcType == type;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendTo(sb);
            return sb.toString();
        }

        public void appendTo(StringBuilder sb) {
            this.jdbcType.appendTo(sb);
            sb.append(" => ");
            this.javaType.appendDeclarationTo(sb);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JavaToJDBCTypeMapping {
        private final JavaType javaType;
        private final JDBCType jdbcType;

        JavaToJDBCTypeMapping(JavaType javaType, JDBCType jdbcType) {
            this.javaType = javaType;
            this.jdbcType = jdbcType;
        }

        public JavaType getJavaType() {
            return this.javaType;
        }

        public JDBCType getJDBCType() {
            return this.jdbcType;
        }

        public boolean maps(JavaType jt) {
            return this.javaType.equals(jt);
        }

        public boolean maps(String elementTypeName, int arrayDepth) {
            return this.javaType.equals(elementTypeName, arrayDepth);
        }

        public boolean maps(String javaClassName) {
            return this.javaType.describes(javaClassName);
        }

        public boolean maps(Class<?> javaClass) {
            return this.javaType.describes(javaClass);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendTo(sb);
            return sb.toString();
        }

        public void appendTo(StringBuilder sb) {
            this.javaType.appendDeclarationTo(sb);
            sb.append(" => ");
            this.jdbcType.appendTo(sb);
        }
    }
}

