/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import java.util.EventListener;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.common.utility.internal.model.SingleAspectChangeSupport;
import org.eclipse.jpt.common.utility.internal.model.value.StaticPropertyValueModel;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AspectAdapter<S, A>
extends AbstractModel {
    protected volatile S subject;
    protected final PropertyValueModel<? extends S> subjectModel;
    protected final PropertyChangeListener subjectListener;

    protected AspectAdapter(S subject) {
        this((PropertyValueModel<S>)new StaticPropertyValueModel<S>(subject));
    }

    protected AspectAdapter(PropertyValueModel<? extends S> subjectModel) {
        if (subjectModel == null) {
            throw new NullPointerException();
        }
        this.subjectModel = subjectModel;
        this.subjectListener = this.buildSubjectListener();
        this.subject = null;
    }

    @Override
    protected ChangeSupport buildChangeSupport() {
        return new LocalChangeSupport(this, this.getListenerClass(), this.getListenerAspectName());
    }

    protected PropertyChangeListener buildSubjectListener() {
        return new SubjectListener();
    }

    protected synchronized void subjectChanged() {
        A old = this.getAspectValue();
        boolean hasListeners = this.hasListeners();
        if (hasListeners) {
            this.disengageSubject();
        }
        this.subject = this.subjectModel.getValue();
        if (hasListeners) {
            this.engageSubject();
            this.fireAspectChanged(old, this.getAspectValue());
        }
    }

    protected abstract A getAspectValue();

    protected abstract Class<? extends EventListener> getListenerClass();

    protected abstract String getListenerAspectName();

    protected abstract boolean hasListeners();

    protected boolean hasNoListeners() {
        return !this.hasListeners();
    }

    protected abstract void fireAspectChanged(A var1, A var2);

    protected void engageModels() {
        this.engageSubjectHolder();
        this.engageSubject();
    }

    protected void engageSubjectHolder() {
        this.subjectModel.addPropertyChangeListener("value", this.subjectListener);
        this.subject = this.subjectModel.getValue();
    }

    protected void engageSubject() {
        if (this.subject != null) {
            this.engageSubject_();
        }
    }

    protected abstract void engageSubject_();

    protected void disengageModels() {
        this.disengageSubject();
        this.disengageSubjectHolder();
    }

    protected void disengageSubject() {
        if (this.subject != null) {
            this.disengageSubject_();
        }
    }

    protected abstract void disengageSubject_();

    protected void disengageSubjectHolder() {
        this.subjectModel.removePropertyChangeListener("value", this.subjectListener);
        this.subject = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class LocalChangeSupport
    extends SingleAspectChangeSupport {
        private static final long serialVersionUID = 1L;

        public LocalChangeSupport(AspectAdapter<S, A> source, Class<? extends EventListener> validListenerClass, String validAspectName) {
            super(source, validListenerClass, validAspectName);
        }

        protected boolean hasNoListeners() {
            return this.hasNoListeners(this.validListenerClass, this.validAspectName);
        }

        protected synchronized <T extends EventListener> void addListener(Class<T> listenerClass, T listener) {
            if (this.hasNoListeners()) {
                AspectAdapter.this.engageModels();
            }
            super.addListener(listenerClass, listener);
        }

        protected synchronized <T extends EventListener> void addListener(Class<T> listenerClass, String aspectName, T listener) {
            if (this.hasNoListeners()) {
                AspectAdapter.this.engageModels();
            }
            super.addListener(listenerClass, aspectName, listener);
        }

        protected synchronized <T extends EventListener> void removeListener(Class<T> listenerClass, T listener) {
            super.removeListener(listenerClass, listener);
            if (this.hasNoListeners()) {
                AspectAdapter.this.disengageModels();
            }
        }

        protected synchronized <T extends EventListener> void removeListener(Class<T> listenerClass, String aspectName, T listener) {
            super.removeListener(listenerClass, aspectName, listener);
            if (this.hasNoListeners()) {
                AspectAdapter.this.disengageModels();
            }
        }
    }

    protected class SubjectListener
    extends PropertyChangeAdapter {
        protected SubjectListener() {
        }

        public void propertyChanged(PropertyChangeEvent event) {
            AspectAdapter.this.subjectChanged();
        }
    }
}

