/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.transformer;

import java.util.Arrays;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformerChain<I, O>
implements Transformer<I, O> {
    private final Transformer[] transformers;

    public TransformerChain(Transformer[] transformers) {
        if (transformers == null || ArrayTools.contains(transformers, null)) {
            throw new NullPointerException();
        }
        this.transformers = transformers;
    }

    @Override
    public O transform(I input) {
        Object result = input;
        Transformer[] transformerArray = this.transformers;
        int n = this.transformers.length;
        int n2 = 0;
        while (n2 < n) {
            Transformer transformer = transformerArray[n2];
            result = transformer.transform(result);
            ++n2;
        }
        return (O)result;
    }

    public String toString() {
        return ObjectTools.toString((Object)this, Arrays.toString(this.transformers));
    }
}

