/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.storage;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.internal.storage.CommitFileRevision;
import org.eclipse.egit.core.internal.storage.IndexFileRevision;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileRevision;

public abstract class GitFileRevision
extends FileRevision {
    public static final String WORKSPACE = "Workspace";
    public static final String WORKING_TREE = "Working Tree";
    public static final String INDEX = "Index";
    private final String path;

    public static GitFileRevision inCommit(Repository db, RevCommit commit, String path, ObjectId blobId) {
        return new CommitFileRevision(db, commit, path, blobId);
    }

    public static GitFileRevision inIndex(Repository db, String path) {
        return new IndexFileRevision(db, path);
    }

    public static GitFileRevision inIndex(Repository db, String path, int stage) {
        return new IndexFileRevision(db, path, stage);
    }

    GitFileRevision(String fileName) {
        this.path = fileName;
    }

    public String getName() {
        int last = this.path.lastIndexOf(47);
        return last >= 0 ? this.path.substring(last + 1) : this.path;
    }

    public boolean isPropertyMissing() {
        return false;
    }

    public IFileRevision withAllProperties(IProgressMonitor monitor) throws CoreException {
        return this;
    }

    public URI getURI() {
        try {
            return new URI(null, null, this.path, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }
}

