/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.widgets;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jpt.common.ui.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.listeners.SWTListChangeListenerWrapper;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementIterable;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiableCollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AddRemovePane<T extends Model, E>
extends Pane<T> {
    private Adapter<E> adapter;
    private Button addButton;
    private ListValueModel<?> listModel;
    private Button optionalButton;
    private Button removeButton;
    private ModifiableCollectionValueModel<E> selectedItemsModel;
    private ListChangeListener listChangeListener;

    protected AddRemovePane(Pane<? extends T> parentPane, Composite parent, Adapter<E> adapter, ListValueModel<?> listModel, ModifiableCollectionValueModel<E> selectedItemsModel, IBaseLabelProvider labelProvider) {
        this(parentPane, parent, adapter, listModel, selectedItemsModel, labelProvider, null);
    }

    protected AddRemovePane(Pane<? extends T> parentPane, Composite parent, Adapter<E> adapter, ListValueModel<?> listModel, ModifiableCollectionValueModel<E> selectedItemsModel, IBaseLabelProvider labelProvider, String helpId) {
        super(parentPane, parent);
        this.initialize(adapter, listModel, selectedItemsModel, labelProvider);
        this.initializeLayout(adapter, listModel, selectedItemsModel, labelProvider, helpId);
    }

    protected AddRemovePane(Pane<? extends T> parentPane, Composite parent, Adapter<E> adapter, ListValueModel<?> listModel, ModifiableCollectionValueModel<E> selectedItemsModel, IBaseLabelProvider labelProvider, PropertyValueModel<Boolean> enabledModel, String helpId) {
        super(parentPane, parent, enabledModel);
        this.initialize(adapter, listModel, selectedItemsModel, labelProvider);
        this.initializeLayout(adapter, listModel, selectedItemsModel, labelProvider, helpId);
    }

    protected AddRemovePane(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent, Adapter<E> adapter, ListValueModel<?> listModel, ModifiableCollectionValueModel<E> selectedItemsModel, IBaseLabelProvider labelProvider) {
        this(parentPane, subjectHolder, parent, adapter, listModel, selectedItemsModel, labelProvider, null);
    }

    protected AddRemovePane(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent, Adapter<E> adapter, ListValueModel<?> listModel, ModifiableCollectionValueModel<E> selectedItemsModel, IBaseLabelProvider labelProvider, String helpId) {
        super(parentPane, subjectHolder, parent);
        this.initialize(adapter, listModel, selectedItemsModel, labelProvider);
        this.initializeLayout(adapter, listModel, selectedItemsModel, labelProvider, helpId);
    }

    protected void addCustomButtonAfterAddButton(Composite container, String helpId) {
    }

    protected void addCustomButtonAfterOptionalButton(Composite container, String helpId) {
    }

    protected void addItem() {
        E item = this.adapter.addNewItem();
        if (item != null) {
            this.selectedItemsModel.setValues((Iterable)new SingleElementIterable(item));
        }
    }

    protected Adapter<E> buildAdapter() {
        return null;
    }

    protected Button addAddButton(Composite parent) {
        return this.addButton(parent, this.adapter.addButtonText(), this.buildAddItemAction());
    }

    private Runnable buildAddItemAction() {
        return new Runnable(){

            public void run() {
                AddRemovePane.this.addItem();
            }
        };
    }

    private ListChangeListener buildListChangeListener() {
        return new SWTListChangeListenerWrapper(this.buildListChangeListener_());
    }

    private ListChangeListener buildListChangeListener_() {
        return new ListChangeListener(){

            public void itemsAdded(ListAddEvent e) {
                AddRemovePane.this.itemsAdded(e);
            }

            public void itemsMoved(ListMoveEvent e) {
                AddRemovePane.this.itemsMoved(e);
            }

            public void itemsRemoved(ListRemoveEvent e) {
                AddRemovePane.this.itemsRemoved(e);
            }

            public void itemsReplaced(ListReplaceEvent e) {
                AddRemovePane.this.itemsReplaced(e);
            }

            public void listChanged(ListChangeEvent e) {
                AddRemovePane.this.listChanged(e);
            }

            public void listCleared(ListClearEvent e) {
                AddRemovePane.this.listCleared(e);
            }
        };
    }

    protected void itemsAdded(ListAddEvent e) {
    }

    protected void itemsMoved(ListMoveEvent e) {
    }

    protected void itemsRemoved(ListRemoveEvent e) {
        for (Object removedItem : e.getItems()) {
            if (!IterableTools.contains(this.selectedItemsModel, removedItem)) continue;
            this.selectedItemsModel.setValues(EmptyIterable.instance());
            break;
        }
    }

    protected void itemsReplaced(ListReplaceEvent e) {
        this.selectedItemsModel.setValues((Iterable)EmptyListIterable.instance());
    }

    protected void listChanged(ListChangeEvent e) {
        this.selectedItemsModel.setValues((Iterable)EmptyListIterable.instance());
    }

    protected void listCleared(ListClearEvent e) {
        this.selectedItemsModel.setValues((Iterable)EmptyListIterable.instance());
    }

    private Runnable buildOptionalAction() {
        return new Runnable(){

            public void run() {
                AddRemovePane.this.editItem();
            }
        };
    }

    protected Button addOptionalButton(Composite container) {
        return this.addButton(container, this.adapter.optionalButtonText(), this.buildOptionalAction(), this.adapter.buildOptionalButtonEnabledModel((CollectionValueModel<E>)this.selectedItemsModel));
    }

    protected Button addRemoveButton(Composite parent) {
        return this.addButton(parent, this.adapter.removeButtonText(), this.buildRemoveItemsAction(), this.adapter.buildRemoveButtonEnabledModel((CollectionValueModel<E>)this.selectedItemsModel));
    }

    private Runnable buildRemoveItemsAction() {
        return new Runnable(){

            public void run() {
                AddRemovePane.this.removeItems();
            }
        };
    }

    protected void editItem() {
        this.adapter.optionOnSelection((CollectionValueModel<E>)this.selectedItemsModel);
    }

    protected final ListValueModel<?> getListModel() {
        return this.listModel;
    }

    public abstract Composite getMainControl();

    protected final ModifiableCollectionValueModel<E> getSelectedItemsModel() {
        return this.selectedItemsModel;
    }

    protected void initialize(Adapter<E> adapter, ListValueModel<?> listModel, ModifiableCollectionValueModel<E> selectedItemsModel, IBaseLabelProvider labelProvider) {
        this.listModel = listModel;
        this.adapter = adapter == null ? this.buildAdapter() : adapter;
        this.selectedItemsModel = selectedItemsModel;
        this.listChangeListener = this.buildListChangeListener();
        this.listModel.addListChangeListener("list values", this.listChangeListener);
    }

    protected void initializeButtonPane(Composite container, String helpId) {
        container = this.addSubPane(container);
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 128;
        container.setLayoutData((Object)gridData);
        this.addButton = this.addAddButton(container);
        this.addCustomButtonAfterAddButton(container, helpId);
        if (this.adapter.hasOptionalButton()) {
            this.optionalButton = this.addOptionalButton(container);
        }
        this.addCustomButtonAfterOptionalButton(container, helpId);
        this.removeButton = this.addRemoveButton(container);
        if (helpId != null) {
            this.setHelp((Control)this.addButton, helpId);
            this.setHelp((Control)this.removeButton, helpId);
            if (this.optionalButton != null) {
                this.setHelp((Control)this.optionalButton, helpId);
            }
        }
    }

    protected void initializeLayout(Adapter<E> adapter, ListValueModel<?> listModel, ModifiableCollectionValueModel<E> selectedItemsModel, IBaseLabelProvider labelProvider, String helpId) {
        this.initializeMainComposite((Composite)this.getControl(), adapter, listModel, selectedItemsModel, labelProvider, helpId);
        this.initializeButtonPane((Composite)this.getControl(), helpId);
    }

    @Override
    protected Composite addComposite(Composite parent) {
        return this.addSubPane(parent, 2, 0, 0, 0, 0);
    }

    @Override
    protected void initializeLayout(Composite container) {
    }

    protected abstract void initializeMainComposite(Composite var1, Adapter<E> var2, ListValueModel<?> var3, ModifiableCollectionValueModel<E> var4, IBaseLabelProvider var5, String var6);

    protected void removeItems() {
        this.adapter.removeSelectedItems((CollectionValueModel<E>)this.selectedItemsModel);
        this.selectedItemsModel.setValues((Iterable)EmptyListIterable.instance());
    }

    public void setSelectedItem(E value) {
        this.selectedItemsModel.setValues((Iterable)new SingleElementIterable(value));
    }

    @Override
    protected void controlDisposed() {
        this.listModel.removeListChangeListener("list values", this.listChangeListener);
        super.controlDisposed();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractAdapter<E>
    implements Adapter<E> {
        private String addButtonText;
        private boolean hasOptionalButton;
        private String optionalButtonText;
        private String removeButtonText;

        public AbstractAdapter() {
            this(JptCommonUiMessages.ADD_REMOVE_PANE__ADD_BUTTON_TEXT, JptCommonUiMessages.ADD_REMOVE_PANE__REMOVE_BUTTON_TEXT);
        }

        public AbstractAdapter(boolean hasOptionalButton) {
            this();
            this.setHasOptionalButton(hasOptionalButton);
        }

        public AbstractAdapter(String optionalButtonText) {
            this(true);
            this.setOptionalButtonText(optionalButtonText);
        }

        public AbstractAdapter(String addButtonText, String removeButtonText) {
            this.addButtonText = addButtonText;
            this.removeButtonText = removeButtonText;
        }

        public AbstractAdapter(String addButtonText, String removeButtonText, String optionalButtonText) {
            this(optionalButtonText);
            this.setAddButtonText(addButtonText);
            this.setRemoveButtonText(removeButtonText);
        }

        @Override
        public String addButtonText() {
            return this.addButtonText;
        }

        @Override
        public PropertyValueModel<Boolean> buildOptionalButtonEnabledModel(CollectionValueModel<E> selectedItemsModel) {
            return this.buildSingleSelectedItemEnabledModel(selectedItemsModel);
        }

        protected PropertyValueModel<Boolean> buildSingleSelectedItemEnabledModel(CollectionValueModel<E> selectedItemsModel) {
            return new CollectionPropertyValueModelAdapter<Boolean, Object>(selectedItemsModel){

                protected Boolean buildValue() {
                    return this.collectionModel.size() == 1;
                }
            };
        }

        @Override
        public PropertyValueModel<Boolean> buildRemoveButtonEnabledModel(CollectionValueModel<E> selectedItemsModel) {
            return this.buildMultipleSelectedItemsEnabledModel(selectedItemsModel);
        }

        protected PropertyValueModel<Boolean> buildMultipleSelectedItemsEnabledModel(CollectionValueModel<E> selectedItemsModel) {
            return new CollectionPropertyValueModelAdapter<Boolean, E>(selectedItemsModel){

                protected Boolean buildValue() {
                    return this.collectionModel.size() >= 1;
                }
            };
        }

        @Override
        public boolean hasOptionalButton() {
            return this.hasOptionalButton;
        }

        @Override
        public String optionalButtonText() {
            return this.optionalButtonText;
        }

        @Override
        public void optionOnSelection(CollectionValueModel<E> selectedItemsModel) {
        }

        @Override
        public String removeButtonText() {
            return this.removeButtonText;
        }

        public void setAddButtonText(String addButtonText) {
            this.addButtonText = addButtonText;
        }

        public void setHasOptionalButton(boolean hasOptionalButton) {
            this.hasOptionalButton = hasOptionalButton;
        }

        public void setOptionalButtonText(String optionalButtonText) {
            this.optionalButtonText = optionalButtonText;
        }

        public void setRemoveButtonText(String removeButtonText) {
            this.removeButtonText = removeButtonText;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Adapter<E> {
        public String addButtonText();

        public E addNewItem();

        public PropertyValueModel<Boolean> buildRemoveButtonEnabledModel(CollectionValueModel<E> var1);

        public PropertyValueModel<Boolean> buildOptionalButtonEnabledModel(CollectionValueModel<E> var1);

        public boolean hasOptionalButton();

        public String optionalButtonText();

        public void optionOnSelection(CollectionValueModel<E> var1);

        public String removeButtonText();

        public void removeSelectedItems(CollectionValueModel<E> var1);
    }
}

