/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jst.j2ee.internal.common.operations.Method;
import org.eclipse.jst.j2ee.internal.web.operations.CreateWebClassTemplateModel;
import org.eclipse.jst.j2ee.internal.web.operations.ServletSupertypesValidator;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateServletTemplateModel
extends CreateWebClassTemplateModel {
    public static final int NAME = 0;
    public static final int VALUE = 1;
    public static final int DESCRIPTION = 2;

    public CreateServletTemplateModel(IDataModel dataModel) {
        super(dataModel);
    }

    public Collection<String> getImports() {
        Collection collection = super.getImports();
        if (this.shouldGenInit()) {
            collection.add("javax.servlet.ServletConfig");
            collection.add("javax.servlet.ServletException");
        }
        if (this.shouldGenGetServletConfig()) {
            collection.add("javax.servlet.ServletConfig");
        }
        if (this.shouldGenService()) {
            if (this.isHttpServletSuperclass()) {
                collection.add("javax.servlet.http.HttpServletRequest");
                collection.add("javax.servlet.http.HttpServletResponse");
            } else {
                collection.add("javax.servlet.ServletRequest");
                collection.add("javax.servlet.ServletResponse");
            }
            collection.add("javax.servlet.ServletException");
            collection.add("java.io.IOException");
        }
        if (this.shouldGenDoGet() || this.shouldGenDoPost() || this.shouldGenDoPut() || this.shouldGenDoDelete() || this.shouldGenDoHead() || this.shouldGenDoOptions() || this.shouldGenDoTrace()) {
            collection.add("javax.servlet.http.HttpServletRequest");
            collection.add("javax.servlet.http.HttpServletResponse");
            collection.add("javax.servlet.ServletException");
            collection.add("java.io.IOException");
        }
        if ("3.0".equals(this.getJavaEEVersion()) || "3.1".equals(this.getJavaEEVersion())) {
            collection.add("javax.servlet.annotation.WebServlet");
            if (this.getInitParams() != null && this.getInitParams().size() > 0) {
                collection.add("javax.servlet.annotation.WebInitParam");
            }
        }
        return collection;
    }

    public String getServletName() {
        return super.getDisplayName();
    }

    public String getServletClassName() {
        return super.getClassName();
    }

    public boolean shouldGenInit() {
        return this.implementImplementedMethod("init");
    }

    public boolean shouldGenDestroy() {
        return this.implementImplementedMethod("destroy");
    }

    public boolean shouldGenGetServletConfig() {
        return this.implementImplementedMethod("getServletConfig");
    }

    public boolean shouldGenGetServletInfo() {
        return this.implementImplementedMethod("getServletInfo");
    }

    public boolean shouldGenService() {
        return this.implementImplementedMethod("service");
    }

    public boolean shouldGenDoGet() {
        return this.implementImplementedMethod("doGet");
    }

    public boolean shouldGenDoPost() {
        return this.implementImplementedMethod("doPost");
    }

    public boolean shouldGenDoPut() {
        return this.implementImplementedMethod("doPut");
    }

    public boolean shouldGenDoDelete() {
        return this.implementImplementedMethod("doDelete");
    }

    public boolean shouldGenDoHead() {
        return this.implementImplementedMethod("doHead");
    }

    public boolean shouldGenDoOptions() {
        return this.implementImplementedMethod("doOptions");
    }

    public boolean shouldGenDoTrace() {
        return this.implementImplementedMethod("doTrace");
    }

    public boolean shouldGenToString() {
        return this.implementImplementedMethod("toString");
    }

    public boolean isGenericServletSuperclass() {
        return ServletSupertypesValidator.isGenericServletSuperclass(this.dataModel);
    }

    public boolean isHttpServletSuperclass() {
        return ServletSupertypesValidator.isHttpServletSuperclass(this.dataModel);
    }

    public List<String[]> getInitParams() {
        return (List)this.dataModel.getProperty("NewServletClassDataModel.INIT_PARAM");
    }

    public String getInitParam(int index, int type) {
        List<String[]> params = this.getInitParams();
        if (index < params.size()) {
            String[] stringArray = params.get(index);
            return stringArray[type];
        }
        return null;
    }

    public List<String[]> getServletMappings() {
        return (List)this.dataModel.getProperty("NewServletClassDataModel.URL_MAPPINGS");
    }

    public String getServletMapping(int index) {
        List<String[]> mappings = this.getServletMappings();
        if (index < mappings.size()) {
            String[] map = mappings.get(index);
            return map[0];
        }
        return null;
    }

    public String getServletDescription() {
        return super.getDescription();
    }

    protected boolean implementImplementedMethod(String methodName) {
        if (this.dataModel.getBooleanProperty("NewJavaClassDataModel.ABSTRACT_METHODS")) {
            if (methodName.equals("init")) {
                return this.dataModel.getBooleanProperty("NewServletClassDataModel.INIT");
            }
            if (methodName.equals("destroy")) {
                return this.dataModel.getBooleanProperty("NewServletClassDataModel.DESTROY");
            }
            if (methodName.equals("getServletConfig")) {
                return this.dataModel.getBooleanProperty("NewServletClassDataModel.GET_SERVLET_CONFIG");
            }
            if (methodName.equals("getServletInfo")) {
                return this.dataModel.getBooleanProperty("NewServletClassDataModel.GET_SERVLET_INFO");
            }
            if (methodName.equals("service")) {
                return this.dataModel.getBooleanProperty("NewServletClassDataModel.SERVICE");
            }
            if (methodName.equals("doGet")) {
                return this.dataModel.getBooleanProperty("NewServletClassDataModel.DO_GET");
            }
            if (methodName.equals("doPost")) {
                return this.dataModel.getBooleanProperty("NewServletClassDataModel.DO_POST");
            }
            if (methodName.equals("doPut")) {
                return this.dataModel.getBooleanProperty("NewServletClassDataModel.DO_PUT");
            }
            if (methodName.equals("doDelete")) {
                return this.dataModel.getBooleanProperty("NewServletClassDataModel.DO_DELETE");
            }
            if (methodName.equals("doHead")) {
                return this.dataModel.getBooleanProperty("NewServletClassDataModel.DO_HEAD");
            }
            if (methodName.equals("doOptions")) {
                return this.dataModel.getBooleanProperty("NewServletClassDataModel.DO_OPTIONS");
            }
            if (methodName.equals("doTrace")) {
                return this.dataModel.getBooleanProperty("NewServletClassDataModel.DO_TRACE");
            }
        }
        return false;
    }

    public Collection<Method> getUnimplementedMethods() {
        Collection unimplementedMethods = super.getUnimplementedMethods();
        Iterator iterator = unimplementedMethods.iterator();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            if (!("init".equals(method.getName()) && "(Ljavax/servlet/ServletConfig;)V".equals(method.getSignature()) || "destroy".equals(method.getName()) && "()V".equals(method.getSignature()) || "getServletConfig".equals(method.getName()) && "()Ljavax/servlet/ServletConfig;".equals(method.getSignature()) || "getServletInfo".equals(method.getName()) && "()Ljava/lang/String;".equals(method.getSignature()) || "service".equals(method.getName()) && "(Ljavax/servlet/ServletRequest;Ljavax/servlet/ServletResponse;)V".equals(method.getSignature()) || "service".equals(method.getName()) && "(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V".equals(method.getSignature()) || "doGet".equals(method.getName()) && "(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V".equals(method.getSignature()) || "doPost".equals(method.getName()) && "(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V".equals(method.getSignature()) || "doPut".equals(method.getName()) && "(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V".equals(method.getSignature()) || "doDelete".equals(method.getName()) && "(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V".equals(method.getSignature()) || "doHead".equals(method.getName()) && "(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V".equals(method.getSignature()) || "doOptions".equals(method.getName()) && "doOptions".equals(method.getSignature())) && (!"doTrace".equals(method.getName()) || !"(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V".equals(method.getSignature()))) continue;
            iterator.remove();
        }
        return unimplementedMethods;
    }

    public Map<String, Object> getClassAnnotationParams() {
        List<String[]> initParams;
        List<String[]> servletMappings;
        String description;
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        String dispName = this.getServletName().trim();
        if (!dispName.equals(this.getClassName()) && dispName.length() > 0) {
            result.put("name", dispName);
        }
        if ((description = this.getDescription().trim()).length() > 0) {
            result.put("description", description);
        }
        if ((servletMappings = this.getServletMappings()) != null && servletMappings.size() > 0) {
            result.put("urlPatterns", servletMappings);
        }
        if ((initParams = this.getInitParams()) != null && initParams.size() > 0) {
            result.put("initParams", initParams);
        }
        return result;
    }
}

