/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.datatools.sqltools.result.IResultSetObject;
import org.eclipse.datatools.sqltools.result.IResultSetRow;
import org.eclipse.datatools.sqltools.result.ResultSetRow;
import org.eclipse.datatools.sqltools.result.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.internal.utils.ILogger;
import org.eclipse.datatools.sqltools.result.internal.utils.SQLUtil;

public class ResultSetObject
implements IResultSetObject {
    private static final long serialVersionUID = 1L;
    private String[] _columnNames;
    private String[] _columnTypeNames;
    private List _rows;
    private int[] _columnTypes;
    private int[] _columnDisplaySizes;
    private int _rowCountLoaded;
    private int _totalRowCount;
    private File _backupFile;
    private static ILogger _log = ResultsViewPlugin.getLogger(null);
    private transient ResultSetMetaData _meta;

    public ResultSetObject(ResultSet resultset, int maxRowCount, int maxDisplayRowCount) throws SQLException {
        this(resultset, maxRowCount, maxDisplayRowCount, true);
    }

    public ResultSetObject(ResultSet resultset, int maxRowCount, int maxDisplayRowCount, boolean showLabels) throws SQLException {
        block28: {
            ObjectOutputStream oos = null;
            try {
                try {
                    ResultSetMetaData meta;
                    this._meta = meta = resultset.getMetaData();
                    int columnCount = meta.getColumnCount();
                    this._totalRowCount = 0;
                    this._rows = new ArrayList();
                    this._columnNames = new String[columnCount];
                    this._columnDisplaySizes = new int[columnCount];
                    this._columnTypes = new int[columnCount];
                    int i = 0;
                    while (i < columnCount) {
                        if (showLabels) {
                            this._columnNames[i] = meta.getColumnLabel(i + 1);
                            if (this._columnNames[i] == null || this._columnNames[i].trim().equals("")) {
                                this._columnNames[i] = meta.getColumnName(i + 1);
                            }
                        } else {
                            this._columnNames[i] = meta.getColumnName(i + 1);
                        }
                        this._columnDisplaySizes[i] = meta.getColumnDisplaySize(i + 1);
                        this._columnTypes[i] = meta.getColumnType(i + 1);
                        ++i;
                    }
                    ResultSetRow row = null;
                    while (resultset.next() && (this._totalRowCount < maxRowCount || maxRowCount == 0)) {
                        row = new ResultSetRow(columnCount);
                        int i2 = 0;
                        while (i2 < columnCount) {
                            row.setData(SQLUtil.getObjectByTypeCoercion(resultset, i2 + 1, this._meta.getColumnType(i2 + 1)), i2);
                            ++i2;
                        }
                        ++this._totalRowCount;
                        if (this._totalRowCount < maxDisplayRowCount) {
                            this._rows.add(row);
                            continue;
                        }
                        if (this._totalRowCount == maxDisplayRowCount) {
                            this._rows.add(row);
                            if (this._backupFile == null) {
                                File dir = new File(ResultsViewPlugin.getDefault().getTempDir());
                                if (!dir.exists()) {
                                    dir.mkdir();
                                }
                                this._backupFile = File.createTempFile(String.valueOf(resultset.hashCode()), ".result", dir);
                                if (this._backupFile.exists()) {
                                    oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this._backupFile)));
                                }
                            }
                            Iterator iter = this._rows.iterator();
                            while (iter.hasNext()) {
                                SQLUtil.saveResultToStream(oos, iter.next());
                            }
                            continue;
                        }
                        if (this._totalRowCount <= maxDisplayRowCount) continue;
                        SQLUtil.saveResultToStream(oos, row);
                    }
                    this._rowCountLoaded = this._rows.size();
                }
                catch (SQLException e) {
                    throw e;
                }
                catch (Exception exception) {
                    if (this._backupFile != null && this._backupFile.exists()) {
                        this._backupFile.delete();
                    }
                    try {
                        if (oos != null) {
                            oos.close();
                            oos = null;
                        }
                        break block28;
                    }
                    catch (IOException iOException) {}
                    break block28;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (oos != null) {
                        oos.close();
                        oos = null;
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (oos != null) {
                    oos.close();
                    oos = null;
                }
            }
            catch (IOException iOException) {}
        }
    }

    public ResultSetObject(List rows, String[] columnNames, int[] columnTypes, int[] columnDisplaySizes) {
        Assert.isTrue((rows != null && columnNames != null && columnDisplaySizes != null && columnTypes != null ? 1 : 0) != 0);
        int columnCount = columnNames.length;
        Assert.isTrue((columnTypes.length == columnCount && columnDisplaySizes.length == columnCount ? 1 : 0) != 0);
        for (Object obj : rows) {
            Assert.isNotNull(obj);
            Assert.isTrue((boolean)(obj instanceof IResultSetRow));
        }
        int i = 0;
        while (i < columnCount) {
            if (columnDisplaySizes[i] < 0) {
                columnDisplaySizes[i] = 0;
            }
            if (columnNames[i] == null) {
                columnNames[i] = "";
            }
            ++i;
        }
        this._rows = rows;
        this._columnNames = columnNames;
        this._columnTypes = columnTypes;
        this._columnDisplaySizes = columnDisplaySizes;
        this._totalRowCount = this._rowCountLoaded = this._rows.size();
    }

    public ResultSetObject(List rows, String[] columnNames, int[] columnTypes, int[] columnDisplaySizes, String[] typeNames, int maxDisplayRows) {
        block22: {
            this(rows, columnNames, columnTypes, columnDisplaySizes);
            ArrayList temp = new ArrayList();
            this._columnTypeNames = typeNames;
            this._totalRowCount = rows.size();
            if (maxDisplayRows != 0 && maxDisplayRows < this._rows.size()) {
                int i = 0;
                while (i < maxDisplayRows) {
                    temp.add(rows.get(i));
                    ++i;
                }
                this._rows = temp;
                this._rowCountLoaded = maxDisplayRows;
            }
            ObjectOutputStream oos = null;
            if (this._totalRowCount > maxDisplayRows) {
                try {
                    try {
                        if (this._backupFile == null) {
                            File dir = new File(ResultsViewPlugin.getDefault().getTempDir());
                            if (!dir.exists()) {
                                dir.mkdir();
                            }
                            this._backupFile = File.createTempFile(String.valueOf(rows.hashCode()), ".result", dir);
                            if (this._backupFile.exists()) {
                                oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this._backupFile)));
                            }
                        }
                        Iterator iter = rows.iterator();
                        while (iter.hasNext()) {
                            SQLUtil.saveResultToStream(oos, iter.next());
                        }
                    }
                    catch (IOException iOException) {
                        if (this._backupFile != null && this._backupFile.exists()) {
                            this._backupFile.delete();
                        }
                        try {
                            if (oos != null) {
                                oos.close();
                                oos = null;
                            }
                            break block22;
                        }
                        catch (IOException iOException2) {}
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (oos != null) {
                            oos.close();
                            oos = null;
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (oos != null) {
                        oos.close();
                        oos = null;
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public int getColumnCount() {
        return this._columnNames.length;
    }

    public String[] getColumnNames() {
        return this._columnNames;
    }

    public String[] getColumnTypeNames() {
        try {
            if (this._columnTypeNames == null && this._meta != null) {
                int columnCount = this._meta.getColumnCount();
                this._columnTypeNames = new String[columnCount];
                int i = 0;
                while (i < columnCount) {
                    this._columnTypeNames[i] = this._meta.getColumnTypeName(i + 1);
                    ++i;
                }
            }
        }
        catch (Exception exception) {}
        return this._columnTypeNames;
    }

    public String getColumnName(int index) {
        if (index < 1 || index > this._columnNames.length) {
            return null;
        }
        return this._columnNames[index - 1];
    }

    public int[] getColumnDisplaySizes() {
        return this._columnDisplaySizes;
    }

    public int getColumnDisplaySize(int index) {
        if (index < 1 || index > this._columnDisplaySizes.length) {
            return 0;
        }
        return this._columnDisplaySizes[index - 1];
    }

    public int[] getColumnSQLTypes() {
        return this._columnTypes;
    }

    public int getColumnSQLType(int index) {
        if (index < 1 || index > this._columnTypes.length) {
            return 1;
        }
        return this._columnTypes[index - 1];
    }

    public int getRowCount() {
        return this._rowCountLoaded;
    }

    public int getTotalRowCount() {
        return this._totalRowCount;
    }

    public IResultSetRow getRowData(int row) {
        if (row < 0 || row > this._rows.size() - 1) {
            return null;
        }
        return (IResultSetRow)this._rows.get(row);
    }

    public Iterator getAllRecords() {
        if (this._backupFile == null) {
            return this._rows.iterator();
        }
        BackupRecord iter = new BackupRecord(this._backupFile);
        return iter;
    }

    public Iterator getDisplayRecords() {
        return this._rows.iterator();
    }

    public boolean isAllResultLoaded() {
        return this._totalRowCount == this._rowCountLoaded;
    }

    public void dispose() {
        if (this._backupFile != null && this._backupFile.exists()) {
            this._backupFile.delete();
        }
        this._rows.clear();
    }

    private class BackupRecord
    implements Iterator {
        File _backupFile;
        ObjectInputStream _ois;
        Object _nextRecord = null;
        int _index = 0;

        public BackupRecord(File backupFile) {
            this._backupFile = backupFile;
            if (backupFile != null && backupFile.exists()) {
                try {
                    this._ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(backupFile)));
                    this._nextRecord = SQLUtil.getResultFromStream(this._ois);
                }
                catch (Exception e) {
                    _log.error("ResultSetObjectImpl_error_iterator", (Throwable)e);
                }
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this._nextRecord != null;
        }

        public Object next() {
            Object current = this._nextRecord;
            if (this._ois != null) {
                IResultSetRow row = (IResultSetRow)SQLUtil.getResultFromStream(this._ois);
                this._nextRecord = row;
                ++this._index;
                if (this._nextRecord == null) {
                    try {
                        this._ois.close();
                        this._ois = null;
                    }
                    catch (IOException e) {
                        _log.error("ResultSetObjectImpl_error_next", (Throwable)e);
                    }
                }
            }
            return current;
        }
    }
}

