/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.embedder;

import java.io.Serializable;
import org.apache.maven.artifact.Artifact;
import org.eclipse.osgi.util.NLS;

public class ArtifactKey
implements Serializable {
    private static final long serialVersionUID = -8984509272834024387L;
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String classifier;

    public ArtifactKey(Artifact a) {
        this(a.getGroupId(), a.getArtifactId(), a.getBaseVersion(), null);
    }

    public ArtifactKey(org.sonatype.aether.artifact.Artifact a) {
        this(a.getGroupId(), a.getArtifactId(), a.getBaseVersion(), null);
    }

    public ArtifactKey(String groupId, String artifactId, String version, String classifier) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = classifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ArtifactKey) {
            ArtifactKey other = (ArtifactKey)o;
            return ArtifactKey.equals(this.groupId, other.groupId) && ArtifactKey.equals(this.artifactId, other.artifactId) && ArtifactKey.equals(this.version, other.version) && ArtifactKey.equals(this.classifier, other.classifier);
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + (this.groupId != null ? this.groupId.hashCode() : 0);
        hash = hash * 31 + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        hash = hash * 31 + (this.version != null ? this.version.hashCode() : 0);
        hash = hash * 31 + (this.classifier != null ? this.classifier.hashCode() : 0);
        return hash;
    }

    private static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static boolean equals(Artifact a1, Artifact a2) {
        if (a1 == null) {
            return a2 == null;
        }
        if (a2 == null) {
            return false;
        }
        return ArtifactKey.equals(a1.getGroupId(), a2.getGroupId()) && ArtifactKey.equals(a1.getArtifactId(), a2.getArtifactId()) && ArtifactKey.equals(a1.getVersion(), a2.getVersion()) && ArtifactKey.equals(a1.getClassifier(), a2.getClassifier());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.groupId).append(':').append(this.artifactId).append(':').append(this.version);
        if (this.classifier != null) {
            sb.append(':').append(this.classifier);
        }
        return sb.toString();
    }

    public static ArtifactKey fromPortableString(String str) {
        int p = 0;
        int c = ArtifactKey.nextColonIndex(str, p);
        String groupId = ArtifactKey.substring(str, p, c);
        p = c + 1;
        c = ArtifactKey.nextColonIndex(str, p);
        String artifactId = ArtifactKey.substring(str, p, c);
        p = c + 1;
        c = ArtifactKey.nextColonIndex(str, p);
        String version = ArtifactKey.substring(str, p, c);
        p = c + 1;
        c = ArtifactKey.nextColonIndex(str, p);
        String classifier = ArtifactKey.substring(str, p, c);
        return new ArtifactKey(groupId, artifactId, version, classifier);
    }

    private static String substring(String str, int start, int end) {
        String substring = str.substring(start, end);
        return "".equals(substring) ? null : substring;
    }

    private static int nextColonIndex(String str, int pos) {
        int idx = str.indexOf(58, pos);
        if (idx < 0) {
            throw new IllegalArgumentException(NLS.bind((String)"Invalid portable string: {0}", (Object)str));
        }
        return idx;
    }

    public String toPortableString() {
        StringBuilder sb = new StringBuilder();
        if (this.groupId != null) {
            sb.append(this.groupId);
        }
        sb.append(':');
        if (this.artifactId != null) {
            sb.append(this.artifactId);
        }
        sb.append(':');
        if (this.version != null) {
            sb.append(this.version);
        }
        sb.append(':');
        if (this.classifier != null) {
            sb.append(this.classifier);
        }
        sb.append(':');
        return sb.toString();
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }
}

