/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.embedder;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.codehaus.plexus.classworlds.launcher.ConfigurationHandler;
import org.codehaus.plexus.classworlds.launcher.ConfigurationParser;
import org.codehaus.plexus.util.DirectoryScanner;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.embedder.IMavenLauncherConfiguration;
import org.eclipse.m2e.core.embedder.MavenRuntime;
import org.eclipse.m2e.core.internal.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenExternalRuntime
implements MavenRuntime {
    private static final Logger log = LoggerFactory.getLogger(MavenExternalRuntime.class);
    private static final String PROPERTY_MAVEN_HOME = "maven.home";
    private final String location;

    public MavenExternalRuntime(String location) {
        this.location = location;
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public boolean isAvailable() {
        return new File(this.location, "bin").exists() && this.getLauncherClasspath() != null;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public String getSettings() {
        return String.valueOf(this.location) + File.separator + "conf" + File.separator + "settings.xml";
    }

    public String getMainTypeName() {
        return "org.codehaus.classworlds.Launcher";
    }

    private File getLauncherConfigurationFile() {
        File m2Conf = new File(this.location, "bin/m2.conf");
        if (!m2Conf.exists()) {
            m2Conf = new File(this.location, "conf/m2.conf");
        }
        return m2Conf;
    }

    @Override
    public void createLauncherConfiguration(final IMavenLauncherConfiguration collector, IProgressMonitor monitor) throws CoreException {
        collector.addRealm("]launcher");
        collector.addArchiveEntry(this.getLauncherClasspath());
        ConfigurationHandler handler = new ConfigurationHandler(){

            public void addImportFrom(String relamName, String importSpec) {
                throw new UnsupportedOperationException(Messages.MavenExternalRuntime_exc_unsupported);
            }

            public void addLoadFile(File file) {
                try {
                    collector.addArchiveEntry(file.getAbsolutePath());
                }
                catch (CoreException ex) {
                    throw new ExceptionWrapper((Exception)((Object)ex));
                }
            }

            public void addLoadURL(URL url) {
                try {
                    collector.addArchiveEntry(url.toExternalForm());
                }
                catch (CoreException ex) {
                    throw new ExceptionWrapper((Exception)((Object)ex));
                }
            }

            public void addRealm(String realmName) {
                collector.addRealm(realmName);
            }

            public void setAppMain(String mainClassName, String mainRealmName) {
                collector.setMainType(mainClassName, mainRealmName);
            }
        };
        Properties properties = new Properties();
        properties.put(PROPERTY_MAVEN_HOME, this.location);
        ConfigurationParser parser = new ConfigurationParser(handler, properties);
        try {
            FileInputStream is = new FileInputStream(this.getLauncherConfigurationFile());
            try {
                parser.parse((InputStream)is);
            }
            finally {
                is.close();
            }
        }
        catch (Exception e) {
            if (e instanceof ExceptionWrapper && e.getCause() instanceof CoreException) {
                throw (CoreException)e.getCause();
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.MavenExternalRuntime_error_cannot_parse, (Throwable)e));
        }
    }

    public boolean equals(Object o) {
        if (o instanceof MavenExternalRuntime) {
            return this.location.equals(((MavenExternalRuntime)o).location);
        }
        return false;
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    public String toString() {
        return "External " + this.location + " (" + this.getVersion() + ")";
    }

    private String getLauncherClasspath() {
        File mavenHome = new File(this.location);
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(mavenHome);
        ds.setIncludes(new String[]{"core/boot/classworlds*.jar", "boot/classworlds*.jar", "boot/plexus-classworlds*.jar"});
        ds.scan();
        String[] includedFiles = ds.getIncludedFiles();
        if (includedFiles.length == 1) {
            return new File(mavenHome, includedFiles[0]).getAbsolutePath();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getVersion() {
        class VersionHandler
        implements ConfigurationHandler {
            File mavenCore;
            File uber;

            VersionHandler() {
            }

            public void addImportFrom(String relamName, String importSpec) {
            }

            public void addLoadFile(File file) {
                if (file.getName().contains("maven-core")) {
                    this.mavenCore = file;
                } else if (file.getName().endsWith("uber.jar")) {
                    this.uber = file;
                }
            }

            public void addLoadURL(URL url) {
            }

            public void addRealm(String realmName) {
            }

            public void setAppMain(String mainClassName, String mainRealmName) {
            }
        }
        VersionHandler handler = new VersionHandler();
        Properties properties = new Properties();
        properties.put(PROPERTY_MAVEN_HOME, this.location);
        ConfigurationParser parser = new ConfigurationParser((ConfigurationHandler)handler, properties);
        try {
            FileInputStream is = new FileInputStream(this.getLauncherConfigurationFile());
            try {
                parser.parse((InputStream)is);
            }
            finally {
                is.close();
            }
            ZipFile zip = null;
            if (handler.mavenCore != null) {
                zip = new ZipFile(handler.mavenCore);
            } else if (handler.uber != null) {
                zip = new ZipFile(handler.uber);
            }
            if (zip == null) return Messages.MavenExternalRuntime_unknown;
            try {
                ZipEntry zipEntry = zip.getEntry("META-INF/maven/org.apache.maven/maven-core/pom.properties");
                if (zipEntry == null) return Messages.MavenExternalRuntime_unknown;
                Properties pomProperties = new Properties();
                pomProperties.load(zip.getInputStream(zipEntry));
                String version = pomProperties.getProperty("version");
                if (version == null) return Messages.MavenExternalRuntime_unknown;
                String string = version;
                return string;
            }
            finally {
                zip.close();
            }
        }
        catch (Exception e) {
            log.error("Could not parse classwords configuration file", (Throwable)e);
        }
        return Messages.MavenExternalRuntime_unknown;
    }

    private static class ExceptionWrapper
    extends RuntimeException {
        private static final long serialVersionUID = 8815818826909815028L;

        public ExceptionWrapper(Exception cause) {
            super(cause);
        }
    }
}

