/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project.registry;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.project.registry.Capability;
import org.eclipse.m2e.core.internal.project.registry.MavenProjectFacade;
import org.eclipse.m2e.core.internal.project.registry.RequiredCapability;
import org.eclipse.m2e.core.internal.project.registry.VersionlessKey;

abstract class BasicProjectRegistry
implements Serializable {
    private static final long serialVersionUID = 5542512601401896748L;
    private final String m2e_version = MavenPluginActivator.getQualifiedVersion();
    protected final Map<ArtifactKey, IFile> workspaceArtifacts = new HashMap<ArtifactKey, IFile>();
    protected final Map<IFile, MavenProjectFacade> workspacePoms = new HashMap<IFile, MavenProjectFacade>();
    protected final Map<VersionlessKey, Map<RequiredCapability, Set<IFile>>> requiredCapabilities = new HashMap<VersionlessKey, Map<RequiredCapability, Set<IFile>>>();
    protected final Map<IFile, Set<Capability>> projectCapabilities = new HashMap<IFile, Set<Capability>>();
    protected final Map<IFile, Set<RequiredCapability>> projectRequirements = new HashMap<IFile, Set<RequiredCapability>>();

    protected BasicProjectRegistry() {
    }

    protected BasicProjectRegistry(BasicProjectRegistry other) {
        this.replaceWith(other);
    }

    protected final void replaceWith(BasicProjectRegistry other) {
        this.clear();
        BasicProjectRegistry.copy(other.workspaceArtifacts, this.workspaceArtifacts);
        BasicProjectRegistry.copy(other.workspacePoms, this.workspacePoms);
        BasicProjectRegistry.copy(other.projectCapabilities, this.projectCapabilities);
        BasicProjectRegistry.copy(other.projectRequirements, this.projectRequirements);
        BasicProjectRegistry.copy(other.requiredCapabilities, this.requiredCapabilities);
    }

    private static void copy(Map from, Map to) {
        for (Map.Entry entry : from.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Map) {
                LinkedHashMap map = new LinkedHashMap();
                BasicProjectRegistry.copy((Map)value, map);
                value = map;
            } else if (value instanceof Set) {
                LinkedHashSet set = new LinkedHashSet((Set)value);
                value = set;
            }
            to.put(entry.getKey(), value);
        }
    }

    public MavenProjectFacade getProjectFacade(IFile pom) {
        return this.workspacePoms.get(pom);
    }

    public MavenProjectFacade getProjectFacade(String groupId, String artifactId, String version) {
        IFile path = this.workspaceArtifacts.get(new ArtifactKey(groupId, artifactId, version, null));
        if (path == null) {
            return null;
        }
        return this.workspacePoms.get(path);
    }

    public MavenProjectFacade[] getProjects() {
        return this.workspacePoms.values().toArray(new MavenProjectFacade[this.workspacePoms.size()]);
    }

    public IFile getWorkspaceArtifact(ArtifactKey key) {
        return this.workspaceArtifacts.get(key);
    }

    protected void clear() {
        this.workspaceArtifacts.clear();
        this.workspacePoms.clear();
        this.requiredCapabilities.clear();
        this.projectCapabilities.clear();
        this.projectRequirements.clear();
    }

    public boolean isValid() {
        return MavenPluginActivator.getQualifiedVersion().equals(this.m2e_version) && this.workspaceArtifacts != null && this.workspacePoms != null && this.requiredCapabilities != null && this.projectCapabilities != null && this.projectRequirements != null && this.areFacadesValid();
    }

    private boolean areFacadesValid() {
        for (MavenProjectFacade facade : this.workspacePoms.values()) {
            if (facade != null && facade.getPom() != null && facade.getPom().getLocation() != null) continue;
            return false;
        }
        return true;
    }

    protected Set<RequiredCapability> getProjectRequirements(IFile pom) {
        return this.projectRequirements.get(pom);
    }
}

