/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project.registry;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.ArtifactRef;
import org.eclipse.m2e.core.embedder.ArtifactRepositoryRef;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistryManager;
import org.eclipse.m2e.core.lifecyclemapping.model.IPluginExecutionMetadata;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectUtils;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;

public class MavenProjectFacade
implements IMavenProjectFacade,
Serializable {
    private static final long serialVersionUID = -3648172776786224087L;
    public static final String PROP_LIFECYCLE_MAPPING = String.valueOf(MavenProjectFacade.class.getName()) + "/lifecycleMapping";
    public static final String PROP_CONFIGURATORS = String.valueOf(MavenProjectFacade.class.getName()) + "/configurators";
    private final ProjectRegistryManager manager;
    private final IFile pom;
    private final File pomFile;
    private transient MavenProject mavenProject;
    private transient Map<String, List<MojoExecution>> executionPlans;
    private transient Map<MojoExecutionKey, MojoExecution> setupMojoExecutions;
    private transient Map<String, Object> sessionProperties;
    private final ResolverConfiguration resolverConfiguration;
    private final long[] timestamp = new long[ProjectRegistryManager.METADATA_PATH.size() + 1];
    private final ArtifactKey artifactKey;
    private final List<String> modules;
    private final String packaging;
    private final IPath[] resourceLocations;
    private final IPath[] testResourceLocations;
    private final IPath[] compileSourceLocations;
    private final IPath[] testCompileSourceLocations;
    private final IPath outputLocation;
    private final IPath testOutputLocation;
    private final Set<ArtifactRepositoryRef> artifactRepositories;
    private final Set<ArtifactRepositoryRef> pluginArtifactRepositories;
    private Set<ArtifactRef> artifacts;
    private String lifecycleMappingId;
    private Map<MojoExecutionKey, List<IPluginExecutionMetadata>> mojoExecutionMapping;

    public MavenProjectFacade(ProjectRegistryManager manager, IFile pom, MavenProject mavenProject, Map<String, List<MojoExecution>> executionPlans, ResolverConfiguration resolverConfiguration) {
        this.manager = manager;
        this.pom = pom;
        IPath location = pom.getLocation();
        this.pomFile = location == null ? null : location.toFile();
        this.resolverConfiguration = resolverConfiguration;
        this.mavenProject = mavenProject;
        this.executionPlans = executionPlans;
        this.artifactKey = new ArtifactKey(mavenProject.getArtifact());
        this.packaging = mavenProject.getPackaging();
        this.modules = mavenProject.getModules();
        this.resourceLocations = MavenProjectUtils.getResourceLocations(this.getProject(), mavenProject.getResources());
        this.testResourceLocations = MavenProjectUtils.getResourceLocations(this.getProject(), mavenProject.getTestResources());
        this.compileSourceLocations = MavenProjectUtils.getSourceLocations(this.getProject(), mavenProject.getCompileSourceRoots());
        this.testCompileSourceLocations = MavenProjectUtils.getSourceLocations(this.getProject(), mavenProject.getTestCompileSourceRoots());
        IPath fullPath = this.getProject().getFullPath();
        IPath path = this.getProjectRelativePath(mavenProject.getBuild().getOutputDirectory());
        this.outputLocation = path != null ? fullPath.append(path) : null;
        path = this.getProjectRelativePath(mavenProject.getBuild().getTestOutputDirectory());
        this.testOutputLocation = path != null ? fullPath.append(path) : null;
        this.artifactRepositories = new LinkedHashSet<ArtifactRepositoryRef>();
        for (ArtifactRepository repository : mavenProject.getRemoteArtifactRepositories()) {
            this.artifactRepositories.add(new ArtifactRepositoryRef(repository));
        }
        this.pluginArtifactRepositories = new LinkedHashSet<ArtifactRepositoryRef>();
        for (ArtifactRepository repository : mavenProject.getPluginArtifactRepositories()) {
            this.pluginArtifactRepositories.add(new ArtifactRepositoryRef(repository));
        }
        this.setMavenProjectArtifacts();
        this.updateTimestamp();
    }

    public MavenProjectFacade(MavenProjectFacade other) {
        this(other.manager, other.pom, other.mavenProject, other.executionPlans, other.resolverConfiguration);
    }

    @Override
    public IPath[] getResourceLocations() {
        return this.resourceLocations;
    }

    @Override
    public IPath[] getTestResourceLocations() {
        return this.testResourceLocations;
    }

    @Override
    public IPath[] getCompileSourceLocations() {
        return this.compileSourceLocations;
    }

    @Override
    public IPath[] getTestCompileSourceLocations() {
        return this.testCompileSourceLocations;
    }

    @Override
    public IPath getProjectRelativePath(String resourceLocation) {
        return MavenProjectUtils.getProjectRelativePath(this.getProject(), resourceLocation);
    }

    @Override
    public IPath getOutputLocation() {
        return this.outputLocation;
    }

    @Override
    public IPath getTestOutputLocation() {
        return this.testOutputLocation;
    }

    @Override
    public IPath getFullPath() {
        return this.getProject().getFullPath();
    }

    @Override
    public synchronized MavenProject getMavenProject(IProgressMonitor monitor) throws CoreException {
        if (this.mavenProject == null) {
            MavenExecutionResult result = this.manager.readProjectWithDependencies(this.pom, this.resolverConfiguration, monitor);
            this.mavenProject = result.getProject();
            if (this.mavenProject == null) {
                MultiStatus status = new MultiStatus("org.eclipse.m2e.core", 0, Messages.MavenProjectFacade_error, null);
                List exceptions = result.getExceptions();
                for (Throwable e : exceptions) {
                    status.add((IStatus)new Status(4, "org.eclipse.m2e.core", 0, e.getMessage(), e));
                }
                throw new CoreException((IStatus)status);
            }
        }
        return this.mavenProject;
    }

    @Override
    public String getPackaging() {
        return this.packaging;
    }

    @Override
    public IProject getProject() {
        return this.pom.getProject();
    }

    @Override
    public IFile getPom() {
        return this.pom;
    }

    @Override
    public File getPomFile() {
        return this.pomFile;
    }

    @Override
    public IPath getFullPath(File file) {
        return MavenProjectUtils.getFullPath(this.getProject(), file);
    }

    @Override
    public List<String> getMavenProjectModules() {
        return this.modules;
    }

    @Override
    public Set<ArtifactRef> getMavenProjectArtifacts() {
        return this.artifacts;
    }

    void setMavenProjectArtifacts() {
        this.artifacts = ArtifactRef.fromArtifact(this.mavenProject.getArtifacts());
    }

    @Override
    public ResolverConfiguration getResolverConfiguration() {
        return this.resolverConfiguration;
    }

    @Override
    public boolean isStale() {
        IProject project = this.getProject();
        int i = 0;
        for (IPath iPath : ProjectRegistryManager.METADATA_PATH) {
            if (this.timestamp[i] != MavenProjectFacade.getModificationStamp(project.getFile(iPath))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void updateTimestamp() {
        IProject project = this.getProject();
        int i = 0;
        for (IPath iPath : ProjectRegistryManager.METADATA_PATH) {
            this.timestamp[i] = MavenProjectFacade.getModificationStamp(project.getFile(iPath));
            ++i;
        }
        this.timestamp[this.timestamp.length - 1] = MavenProjectFacade.getModificationStamp(this.pom);
    }

    private static long getModificationStamp(IFile file) {
        return file.getLocalTimeStamp() + file.getModificationStamp();
    }

    @Override
    public ArtifactKey getArtifactKey() {
        return this.artifactKey;
    }

    @Override
    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    @Override
    public synchronized void setSessionProperty(String key, Object value) {
        if (this.sessionProperties == null) {
            this.sessionProperties = new HashMap<String, Object>();
        }
        if (value != null) {
            this.sessionProperties.put(key, value);
        } else {
            this.sessionProperties.remove(key);
        }
    }

    @Override
    public synchronized Object getSessionProperty(String key) {
        return this.sessionProperties != null ? this.sessionProperties.get(key) : null;
    }

    @Override
    public Set<ArtifactRepositoryRef> getArtifactRepositoryRefs() {
        return this.artifactRepositories;
    }

    @Override
    public Set<ArtifactRepositoryRef> getPluginArtifactRepositoryRefs() {
        return this.pluginArtifactRepositories;
    }

    public String toString() {
        if (this.mavenProject == null) {
            return "Maven Project: null";
        }
        return this.mavenProject.toString();
    }

    @Override
    public String getLifecycleMappingId() {
        return this.lifecycleMappingId;
    }

    @Override
    public Map<MojoExecutionKey, List<IPluginExecutionMetadata>> getMojoExecutionMapping() {
        return this.mojoExecutionMapping;
    }

    @Override
    public synchronized MojoExecution getMojoExecution(MojoExecutionKey mojoExecutionKey, IProgressMonitor monitor) throws CoreException {
        MojoExecution execution;
        MojoExecution mojoExecution = execution = this.setupMojoExecutions != null ? this.setupMojoExecutions.get(mojoExecutionKey) : null;
        if (execution == null) {
            for (MojoExecution _execution : this.getMojoExecutions(monitor)) {
                if (!mojoExecutionKey.match(_execution)) continue;
                execution = this.manager.setupMojoExecution(this, _execution, monitor);
                break;
            }
            this.putSetupMojoExecution(mojoExecutionKey, execution);
        }
        return execution;
    }

    private void putSetupMojoExecution(MojoExecutionKey mojoExecutionKey, MojoExecution execution) {
        if (execution != null) {
            if (this.setupMojoExecutions == null) {
                this.setupMojoExecutions = new HashMap<MojoExecutionKey, MojoExecution>();
            }
            this.setupMojoExecutions.put(mojoExecutionKey, execution);
        }
    }

    @Override
    public synchronized List<MojoExecution> getMojoExecutions(String groupId, String artifactId, IProgressMonitor monitor, String ... goals) throws CoreException {
        ArrayList<MojoExecution> result = new ArrayList<MojoExecution>();
        List<MojoExecution> _executions = this.getMojoExecutions(monitor);
        if (_executions != null) {
            for (MojoExecution _execution : _executions) {
                MojoExecution execution;
                if (!groupId.equals(_execution.getGroupId()) || !artifactId.equals(_execution.getArtifactId()) || !MavenProjectFacade.contains(goals, _execution.getGoal())) continue;
                MojoExecutionKey _key = new MojoExecutionKey(_execution);
                MojoExecution mojoExecution = execution = this.setupMojoExecutions != null ? this.setupMojoExecutions.get(_key) : null;
                if (execution == null) {
                    execution = this.manager.setupMojoExecution(this, _execution, monitor);
                    this.putSetupMojoExecution(_key, execution);
                }
                result.add(execution);
            }
        }
        return result;
    }

    private static boolean contains(String[] goals, String goal) {
        int i = 0;
        while (i < goals.length) {
            if (goals[i].equals(goal)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setLifecycleMappingId(String lifecycleMappingId) {
        this.lifecycleMappingId = lifecycleMappingId;
    }

    public void setMojoExecutionMapping(Map<MojoExecutionKey, List<IPluginExecutionMetadata>> mojoExecutionMapping) {
        this.mojoExecutionMapping = mojoExecutionMapping;
    }

    public List<MojoExecution> getMojoExecutions() {
        try {
            return this.getMojoExecutions(null);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public List<MojoExecution> getMojoExecutions(IProgressMonitor monitor) throws CoreException {
        Map<String, List<MojoExecution>> executionPlans = this.getExecutionPlans(monitor);
        if (executionPlans == null) {
            return null;
        }
        ArrayList<MojoExecution> mojoExecutions = new ArrayList<MojoExecution>();
        for (List<MojoExecution> executionPlan : executionPlans.values()) {
            if (executionPlan == null) continue;
            mojoExecutions.addAll(executionPlan);
        }
        return mojoExecutions;
    }

    public List<MojoExecution> getExecutionPlan(String lifecycle, IProgressMonitor monitor) throws CoreException {
        Map<String, List<MojoExecution>> executionPlans = this.getExecutionPlans(monitor);
        return executionPlans != null ? executionPlans.get(lifecycle) : null;
    }

    private synchronized Map<String, List<MojoExecution>> getExecutionPlans(IProgressMonitor monitor) throws CoreException {
        if (this.executionPlans == null) {
            if (monitor == null) {
                return null;
            }
            this.executionPlans = this.manager.calculateExecutionPlans(this, monitor);
        }
        return this.executionPlans;
    }
}

