/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiableCollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.SecondaryTable;
import org.eclipse.jpt.jpa.core.context.SpecifiedSecondaryTable;
import org.eclipse.jpt.jpa.ui.details.JptJpaUiDetailsMessages;
import org.eclipse.jpt.jpa.ui.internal.details.SecondaryTableDialog;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSecondaryTablesComposite<T extends Entity>
extends Pane<T> {
    public AbstractSecondaryTablesComposite(Pane<? extends T> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    protected SpecifiedSecondaryTable addSecondaryTableFromDialog(SecondaryTableDialog dialog) {
        if (dialog.open() != 0) {
            return null;
        }
        SpecifiedSecondaryTable secondaryTable = ((Entity)this.getSubject()).addSpecifiedSecondaryTable();
        secondaryTable.setSpecifiedName(dialog.getSelectedTable());
        secondaryTable.setSpecifiedCatalog(dialog.getSelectedCatalog());
        secondaryTable.setSpecifiedSchema(dialog.getSelectedSchema());
        return secondaryTable;
    }

    protected ModifiableCollectionValueModel<SpecifiedSecondaryTable> buildSelectedSecondaryTablesModel() {
        return new SimpleCollectionValueModel();
    }

    protected PropertyValueModel<SpecifiedSecondaryTable> buildSelectedSecondaryTableModel(CollectionValueModel<SpecifiedSecondaryTable> selectedSecondaryTablesModel) {
        return new CollectionPropertyValueModelAdapter<SpecifiedSecondaryTable, SpecifiedSecondaryTable>(selectedSecondaryTablesModel){

            protected SpecifiedSecondaryTable buildValue() {
                if (this.collectionModel.size() == 1) {
                    return (SpecifiedSecondaryTable)this.collectionModel.iterator().next();
                }
                return null;
            }
        };
    }

    protected ILabelProvider buildSecondaryTableLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                SecondaryTable secondaryTable = (SecondaryTable)element;
                if (secondaryTable.getName() != null) {
                    return secondaryTable.getName();
                }
                return "";
            }
        };
    }

    protected SecondaryTableDialog buildSecondaryTableDialogForAdd() {
        return new SecondaryTableDialog(this.getShell(), ((Entity)this.getSubject()).getJpaProject(), ((Entity)this.getSubject()).getTable().getDefaultCatalog(), ((Entity)this.getSubject()).getTable().getDefaultSchema());
    }

    protected AddRemovePane.Adapter<SpecifiedSecondaryTable> buildSecondaryTablesAdapter() {
        return new AddRemovePane.AbstractAdapter<SpecifiedSecondaryTable>(){

            public SpecifiedSecondaryTable addNewItem() {
                SecondaryTableDialog dialog = AbstractSecondaryTablesComposite.this.buildSecondaryTableDialogForAdd();
                return AbstractSecondaryTablesComposite.this.addSecondaryTableFromDialog(dialog);
            }

            public boolean hasOptionalButton() {
                return true;
            }

            public String optionalButtonText() {
                return JptJpaUiDetailsMessages.SecondaryTablesComposite_edit;
            }

            public void optionOnSelection(CollectionValueModel<SpecifiedSecondaryTable> selectedItemsModel) {
                SpecifiedSecondaryTable secondaryTable = (SpecifiedSecondaryTable)selectedItemsModel.iterator().next();
                SecondaryTableDialog dialog = new SecondaryTableDialog(AbstractSecondaryTablesComposite.this.getShell(), ((Entity)AbstractSecondaryTablesComposite.this.getSubject()).getJpaProject(), secondaryTable);
                AbstractSecondaryTablesComposite.this.editSecondaryTableFromDialog(dialog, secondaryTable);
            }

            public void removeSelectedItems(CollectionValueModel<SpecifiedSecondaryTable> selectedItemsModel) {
                SpecifiedSecondaryTable secondaryTable = (SpecifiedSecondaryTable)selectedItemsModel.iterator().next();
                ((Entity)AbstractSecondaryTablesComposite.this.getSubject()).removeSpecifiedSecondaryTable(secondaryTable);
            }

            public PropertyValueModel<Boolean> buildRemoveButtonEnabledModel(CollectionValueModel<SpecifiedSecondaryTable> selectedItemsModel) {
                return this.buildOptionalButtonEnabledModel(selectedItemsModel);
            }

            public PropertyValueModel<Boolean> buildOptionalButtonEnabledModel(CollectionValueModel<SpecifiedSecondaryTable> selectedItemsModel) {
                return new CollectionPropertyValueModelAdapter<Boolean, SpecifiedSecondaryTable>(selectedItemsModel){

                    protected Boolean buildValue() {
                        if (this.collectionModel.size() == 1) {
                            SpecifiedSecondaryTable secondaryTable = (SpecifiedSecondaryTable)this.collectionModel.iterator().next();
                            return !secondaryTable.isVirtual();
                        }
                        return Boolean.FALSE;
                    }
                };
            }
        };
    }

    protected void editSecondaryTableFromDialog(SecondaryTableDialog dialog, SpecifiedSecondaryTable secondaryTable) {
        if (dialog.open() != 0) {
            return;
        }
        secondaryTable.setSpecifiedName(dialog.getSelectedTable());
        secondaryTable.setSpecifiedCatalog(dialog.getSelectedCatalog());
        secondaryTable.setSpecifiedSchema(dialog.getSelectedSchema());
    }
}

