/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.common.ui.WidgetFactory;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.BaseTemporalConverter;
import org.eclipse.jpt.jpa.core.context.Converter;
import org.eclipse.jpt.jpa.core.context.SpecifiedAccessReference;
import org.eclipse.jpt.jpa.core.context.SpecifiedColumn;
import org.eclipse.jpt.jpa.core.context.VersionMapping;
import org.eclipse.jpt.jpa.ui.details.JpaComposite;
import org.eclipse.jpt.jpa.ui.details.JptJpaUiDetailsMessages;
import org.eclipse.jpt.jpa.ui.internal.details.TemporalTypeCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVersionMappingComposite<T extends VersionMapping>
extends Pane<T>
implements JpaComposite {
    protected AbstractVersionMappingComposite(PropertyValueModel<? extends T> mappingModel, PropertyValueModel<Boolean> enabledModel, Composite parentComposite, WidgetFactory widgetFactory, ResourceManager resourceManager) {
        super(mappingModel, enabledModel, parentComposite, widgetFactory, resourceManager);
    }

    protected void initializeLayout(Composite container) {
        this.initializeVersionCollapsibleSection(container);
        this.initializeTypeCollapsibleSection(container);
    }

    protected void initializeVersionCollapsibleSection(Composite container) {
        Section section = this.getWidgetFactory().createSection(container, 322);
        section.setLayoutData((Object)new GridData(768));
        section.setText(JptJpaUiDetailsMessages.VersionSection_title);
        section.setClient(this.initializeVersionSection((Composite)section));
    }

    protected abstract Control initializeVersionSection(Composite var1);

    protected void initializeTypeCollapsibleSection(Composite container) {
        final Section section = this.getWidgetFactory().createSection(container, 258);
        section.setLayoutData((Object)new GridData(768));
        section.setText(JptJpaUiDetailsMessages.TypeSection_type);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanging(ExpansionEvent e) {
                if (e.getState() && section.getClient() == null) {
                    section.setClient(AbstractVersionMappingComposite.this.initializeTypeSection((Composite)section));
                }
            }
        });
    }

    protected Control initializeTypeSection(Composite container) {
        container = this.addSubPane(container, 2, 0, 0, 0, 0);
        Button noConverterButton = this.addRadioButton(container, JptJpaUiDetailsMessages.TypeSection_default, this.buildConverterBooleanHolder(null), null);
        ((GridData)noConverterButton.getLayoutData()).horizontalSpan = 2;
        PropertyValueModel<Converter> converterHolder = this.buildConverterHolder();
        this.addRadioButton(container, JptJpaUiDetailsMessages.TypeSection_temporal, this.buildConverterBooleanHolder(BaseTemporalConverter.class), null);
        new TemporalTypeCombo(this, this.buildTemporalConverterHolder(converterHolder), container);
        return container;
    }

    protected PropertyValueModel<SpecifiedColumn> buildColumnModel() {
        return new TransformationPropertyValueModel<T, SpecifiedColumn>(this.getSubjectHolder()){

            protected SpecifiedColumn transform_(T value) {
                return value.getColumn();
            }
        };
    }

    protected ModifiablePropertyValueModel<Boolean> buildConverterBooleanHolder(final Class<? extends Converter> converterType) {
        return new PropertyAspectAdapter<T, Boolean>(this.getSubjectHolder(), new String[]{"converter"}){

            protected Boolean buildValue_() {
                Converter converter = ((VersionMapping)this.subject).getConverter();
                return converter.getType() == converterType;
            }

            protected void setValue_(Boolean value) {
                if (value.booleanValue()) {
                    ((VersionMapping)this.subject).setConverter(converterType);
                }
            }
        };
    }

    private PropertyValueModel<Converter> buildConverterHolder() {
        return new PropertyAspectAdapter<VersionMapping, Converter>(this.getSubjectHolder(), new String[]{"converter"}){

            protected Converter buildValue_() {
                return ((VersionMapping)this.subject).getConverter();
            }
        };
    }

    private PropertyValueModel<BaseTemporalConverter> buildTemporalConverterHolder(PropertyValueModel<Converter> converterHolder) {
        return new TransformationPropertyValueModel<Converter, BaseTemporalConverter>(converterHolder){

            protected BaseTemporalConverter transform_(Converter converter) {
                return converter.getType() == BaseTemporalConverter.class ? (BaseTemporalConverter)converter : null;
            }
        };
    }

    protected PropertyValueModel<SpecifiedAccessReference> buildAccessReferenceModel() {
        return new PropertyAspectAdapter<T, SpecifiedAccessReference>(this.getSubjectHolder()){

            protected SpecifiedAccessReference buildValue_() {
                return ((VersionMapping)this.subject).getPersistentAttribute();
            }
        };
    }
}

