/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import java.util.HashMap;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.common.ui.WidgetFactory;
import org.eclipse.jpt.common.ui.internal.swt.bind.SWTBindTools;
import org.eclipse.jpt.common.utility.internal.model.value.FilteringPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.predicate.CriterionPredicate;
import org.eclipse.jpt.common.utility.internal.transformer.AbstractTransformer;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.ui.JpaPlatformUi;
import org.eclipse.jpt.jpa.ui.details.JpaComposite;
import org.eclipse.jpt.jpa.ui.internal.details.AbstractJpaDetailsPageManager;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.PageBook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistentAttributeDetailsPageManager<A extends PersistentAttribute>
extends AbstractJpaDetailsPageManager<A> {
    private final HashMap<String, JpaComposite> mappingComposites = new HashMap();
    private PageBook mappingPageBook;
    private PropertyValueModel<AttributeMapping> mappingHolder;
    private static final String TRACE_OPTION = PersistentAttributeDetailsPageManager.class.getSimpleName();

    protected PersistentAttributeDetailsPageManager(Composite parent, WidgetFactory widgetFactory, ResourceManager resourceManager) {
        super(parent, widgetFactory, resourceManager);
    }

    protected void initialize() {
        super.initialize();
    }

    protected void initializeLayout(Composite container) {
        this.mappingPageBook = this.buildMappingPageBook(container);
    }

    private PageBook buildMappingPageBook(Composite parent) {
        PageBook book = new PageBook(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        gridData.verticalIndent = 5;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        book.setLayoutData((Object)gridData);
        this.mappingHolder = this.buildMappingHolder();
        SWTBindTools.bind(this.mappingHolder, this.buildPaneTransformer(), (PageBook)book);
        return book;
    }

    private Transformer<AttributeMapping, Control> buildPaneTransformer() {
        return new PaneTransformer();
    }

    protected JpaComposite getMappingComposite(String key) {
        JpaComposite composite = this.mappingComposites.get(key);
        if (composite == null && (composite = this.buildMappingComposite(this.mappingPageBook, key)) != null) {
            this.mappingComposites.put(key, composite);
        }
        return composite;
    }

    protected JpaComposite buildMappingComposite(PageBook pageBook, String key) {
        JpaPlatformUi ui = this.getJpaPlatformUi();
        return ui == null ? null : ui.buildAttributeMappingComposite(((PersistentAttribute)this.getSubject()).getResourceType(), key, (Composite)pageBook, this.buildMappingHolder(key), this.getMappingCompositeEnabledModel(), this.getWidgetFactory(), this.getResourceManager());
    }

    protected abstract PropertyValueModel<Boolean> getMappingCompositeEnabledModel();

    private PropertyValueModel<AttributeMapping> buildMappingHolder(String key) {
        return new FilteringPropertyValueModel(this.mappingHolder, this.buildKeyEquals(key));
    }

    private Predicate<AttributeMapping> buildKeyEquals(String mappingKey) {
        return new KeyEquals(mappingKey);
    }

    private ModifiablePropertyValueModel<AttributeMapping> buildMappingHolder() {
        return new PropertyAspectAdapter<A, AttributeMapping>(this.getSubjectHolder(), new String[]{"mapping"}){

            protected AttributeMapping buildValue_() {
                return ((PersistentAttribute)this.subject).getMapping();
            }
        };
    }

    @Override
    public void controlDisposed() {
        JptJpaUiPlugin.instance().trace(TRACE_OPTION, "dispose");
        this.mappingComposites.clear();
        super.controlDisposed();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyEquals
    extends CriterionPredicate<AttributeMapping, String> {
        KeyEquals(String mappingKey) {
            super((Object)mappingKey);
        }

        public boolean evaluate(AttributeMapping mapping) {
            return mapping == null || this.criterion == null || ((String)this.criterion).equals(mapping.getKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PaneTransformer
    extends AbstractTransformer<AttributeMapping, Control> {
        protected PaneTransformer() {
        }

        public Control transform_(AttributeMapping attributeMapping) {
            return PersistentAttributeDetailsPageManager.this.getMappingComposite(attributeMapping.getKey()).getControl();
        }
    }
}

