/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.platform.generic;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jpt.common.ui.internal.jface.StaticItemExtendedLabelProvider;
import org.eclipse.jpt.common.ui.jface.ItemExtendedLabelProvider;
import org.eclipse.jpt.jpa.core.JpaModel;
import org.eclipse.jpt.jpa.core.context.ManagedType;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.java.JarFile;
import org.eclipse.jpt.jpa.core.context.orm.OrmXml;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.ui.JptJpaUiImages;
import org.eclipse.jpt.jpa.ui.internal.platform.generic.ManagedTypeItemLabelProvider;
import org.eclipse.jpt.jpa.ui.internal.platform.generic.PersistenceUnitItemLabelProvider;
import org.eclipse.jpt.jpa.ui.internal.platform.generic.PersistentAttributeItemLabelProvider;
import org.eclipse.jpt.jpa.ui.internal.platform.generic.PersistentTypeItemLabelProvider;

public class GenericNavigatorItemLabelProviderFactory
implements ItemExtendedLabelProvider.Factory {
    private static final ItemExtendedLabelProvider.Factory INSTANCE = new GenericNavigatorItemLabelProviderFactory();

    public static ItemExtendedLabelProvider.Factory instance() {
        return INSTANCE;
    }

    protected GenericNavigatorItemLabelProviderFactory() {
    }

    public ItemExtendedLabelProvider buildProvider(Object item, ItemExtendedLabelProvider.Manager manager) {
        if (item instanceof PersistenceXml) {
            return this.buildPersistenceXmlProvider((PersistenceXml)item, manager);
        }
        if (item instanceof PersistenceUnit) {
            return this.buildPersistenceUnitProvider((PersistenceUnit)item, manager);
        }
        if (item instanceof OrmXml) {
            return this.buildOrmXmlProvider((OrmXml)item, manager);
        }
        if (item instanceof PersistentType) {
            return this.buildPersistentTypeProvider((PersistentType)item, manager);
        }
        if (item instanceof ManagedType) {
            return this.buildManagedTypeProvider((ManagedType)item, manager);
        }
        if (item instanceof PersistentAttribute) {
            return this.buildPersistentAttributeProvider((PersistentAttribute)item, manager);
        }
        if (item instanceof JarFile) {
            return this.buildJarFileProvider((JarFile)item, manager);
        }
        return null;
    }

    protected ItemExtendedLabelProvider buildPersistenceXmlProvider(PersistenceXml item, ItemExtendedLabelProvider.Manager manager) {
        return this.buildResourceItemLabelProvider((JpaModel)item, manager);
    }

    protected ItemExtendedLabelProvider buildPersistenceUnitProvider(PersistenceUnit item, ItemExtendedLabelProvider.Manager manager) {
        return new PersistenceUnitItemLabelProvider(item, manager);
    }

    protected ItemExtendedLabelProvider buildOrmXmlProvider(OrmXml item, ItemExtendedLabelProvider.Manager manager) {
        return this.buildResourceItemLabelProvider((JpaModel)item, manager);
    }

    protected ItemExtendedLabelProvider buildPersistentTypeProvider(PersistentType item, ItemExtendedLabelProvider.Manager manager) {
        return new PersistentTypeItemLabelProvider(item, manager);
    }

    protected ItemExtendedLabelProvider buildManagedTypeProvider(ManagedType item, ItemExtendedLabelProvider.Manager manager) {
        return new ManagedTypeItemLabelProvider(item, manager);
    }

    protected ItemExtendedLabelProvider buildPersistentAttributeProvider(PersistentAttribute item, ItemExtendedLabelProvider.Manager manager) {
        return new PersistentAttributeItemLabelProvider(item, manager);
    }

    protected ItemExtendedLabelProvider buildJarFileProvider(JarFile item, ItemExtendedLabelProvider.Manager manager) {
        return this.buildResourceItemLabelProvider((JpaModel)item, JptJpaUiImages.JAR_FILE, manager);
    }

    protected ItemExtendedLabelProvider buildResourceItemLabelProvider(JpaModel node, ItemExtendedLabelProvider.Manager manager) {
        return this.buildResourceItemLabelProvider(node.getResource(), manager);
    }

    protected ItemExtendedLabelProvider buildResourceItemLabelProvider(JpaModel node, ImageDescriptor imageDescriptor, ItemExtendedLabelProvider.Manager manager) {
        return this.buildResourceItemLabelProvider(node.getResource(), imageDescriptor, manager);
    }

    protected ItemExtendedLabelProvider buildResourceItemLabelProvider(IResource resource, ItemExtendedLabelProvider.Manager manager) {
        return this.buildResourceItemLabelProvider(resource, JptJpaUiImages.JPA_FILE, manager);
    }

    protected ItemExtendedLabelProvider buildResourceItemLabelProvider(IResource resource, ImageDescriptor imageDescriptor, ItemExtendedLabelProvider.Manager manager) {
        return new StaticItemExtendedLabelProvider(imageDescriptor, resource.getName(), this.buildResourceDescription(resource), manager);
    }

    protected String buildResourceDescription(IResource resource) {
        StringBuilder sb = new StringBuilder();
        sb.append(resource.getName());
        sb.append(" - ");
        sb.append(resource.getParent().getFullPath().makeRelative());
        return sb.toString();
    }
}

