/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.gen;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Button;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionEndpointLocator;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.jpa.gen.internal.Association;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.TableFigure;
import org.eclipse.jpt.jpa.ui.wizards.gen.JptJpaUiWizardsEntityGenMessages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

class AssociationFigure
extends Button {
    Color enabledColor = new Color(null, 14, 66, 115);
    Color disabledLineColor = new Color(null, 192, 215, 231);
    Color selectedColor = new Color(null, 232, 232, 232);
    Color selectedBorderColor = new Color(null, 14, 66, 115);
    LineBorder selectedBorder = new LineBorder(this.selectedBorderColor, 2);
    LineBorder unselectedBorder = new LineBorder(ColorConstants.lightGray, 1);
    Font descriptionFont = new Font(null, "Arial", 8, 0);
    Association association;
    TableFigure tableFig1;
    TableFigure tableFig2;
    PolylineConnection connection;
    PolygonDecoration referrerDecoration;
    PolygonDecoration referencedDecoration;
    Label referencedLabel;
    Label referrerLabel;
    Label descriptionLabel;

    AssociationFigure(Association association, ResourceManager resourceManager) {
        this.association = association;
        XYLayout contentsLayout = new XYLayout();
        this.setLayoutManager((LayoutManager)contentsLayout);
        this.setBorder((Border)this.unselectedBorder);
        this.tableFig1 = new TableFigure(association.getReferrerTable().getName(), resourceManager);
        this.tableFig2 = new TableFigure(association.getReferencedTable().getName(), resourceManager);
        contentsLayout.setConstraint((IFigure)this.tableFig1, (Object)new Rectangle(10, 10, 150, 20));
        contentsLayout.setConstraint((IFigure)this.tableFig2, (Object)new Rectangle(280, 10, 150, 20));
        this.connection = this.drawConnection(this.tableFig1, this.tableFig2);
        this.add((IFigure)this.tableFig1);
        this.add((IFigure)this.tableFig2);
        this.add((IFigure)this.connection);
        this.descriptionLabel = new Label("");
        contentsLayout.setConstraint((IFigure)this.descriptionLabel, (Object)new Rectangle(10, 30, -1, -1));
        this.descriptionLabel.setFont(this.descriptionFont);
        this.add((IFigure)this.descriptionLabel);
        this.setBackgroundColor(ColorConstants.white);
        this.update();
    }

    private PolylineConnection drawConnection(TableFigure tableFig1, TableFigure tableFig2) {
        PolylineConnection connection = new PolylineConnection();
        ChopboxAnchor sourceAnchor = new ChopboxAnchor((IFigure)tableFig1);
        ChopboxAnchor targetAnchor = new ChopboxAnchor((IFigure)tableFig2);
        connection.setSourceAnchor((ConnectionAnchor)sourceAnchor);
        connection.setTargetAnchor((ConnectionAnchor)targetAnchor);
        this.referrerDecoration = new SmoothPolygonDecoration();
        connection.setSourceDecoration((RotatableDecoration)this.referrerDecoration);
        this.referencedDecoration = new SmoothPolygonDecoration();
        connection.setTargetDecoration((RotatableDecoration)this.referencedDecoration);
        ConnectionEndpointLocator sourceEndpointLocator = new ConnectionEndpointLocator((Connection)connection, false);
        sourceEndpointLocator.setVDistance(-5);
        this.referrerLabel = new Label("");
        connection.add((IFigure)this.referrerLabel, (Object)sourceEndpointLocator);
        ConnectionEndpointLocator targetEndpointLocator = new ConnectionEndpointLocator((Connection)connection, true);
        targetEndpointLocator.setVDistance(-5);
        this.referencedLabel = new Label("");
        connection.add((IFigure)this.referencedLabel, (Object)targetEndpointLocator);
        ConnectionEndpointLocator relationshipLocator = new ConnectionEndpointLocator((Connection)connection, true);
        relationshipLocator.setUDistance(10);
        relationshipLocator.setVDistance(-20);
        Label relationshipLabel = new Label("contains");
        connection.add((IFigure)relationshipLabel, (Object)relationshipLocator);
        return connection;
    }

    public Association getAssociation() {
        return this.association;
    }

    public void setSelected(boolean isSelected) {
        this.setBackgroundColor(isSelected ? this.selectedColor : ColorConstants.white);
        this.setBorder((Border)(isSelected ? this.selectedBorder : this.unselectedBorder));
    }

    public void update() {
        boolean isGenerated = this.association.isGenerated();
        this.connection.setForegroundColor(isGenerated ? this.enabledColor : this.disabledLineColor);
        this.tableFig1.setEnabled(isGenerated);
        this.tableFig2.setEnabled(isGenerated);
        this.descriptionLabel.setForegroundColor(isGenerated ? this.enabledColor : this.disabledLineColor);
        String directionality = this.association.getDirectionality();
        String cardinality = this.association.getCardinality();
        String cardinalityStr = cardinality.equals("many-to-one") || cardinality.equals("many-to-many") ? "*" : "1";
        if (directionality.equals("bi-di") || directionality.equals("opposite-di")) {
            this.connection.setSourceDecoration((RotatableDecoration)this.referrerDecoration);
        } else {
            this.connection.setSourceDecoration(null);
        }
        this.referrerLabel.setText(cardinalityStr);
        cardinalityStr = cardinality.equals("many-to-one") || cardinality.equals("one-to-one") ? "1" : "*";
        if (directionality.equals("bi-di") || directionality.equals("normal-di")) {
            this.connection.setTargetDecoration((RotatableDecoration)this.referencedDecoration);
        } else {
            this.connection.setTargetDecoration(null);
        }
        this.referencedLabel.setText(cardinalityStr);
        String text = "";
        String referrerTableName = this.association.getReferrerTableName();
        String referencedTable = this.association.getReferencedTableName();
        if (cardinality.equals("many-to-one")) {
            text = String.format(JptJpaUiWizardsEntityGenMessages.manyToOneDesc, referencedTable, referrerTableName);
        } else if (cardinality.equals("one-to-one")) {
            text = String.format(JptJpaUiWizardsEntityGenMessages.oneToOneDesc, referrerTableName, referencedTable);
        } else if (cardinality.equals("many-to-many")) {
            text = String.format(JptJpaUiWizardsEntityGenMessages.manyToManyDesc, referrerTableName, referencedTable, referencedTable, referrerTableName);
        }
        if (this.association.isCustom()) {
            this.connection.setLineStyle(3);
        }
        this.descriptionLabel.setText(text);
    }

    public void dispose() {
        this.descriptionFont.dispose();
        this.selectedBorderColor.dispose();
        this.selectedColor.dispose();
        this.disabledLineColor.dispose();
        this.enabledColor.dispose();
        this.tableFig1.dispose();
        this.tableFig2.dispose();
    }

    public class SmoothPolygonDecoration
    extends PolygonDecoration {
        public void paintFigure(Graphics graphics) {
            int savedAntialias = graphics.getAntialias();
            graphics.setAntialias(1);
            super.paintFigure(graphics);
            graphics.setAntialias(savedAntialias);
        }
    }
}

