/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.gen;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jpt.jpa.gen.internal.ORMGenColumn;
import org.eclipse.jpt.jpa.gen.internal.ORMGenCustomizer;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.SWTUtil;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.TablesAndColumnsCustomizationWizardPage;
import org.eclipse.jpt.jpa.ui.wizards.gen.JptJpaUiWizardsEntityGenMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ColumnGenPanel {
    TablesAndColumnsCustomizationWizardPage wizardPage;
    Composite parent;
    int columns;
    ORMGenCustomizer customizer;
    private ORMGenColumn mColumn;
    private boolean mPanelInited;
    private boolean mIsUpdatingControls;
    private Group columnMappingGroup;
    private Button mGeneratedCheckbox;
    private Text mPropNameField;
    private Combo mMappingKindCombo;
    private Combo mPropTypeCombo;
    private Button mUpdateableCheckBox;
    private Button mInsertableCheckBox;
    private Group domainClassGroup;
    private ScopePanel mPropGetScopePanel;
    private ScopePanel mPropSetScopePanel;
    private boolean isDynamic;

    public ColumnGenPanel(Composite parent, int columns, ORMGenCustomizer customizer, TablesAndColumnsCustomizationWizardPage wizardPage, boolean isDynamic) {
        this.wizardPage = wizardPage;
        this.customizer = customizer;
        this.parent = parent;
        this.columns = columns;
        this.isDynamic = isDynamic;
        this.initPanel();
    }

    public void setColumn(ORMGenColumn column) {
        this.mColumn = column;
        if (!this.mPanelInited) {
            this.initPanel();
            this.mPanelInited = true;
        }
        this.updateControls();
    }

    private void updateControls() {
        if (this.mIsUpdatingControls) {
            return;
        }
        this.mIsUpdatingControls = true;
        boolean isGenerated = this.mColumn.isGenerated();
        this.mGeneratedCheckbox.setSelection(isGenerated);
        this.mGeneratedCheckbox.setEnabled(true);
        this.enableControls(isGenerated);
        try {
            try {
                this.mPropNameField.setText(this.mColumn.getPropertyName());
                this.mPropTypeCombo.setText(this.mColumn.getPropertyType());
                this.mMappingKindCombo.setText(this.mColumn.getMappingKind());
                this.mUpdateableCheckBox.setSelection(this.mColumn.isUpdateable());
                this.mInsertableCheckBox.setSelection(this.mColumn.isInsertable());
                if (!this.isDynamic) {
                    this.mPropGetScopePanel.enableComponents(isGenerated);
                    this.mPropGetScopePanel.setScope(this.mColumn.getPropertyGetScope());
                    this.mPropSetScopePanel.enableComponents(isGenerated);
                    this.mPropSetScopePanel.setScope(this.mColumn.getPropertySetScope());
                }
                if (this.mColumn.isPartOfCompositePrimaryKey()) {
                    this.enableControls(false);
                    this.mPropNameField.setEnabled(true);
                    this.mGeneratedCheckbox.setEnabled(false);
                }
            }
            catch (Exception e) {
                JptJpaUiPlugin.instance().logError(e);
                this.mIsUpdatingControls = false;
            }
        }
        finally {
            this.mIsUpdatingControls = false;
        }
    }

    private void enableControls(boolean isGenerated) {
        Control c;
        int n;
        int n2;
        Control[] controlArray;
        Control[] controls;
        if (!this.isDynamic) {
            controlArray = controls = this.domainClassGroup.getChildren();
            n2 = controls.length;
            n = 0;
            while (n < n2) {
                c = controlArray[n];
                c.setEnabled(isGenerated);
                ++n;
            }
        }
        controlArray = controls = this.columnMappingGroup.getChildren();
        n2 = controls.length;
        n = 0;
        while (n < n2) {
            c = controlArray[n];
            c.setEnabled(isGenerated);
            ++n;
        }
    }

    protected void initPanel() {
        this.createControls(this.parent, this.columns);
        this.mPanelInited = true;
    }

    private void createControls(Composite composite, int columns) {
        this.mGeneratedCheckbox = new Button(composite, 32);
        this.mGeneratedCheckbox.setText(JptJpaUiWizardsEntityGenMessages.GenerateEntitiesWizard_colPanel_genProp);
        this.mGeneratedCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!ColumnGenPanel.this.mIsUpdatingControls) {
                    ColumnGenPanel.this.mColumn.setGenerated(ColumnGenPanel.this.mGeneratedCheckbox.getSelection());
                    ColumnGenPanel.this.updateControls();
                }
            }
        });
        SWTUtil.fillColumns((Control)this.mGeneratedCheckbox, columns);
        this.columnMappingGroup = new Group(composite, 0);
        this.columnMappingGroup.setText(JptJpaUiWizardsEntityGenMessages.GenerateEntitiesWizard_colPanel_colMapping);
        this.columnMappingGroup.setLayout((Layout)new GridLayout(columns, false));
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = columns;
        layoutData.verticalAlignment = 4;
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = false;
        layoutData.horizontalIndent = 20;
        this.columnMappingGroup.setLayoutData((Object)layoutData);
        SWTUtil.createLabel((Composite)this.columnMappingGroup, 1, JptJpaUiWizardsEntityGenMessages.GenerateEntitiesWizard_colPanel_propName);
        this.mPropNameField = new Text((Composite)this.columnMappingGroup, 2052);
        this.mPropNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ColumnGenPanel.this.mIsUpdatingControls) {
                    String fldName = ColumnGenPanel.this.mPropNameField.getText();
                    IStatus status = JavaConventions.validateIdentifier((String)fldName, (String)"1.3", (String)"1.3");
                    if (!status.matches(4)) {
                        ColumnGenPanel.this.mColumn.setPropertyName(fldName);
                        ColumnGenPanel.this.wizardPage.setErrorMessage(null);
                    } else {
                        ColumnGenPanel.this.wizardPage.setErrorMessage(status.getMessage());
                    }
                }
            }
        });
        SWTUtil.fillColumns((Control)this.mPropNameField, 3);
        SWTUtil.createLabel((Composite)this.columnMappingGroup, 1, JptJpaUiWizardsEntityGenMessages.GenerateEntitiesWizard_colPanel_propType);
        this.mPropTypeCombo = new Combo((Composite)this.columnMappingGroup, 12);
        this.mPropTypeCombo.setItems(this.customizer.getAllPropertyTypes());
        this.mPropTypeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ColumnGenPanel.this.mIsUpdatingControls) {
                    ColumnGenPanel.this.mColumn.setPropertyType(ColumnGenPanel.this.mPropTypeCombo.getText());
                }
            }
        });
        SWTUtil.fillColumns((Control)this.mPropTypeCombo, 3);
        SWTUtil.createLabel((Composite)this.columnMappingGroup, 1, JptJpaUiWizardsEntityGenMessages.GenerateEntitiesWizard_colPanel_mapKind);
        this.mMappingKindCombo = new Combo((Composite)this.columnMappingGroup, 12);
        this.mMappingKindCombo.setItems(this.customizer.getAllMappingKinds());
        this.mMappingKindCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!ColumnGenPanel.this.mIsUpdatingControls) {
                    ColumnGenPanel.this.mColumn.setMappingKind(ColumnGenPanel.this.mMappingKindCombo.getText());
                }
            }
        });
        SWTUtil.fillColumns((Control)this.mMappingKindCombo, 3);
        this.mUpdateableCheckBox = new Button((Composite)this.columnMappingGroup, 32);
        this.mUpdateableCheckBox.setText(JptJpaUiWizardsEntityGenMessages.GenerateEntitiesWizard_colPanel_colUpdateable);
        this.mUpdateableCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!ColumnGenPanel.this.mIsUpdatingControls) {
                    ColumnGenPanel.this.mColumn.setUpdateable(ColumnGenPanel.this.mUpdateableCheckBox.getSelection());
                }
            }
        });
        SWTUtil.fillColumns((Control)this.mUpdateableCheckBox, 4);
        this.mInsertableCheckBox = new Button((Composite)this.columnMappingGroup, 32);
        this.mInsertableCheckBox.setText(JptJpaUiWizardsEntityGenMessages.GenerateEntitiesWizard_colPanel_colInsertable);
        this.mInsertableCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!ColumnGenPanel.this.mIsUpdatingControls) {
                    ColumnGenPanel.this.mColumn.setInsertable(ColumnGenPanel.this.mInsertableCheckBox.getSelection());
                }
            }
        });
        SWTUtil.fillColumns((Control)this.mInsertableCheckBox, 4);
        SWTUtil.createLabel(composite, 4, "");
        if (!this.wizardPage.isDynamic()) {
            this.createJavaBeanPropertyControls(composite, columns);
        }
    }

    void createJavaBeanPropertyControls(Composite composite, int columns) {
        this.domainClassGroup = new Group(composite, 0);
        this.domainClassGroup.setText(JptJpaUiWizardsEntityGenMessages.GenerateEntitiesWizard_colPanel_beanProp);
        this.domainClassGroup.setLayout((Layout)new GridLayout(columns, false));
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = columns;
        layoutData.verticalAlignment = 4;
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = false;
        layoutData.horizontalIndent = 20;
        this.domainClassGroup.setLayoutData((Object)layoutData);
        SWTUtil.createLabel((Composite)this.domainClassGroup, 1, JptJpaUiWizardsEntityGenMessages.GenerateEntitiesWizard_colPanel_getterScope);
        this.mPropGetScopePanel = new ScopePanel((Composite)this.domainClassGroup, new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!ColumnGenPanel.this.mIsUpdatingControls && ((Button)e.getSource()).getSelection()) {
                    ColumnGenPanel.this.mColumn.setPropertyGetScope(ColumnGenPanel.this.mPropGetScopePanel.getScope());
                }
            }
        });
        SWTUtil.createLabel((Composite)this.domainClassGroup, 1, JptJpaUiWizardsEntityGenMessages.GenerateEntitiesWizard_colPanel_setterScope);
        this.mPropSetScopePanel = new ScopePanel((Composite)this.domainClassGroup, new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!ColumnGenPanel.this.mIsUpdatingControls && ((Button)e.getSource()).getSelection()) {
                    ColumnGenPanel.this.mColumn.setPropertySetScope(ColumnGenPanel.this.mPropSetScopePanel.getScope());
                }
            }
        });
    }

    private class ScopePanel {
        private Button mPublicRadio;
        private Button mProtectedRadio;
        private Button mPrivateRadio;

        public ScopePanel(Composite comp, SelectionListener listener) {
            Composite radioGroup = new Composite(comp, 0);
            radioGroup.setLayout((Layout)new GridLayout(3, true));
            GridData gd = new GridData();
            gd.horizontalSpan = 3;
            radioGroup.setLayoutData((Object)gd);
            this.mPublicRadio = new Button(radioGroup, 16);
            this.mPublicRadio.setText("public");
            this.mPublicRadio.setLayoutData((Object)new GridData());
            this.mProtectedRadio = new Button(radioGroup, 16);
            this.mProtectedRadio.setText("protected");
            this.mProtectedRadio.setLayoutData((Object)new GridData());
            this.mPrivateRadio = new Button(radioGroup, 16);
            this.mPrivateRadio.setText("private");
            this.mPrivateRadio.setLayoutData((Object)new GridData());
            this.mPublicRadio.addSelectionListener(listener);
            this.mProtectedRadio.addSelectionListener(listener);
            this.mPrivateRadio.addSelectionListener(listener);
        }

        public void enableComponents(boolean b) {
            this.mPublicRadio.setEnabled(b);
            this.mProtectedRadio.setEnabled(b);
            this.mPrivateRadio.setEnabled(b);
        }

        public String getScope() {
            Button radio = null;
            if (this.mPublicRadio.getSelection()) {
                radio = this.mPublicRadio;
            } else if (this.mProtectedRadio.getSelection()) {
                radio = this.mProtectedRadio;
            } else if (this.mPrivateRadio.getSelection()) {
                radio = this.mPrivateRadio;
            }
            return radio != null ? radio.getText() : null;
        }

        public void setScope(String scope) {
            this.mPublicRadio.setSelection(false);
            this.mProtectedRadio.setSelection(false);
            this.mPrivateRadio.setSelection(false);
            if (scope == null) {
                return;
            }
            if (scope.equals("public")) {
                this.mPublicRadio.setSelection(true);
            } else if (scope.equals("protected")) {
                this.mProtectedRadio.setSelection(true);
            } else if (scope.equals("private")) {
                this.mPrivateRadio.setSelection(true);
            }
        }
    }
}

