/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.jpa.annotate.mapping.AnnotationAttrConverter;
import org.eclipse.jpt.jpa.annotate.mapping.BasicEntityPropertyElem;
import org.eclipse.jpt.jpa.annotate.mapping.EntityPropertyElem;
import org.eclipse.jpt.jpa.annotate.util.AnnotateMappingUtil;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.AssociationAnnotationWizard;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.DbColumnAnnotationCtl;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.JptJpaUiMakePersistentMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BasicAnnotationDialog
extends Dialog {
    private ResourceManager resourceManager;
    private IProject project;
    private Table table;
    private EntityPropertyElem entityProp;
    private DbColumnAnnotationCtl columnGroupCtl;
    private Text propNameText;
    private Text propTypeText;
    private Combo temporalCombo;

    public BasicAnnotationDialog(Shell parentShell, ResourceManager resourceManager, IProject project, Table table, EntityPropertyElem entityProp) {
        super(parentShell);
        this.resourceManager = resourceManager;
        this.project = project;
        this.table = table;
        this.entityProp = entityProp;
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(JptJpaUiMakePersistentMessages.BASIC_ANNOTATION_DLG_TITLE);
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 10;
        gl.marginHeight = 10;
        gl.marginWidth = 10;
        composite.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.widthHint = 400;
        composite.setLayoutData((Object)gd);
        this.createBasicGroup(composite);
        this.columnGroupCtl = new DbColumnAnnotationCtl(this.resourceManager, this.entityProp, this.table);
        this.columnGroupCtl.createColumnGroup(composite, 0);
        this.initFields();
        this.addListeners();
        return composite;
    }

    private Group createBasicGroup(Composite parent) {
        Group basicGroup = new Group(parent, 0);
        basicGroup.setText(JptJpaUiMakePersistentMessages.BASIC_ANNOTATION_GROUP_DESC);
        GridLayout layout = new GridLayout(2, false);
        basicGroup.setLayout((Layout)layout);
        basicGroup.setLayoutData((Object)new GridData(768));
        AssociationAnnotationWizard.createLabel((Composite)basicGroup, 1, JptJpaUiMakePersistentMessages.PROPERTY_NAME_LABEL, -1);
        this.propNameText = AssociationAnnotationWizard.createText((Composite)basicGroup, 1, true, null, 2056);
        AssociationAnnotationWizard.createLabel((Composite)basicGroup, 1, JptJpaUiMakePersistentMessages.PROPERTY_TYPE_LABEL, -1);
        this.propTypeText = AssociationAnnotationWizard.createText((Composite)basicGroup, 1, true, null, 2056);
        try {
            if (AnnotateMappingUtil.isDate((String)this.entityProp.getPropertyType(), (IProject)this.project)) {
                AssociationAnnotationWizard.createLabel((Composite)basicGroup, 1, JptJpaUiMakePersistentMessages.TEMPORAL, -1);
                this.temporalCombo = AssociationAnnotationWizard.createCombo((Composite)basicGroup, true, 1, 2060, -1);
            }
        }
        catch (JavaModelException je) {
            JptJpaUiPlugin.instance().logError(je);
        }
        return basicGroup;
    }

    private void initFields() {
        this.propNameText.setText(this.entityProp.getPropertyName());
        this.propTypeText.setText(this.entityProp.getPropertyType());
        if (this.temporalCombo != null) {
            String[] temporals = AnnotationAttrConverter.getTagEnumStringValues((String)"temporal");
            this.temporalCombo.setItems(temporals);
            assert (this.entityProp instanceof BasicEntityPropertyElem);
            BasicEntityPropertyElem basicProp = (BasicEntityPropertyElem)this.entityProp;
            String temporalType = basicProp.getTemporalType();
            if (temporalType != null) {
                int index = this.temporalCombo.indexOf(temporalType);
                assert (index != -1);
                this.temporalCombo.select(index);
            }
        }
        this.columnGroupCtl.initFields();
    }

    private void addListeners() {
        if (this.temporalCombo != null) {
            this.temporalCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BasicAnnotationDialog.this.handleTemporalTypeChange();
                }
            });
        }
        this.columnGroupCtl.addListeners();
    }

    private void handleTemporalTypeChange() {
        String newTemporalType = this.temporalCombo.getItem(this.temporalCombo.getSelectionIndex());
        assert (this.entityProp instanceof BasicEntityPropertyElem);
        BasicEntityPropertyElem basicProp = (BasicEntityPropertyElem)this.entityProp;
        basicProp.setTemporalType(newTemporalType);
    }
}

