/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.common.ui.JptCommonUiImages;
import org.eclipse.jpt.common.ui.internal.swt.widgets.TableTools;
import org.eclipse.jpt.common.ui.internal.widgets.TableLayoutComposite;
import org.eclipse.jpt.jpa.annotate.util.AnnotateMappingUtil;
import org.eclipse.jpt.jpa.ui.JptJpaUiMessages;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.JptJpaUiMakePersistentMessages;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class SelectOrderByDialog
extends Dialog {
    private IProject project;
    private String fqRefClassName;
    private CheckboxTableViewer propertiesTable;
    private List<PropertyOrder> initialOrderBys;
    private List<PropertyOrder> finalOrderBys;
    private static final String[] PROPERTY_TABLE_COLUMN_PROPERTIES = new String[]{"property", "order"};
    private static final int PROPERTY_COLUMN_INDEX = 0;
    private static final int ORDER_COLUMN_INDEX = 1;
    private static final String[] ORDER_NAMES = new String[]{"Ascending", "Descending"};
    private ResourceManager resourceManager;

    public SelectOrderByDialog(Shell shell, ResourceManager resourceManager, IProject project, String fqRefClassName, String orderBy) {
        super(shell);
        this.resourceManager = resourceManager;
        this.project = project;
        this.fqRefClassName = fqRefClassName;
        this.initOrderBys(orderBy);
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(JptJpaUiMakePersistentMessages.ORDER_BY_TITLE);
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout(1, false);
        composite.setLayout((Layout)gl);
        Label label = new Label(composite, 0);
        String desc = String.format(JptJpaUiMakePersistentMessages.ORDER_BY_DESC, AnnotateMappingUtil.getClassName((String)this.fqRefClassName));
        label.setText(desc);
        Composite tablesGroup = new Composite(composite, 0);
        tablesGroup.setLayout((Layout)new GridLayout(2, false));
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        tablesGroup.setLayoutData((Object)data);
        this.createPropertiesTable(tablesGroup);
        this.createButtonComposite(tablesGroup);
        return composite;
    }

    public String getOrderByDisplayStr() {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (PropertyOrder propOrder : this.finalOrderBys) {
            if (!propOrder.included) continue;
            if (!first) {
                buf.append(", ");
            } else {
                first = false;
            }
            buf.append(propOrder.propertyName);
            if (!propOrder.order.equals("Descending")) continue;
            buf.append(" DESC");
        }
        if (buf.length() > 0) {
            return buf.toString();
        }
        return null;
    }

    private void createPropertiesTable(Composite parent) {
        TableLayoutComposite layout = new TableLayoutComposite(parent, 0);
        this.addColumnLayoutData(layout);
        Table table = new Table((Composite)layout, 68388);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn tableNameColumn = new TableColumn(table, 0, 0);
        tableNameColumn.setText(JptJpaUiMakePersistentMessages.SELECT_ORDERBY_DIALOG_PROPERTY);
        tableNameColumn.setResizable(true);
        TableColumn entityNameColumn = new TableColumn(table, 0, 1);
        entityNameColumn.setText(JptJpaUiMakePersistentMessages.SELECT_ORDERBY_DIALOG_ORDER);
        entityNameColumn.setResizable(true);
        GridData gd = new GridData(1808);
        gd.heightHint = TableTools.calculateHeightHint((Table)table, (int)10);
        gd.widthHint = 400;
        layout.setLayoutData((Object)gd);
        this.propertiesTable = new CheckboxTableViewer(table);
        this.propertiesTable.setUseHashlookup(true);
        this.propertiesTable.setLabelProvider((IBaseLabelProvider)new PropertyTableLabelProvider());
        this.propertiesTable.setContentProvider((IContentProvider)new PropertyTableContentProvider());
        this.propertiesTable.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectOrderByDialog.this.handlePropertiesSelectionChanged(event);
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000B && e.stateMask == 0) {
                    e.doit = false;
                }
            }
        });
        this.addCellEditors();
        this.initPropertiesTable();
    }

    private void addColumnLayoutData(TableLayoutComposite layout) {
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
    }

    private void createButtonComposite(Composite tablesGroup) {
        Composite buttonComposite = new Composite(tablesGroup, 0);
        GridLayout buttonLayout = new GridLayout(1, false);
        buttonComposite.setLayout((Layout)buttonLayout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        buttonComposite.setLayoutData((Object)data);
        Button selectAllButton = new Button(buttonComposite, 8);
        selectAllButton.setImage(this.resourceManager.createImage(JptCommonUiImages.SELECT_ALL_BUTTON));
        selectAllButton.setToolTipText(JptJpaUiMessages.General_selectAll);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        selectAllButton.setLayoutData((Object)gridData);
        selectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SelectOrderByDialog.this.selectAllProperties();
            }
        });
        Button deselectAllButton = new Button(buttonComposite, 8);
        deselectAllButton.setImage(this.resourceManager.createImage(JptCommonUiImages.DESELECT_ALL_BUTTON));
        deselectAllButton.setToolTipText(JptJpaUiMessages.General_deselectAll);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        deselectAllButton.setLayoutData((Object)gridData);
        deselectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SelectOrderByDialog.this.deselectAllProperties();
            }
        });
    }

    private void syncPropertiesSelection() {
        for (PropertyOrder propOrder : this.finalOrderBys) {
            if (propOrder.included == this.propertiesTable.getChecked((Object)propOrder)) continue;
            boolean bl = propOrder.included = !propOrder.included;
            if (propOrder.included) {
                propOrder.order = "Ascending";
            }
            this.propertiesTable.update((Object)propOrder, null);
        }
    }

    private void selectAllProperties() {
        this.propertiesTable.setAllChecked(true);
        this.syncPropertiesSelection();
    }

    private void deselectAllProperties() {
        this.propertiesTable.setAllChecked(false);
        this.syncPropertiesSelection();
    }

    private void handlePropertiesSelectionChanged(SelectionChangedEvent event) {
        this.syncPropertiesSelection();
    }

    private void initPropertiesTable() {
        IType refType = null;
        this.finalOrderBys = new ArrayList<PropertyOrder>();
        try {
            IField[] fields;
            refType = AnnotateMappingUtil.getType((String)this.fqRefClassName, (IProject)this.project);
            IField[] iFieldArray = fields = refType.getFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                String typeStr;
                IField field = iFieldArray[n2];
                if (!Flags.isStatic((int)field.getFlags()) && !Flags.isSuper((int)field.getFlags()) && (AnnotateMappingUtil.isString((String)(typeStr = AnnotateMappingUtil.getFieldType((IField)field, (IType)refType))) || AnnotateMappingUtil.isNumeric((String)typeStr) || AnnotateMappingUtil.isDate((String)typeStr, (IProject)this.project) || AnnotateMappingUtil.isBoolean((String)typeStr))) {
                    PropertyOrder propertyOrder = new PropertyOrder(field.getElementName(), "Ascending");
                    if (this.initialOrderBys.contains(propertyOrder)) {
                        PropertyOrder another = this.initialOrderBys.get(this.initialOrderBys.indexOf(propertyOrder));
                        propertyOrder.included = true;
                        propertyOrder.order = another.order;
                    }
                    this.finalOrderBys.add(propertyOrder);
                }
                ++n2;
            }
            this.propertiesTable.setInput(this.finalOrderBys);
            for (PropertyOrder propOrder : this.finalOrderBys) {
                this.propertiesTable.setChecked((Object)propOrder, propOrder.included);
                this.propertiesTable.update((Object)propOrder, null);
            }
        }
        catch (JavaModelException je) {
            JptJpaUiPlugin.instance().logError(je);
        }
    }

    private void addCellEditors() {
        this.propertiesTable.setColumnProperties(PROPERTY_TABLE_COLUMN_PROPERTIES);
        CellEditor[] editors = new CellEditor[PROPERTY_TABLE_COLUMN_PROPERTIES.length];
        editors[1] = new ComboBoxCellEditor((Composite)this.propertiesTable.getTable(), ORDER_NAMES, 12);
        this.propertiesTable.setCellEditors(editors);
        this.propertiesTable.setCellModifier((ICellModifier)new PropertyOrderCellModifier());
    }

    private void initOrderBys(String orderBy) {
        this.initialOrderBys = new ArrayList<PropertyOrder>();
        if (orderBy != null && orderBy.length() > 0) {
            StringTokenizer tok = new StringTokenizer(orderBy, ",");
            while (tok.hasMoreTokens()) {
                String str = tok.nextToken();
                if (str.charAt(0) == ' ') {
                    str = str.substring(1);
                }
                String propName = null;
                String propOrder = null;
                PropertyOrder orderObj = null;
                int index = str.indexOf(32);
                if (index != -1) {
                    propName = str.substring(0, index);
                    String temp = str.substring(index + 1);
                    propOrder = temp.equals("DESC") ? "Descending" : "Ascending";
                    orderObj = new PropertyOrder(propName, propOrder);
                } else {
                    propName = str;
                    orderObj = new PropertyOrder(propName, "Ascending");
                }
                this.initialOrderBys.add(orderObj);
            }
        }
    }

    private class PropertyOrder {
        public String propertyName;
        public String order;
        public boolean included;

        public PropertyOrder(String propertyName, String order) {
            this(propertyName, order, false);
        }

        public PropertyOrder(String propertyName, String order, boolean included) {
            this.propertyName = propertyName;
            this.order = order;
            this.included = included;
        }

        public boolean equals(Object another) {
            if (!(another instanceof PropertyOrder)) {
                return false;
            }
            return this.propertyName.equals(((PropertyOrder)another).propertyName);
        }

        public String toString() {
            return "[" + this.propertyName + " order " + this.order + "]";
        }
    }

    private class PropertyOrderCellModifier
    implements ICellModifier {
        private CCombo orderCombo;

        public PropertyOrderCellModifier() {
            CellEditor cellEditor = SelectOrderByDialog.this.propertiesTable.getCellEditors()[1];
            assert (cellEditor instanceof ComboBoxCellEditor);
            ComboBoxCellEditor comboEditor = (ComboBoxCellEditor)cellEditor;
            this.orderCombo = (CCombo)comboEditor.getControl();
        }

        public boolean canModify(Object element, String property) {
            return property.equals(PROPERTY_TABLE_COLUMN_PROPERTIES[1]) && SelectOrderByDialog.this.propertiesTable.getChecked(element);
        }

        public Object getValue(Object element, String property) {
            if (property.equals(PROPERTY_TABLE_COLUMN_PROPERTIES[1])) {
                return SelectOrderByDialog.this.finalOrderBys.indexOf(element);
            }
            return new Integer(0);
        }

        public void modify(Object element, String property, Object value) {
            String newOrder;
            if (!(element instanceof TableItem)) {
                return;
            }
            Integer index = (Integer)value;
            TableItem item = (TableItem)element;
            PropertyOrder propertyOrder = (PropertyOrder)item.getData();
            propertyOrder.order = newOrder = this.orderCombo.getItem(index.intValue());
            SelectOrderByDialog.this.propertiesTable.refresh();
        }
    }

    private class PropertyTableContentProvider
    implements IStructuredContentProvider {
        PropertyTableContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return ((Collection)inputElement).toArray();
        }
    }

    private class PropertyTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        PropertyTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element == null) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return ((PropertyOrder)element).propertyName;
                }
                case 1: {
                    if (SelectOrderByDialog.this.propertiesTable.getChecked(element)) {
                        return ((PropertyOrder)element).order;
                    }
                    return null;
                }
            }
            throw new IllegalArgumentException("invalid column index: " + columnIndex);
        }
    }
}

