/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility.jdt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jpt.common.core.utility.jdt.TypeBinding;
import org.eclipse.jpt.common.utility.internal.ClassNameTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaResourceTypeBinding
implements TypeBinding {
    private String key;
    private String qualifiedName;
    private String simpleName;
    private String packageName;
    private boolean isInterface;
    private boolean isEnum;
    private boolean isGenericTypeDeclaration;
    private boolean isMemberTypeDeclaration;
    private final Vector<String> superclassNames = new Vector();
    private final Vector<String> interfaceNames = new Vector();
    private int arrayDimensionality;
    private String arrayComponentTypeName;
    private final Vector<String> typeArgumentNames = new Vector();

    public JavaResourceTypeBinding(ITypeBinding jdtTypeBinding) {
        this.key = jdtTypeBinding == null ? null : jdtTypeBinding.getKey();
        this.qualifiedName = this.buildQualifiedName(jdtTypeBinding);
        this.simpleName = this.buildSimpleName(jdtTypeBinding);
        this.packageName = this.buildPackageName(jdtTypeBinding);
        this.isInterface = this.buildIsInterface(jdtTypeBinding);
        this.isEnum = this.buildIsEnum(jdtTypeBinding);
        this.isGenericTypeDeclaration = this.buildIsGenericTypeDeclaration(jdtTypeBinding);
        this.isMemberTypeDeclaration = this.buildIsMemberTypeDeclaration(jdtTypeBinding);
        this.arrayDimensionality = this.buildArrayDimensionality(jdtTypeBinding);
        this.arrayComponentTypeName = this.buildArrayComponentTypeName(jdtTypeBinding);
        this.superclassNames.addAll(this.buildSuperclassNames(jdtTypeBinding));
        this.interfaceNames.addAll(this.buildInterfaceNames(jdtTypeBinding));
        this.typeArgumentNames.addAll(this.buildTypeArgumentNames(jdtTypeBinding));
    }

    public boolean isEquivalentTo(ITypeBinding typeBinding) {
        if (this.key == null) {
            return typeBinding == null;
        }
        if (typeBinding == null) {
            return false;
        }
        return this.key.equals(typeBinding.getKey());
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    private String buildQualifiedName(ITypeBinding typeBinding) {
        if (typeBinding == null) {
            return null;
        }
        String tbName = (typeBinding = typeBinding.getErasure()).getTypeDeclaration().getQualifiedName();
        return tbName.length() == 0 ? null : tbName;
    }

    @Override
    public String getSimpleName() {
        return this.simpleName;
    }

    private String buildSimpleName(ITypeBinding typeBinding) {
        if (typeBinding == null) {
            return null;
        }
        String tbName = (typeBinding = typeBinding.getErasure()).getTypeDeclaration().getName();
        return tbName.length() == 0 ? null : tbName;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    private String buildPackageName(ITypeBinding typeBinding) {
        if (typeBinding == null) {
            return null;
        }
        IPackageBinding pkg = (typeBinding = typeBinding.getErasure()).getTypeDeclaration().getPackage();
        return pkg == null ? null : pkg.getName();
    }

    @Override
    public boolean isInterface() {
        return this.isInterface;
    }

    private boolean buildIsInterface(ITypeBinding typeBinding) {
        return typeBinding != null && !typeBinding.isArray() && typeBinding.isInterface();
    }

    @Override
    public boolean isEnum() {
        return this.isEnum;
    }

    private boolean buildIsEnum(ITypeBinding typeBinding) {
        return typeBinding != null && !typeBinding.isArray() && typeBinding.isEnum();
    }

    @Override
    public boolean isVariablePrimitive() {
        return this.qualifiedName != null && ClassNameTools.isVariablePrimitive((String)this.qualifiedName);
    }

    @Override
    public boolean isGenericTypeDeclaration() {
        return this.isGenericTypeDeclaration;
    }

    private boolean buildIsGenericTypeDeclaration(ITypeBinding typeBinding) {
        return typeBinding != null && typeBinding.isGenericType();
    }

    @Override
    public boolean isMemberTypeDeclaration() {
        return this.isMemberTypeDeclaration;
    }

    private boolean buildIsMemberTypeDeclaration(ITypeBinding typeBinding) {
        return typeBinding == null ? false : typeBinding.isMember();
    }

    private List<String> buildSuperclassNames(ITypeBinding typeBinding) {
        if (typeBinding == null) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>();
        typeBinding = typeBinding.getSuperclass();
        while (typeBinding != null) {
            names.add(typeBinding.getErasure().getQualifiedName());
            typeBinding = typeBinding.getSuperclass();
        }
        return names;
    }

    private Collection<String> buildInterfaceNames(ITypeBinding typeBinding) {
        if (typeBinding == null) {
            return Collections.emptySet();
        }
        HashSet<String> names = new HashSet<String>();
        while (typeBinding != null) {
            this.addInterfaceNamesTo(typeBinding, names);
            typeBinding = typeBinding.getSuperclass();
        }
        return names;
    }

    private void addInterfaceNamesTo(ITypeBinding typeBinding, HashSet<String> names) {
        ITypeBinding[] iTypeBindingArray = typeBinding.getInterfaces();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding interfaceBinding = iTypeBindingArray[n2];
            names.add(interfaceBinding.getTypeDeclaration().getErasure().getQualifiedName());
            this.addInterfaceNamesTo(interfaceBinding, names);
            ++n2;
        }
    }

    @Override
    public boolean isSubTypeOf(String tn) {
        if (this.qualifiedName == null) {
            return false;
        }
        return this.qualifiedName.equals(tn) || this.interfaceNames.contains(tn) || this.superclassNames.contains(tn);
    }

    @Override
    public int getArrayDimensionality() {
        return this.arrayDimensionality;
    }

    private int buildArrayDimensionality(ITypeBinding typeBinding) {
        return typeBinding == null ? 0 : typeBinding.getDimensions();
    }

    @Override
    public boolean isArray() {
        return this.arrayDimensionality > 0;
    }

    @Override
    public String getArrayComponentTypeName() {
        return this.arrayComponentTypeName;
    }

    /*
     * Unable to fully structure code
     */
    private String buildArrayComponentTypeName(ITypeBinding typeBinding) {
        if (typeBinding != null && typeBinding.isArray()) ** GOTO lbl5
        return null;
lbl-1000:
        // 1 sources

        {
            if ((typeBinding = typeBinding.getComponentType()) != null) continue;
            return null;
lbl5:
            // 2 sources

            ** while (typeBinding.isArray())
        }
lbl6:
        // 1 sources

        if (typeBinding.isTypeVariable()) {
            typeBinding = typeBinding.getErasure();
        }
        return (tbName = typeBinding.getTypeDeclaration().getQualifiedName()).length() == 0 ? null : tbName;
    }

    @Override
    public ListIterable<String> getTypeArgumentNames() {
        return IterableTools.cloneLive(this.typeArgumentNames);
    }

    @Override
    public int getTypeArgumentNamesSize() {
        return this.typeArgumentNames.size();
    }

    @Override
    public String getTypeArgumentName(int index) {
        return this.typeArgumentNames.get(index);
    }

    private List<String> buildTypeArgumentNames(ITypeBinding typeBinding) {
        if (typeBinding == null) {
            return Collections.emptyList();
        }
        ITypeBinding[] typeArguments = typeBinding.getTypeArguments();
        if (typeArguments.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>(typeArguments.length);
        ITypeBinding[] iTypeBindingArray = typeArguments;
        int n = typeArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding typeArgument = iTypeBindingArray[n2];
            if (typeArgument == null) {
                names.add(null);
            } else {
                ITypeBinding erasure = typeArgument.getErasure();
                names.add(erasure.getTypeDeclaration().getQualifiedName());
            }
            ++n2;
        }
        return names;
    }
}

