/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import java.lang.reflect.Array;
import java.util.logging.Level;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.proxy.common.CommandException;
import org.eclipse.jem.internal.proxy.common.remote.CommandErrorException;
import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.core.IArrayBeanProxy;
import org.eclipse.jem.internal.proxy.core.IArrayBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IBooleanBeanProxy;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.remote.BeanProxyValueSender;
import org.eclipse.jem.internal.proxy.remote.IREMBeanProxy;
import org.eclipse.jem.internal.proxy.remote.IREMConnection;
import org.eclipse.jem.internal.proxy.remote.IREMMethodProxy;
import org.eclipse.jem.internal.proxy.remote.REMBeanProxy;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanProxyConstants;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanProxyFactory;

public final class REMArrayBeanProxy
extends REMBeanProxy
implements IArrayBeanProxy {
    private int fLength = -1;

    REMArrayBeanProxy(REMProxyFactoryRegistry aRegistry, Integer anID, IBeanTypeProxy aType) {
        super(aRegistry, anID, aType);
    }

    public boolean equals(Object anObject) {
        if (!(anObject instanceof IArrayBeanProxy)) {
            return false;
        }
        if (this.sameAs((IBeanProxy)anObject)) {
            return true;
        }
        if (((IBeanProxy)anObject).getProxyFactoryRegistry() == this.fFactory) {
            try {
                return ((IBooleanBeanProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayHelperEquals().invoke(null, new IBeanProxy[]{this, (IBeanProxy)anObject})).booleanValue();
            }
            catch (ThrowableProxy e) {
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e, Level.INFO);
            }
        }
        return false;
    }

    public IBeanProxy get(int index) throws ThrowableProxy {
        Object[] parms = new Object[]{this, new Integer(index)};
        IBeanTypeProxy compType = ((IArrayBeanTypeProxy)this.getTypeProxy()).getComponentType();
        if (!compType.isPrimitive()) {
            return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayGet()).invokeWithParms(null, parms);
        }
        int id = ((IREMBeanProxy)((Object)compType)).getID();
        switch (id) {
            case 5: {
                return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayGetByte()).invokeWithParms(null, parms);
            }
            case 1: {
                return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayGetBoolean()).invokeWithParms(null, parms);
            }
            case 7: {
                return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayGetChar()).invokeWithParms(null, parms);
            }
            case 9: {
                return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayGetDouble()).invokeWithParms(null, parms);
            }
            case 11: {
                return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayGetFloat()).invokeWithParms(null, parms);
            }
            case 3: {
                return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayGetInt()).invokeWithParms(null, parms);
            }
            case 15: {
                return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayGetLong()).invokeWithParms(null, parms);
            }
            case 13: {
                return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayGetShort()).invokeWithParms(null, parms);
            }
        }
        return null;
    }

    public IBeanProxy get(int[] indexes) throws ThrowableProxy {
        Object[] parms = new Object[]{this, indexes};
        int dims = ((IArrayBeanTypeProxy)this.getTypeProxy()).getDimensions();
        if (dims < indexes.length) {
            throw new IllegalArgumentException();
        }
        IBeanTypeProxy finalCompType = ((IArrayBeanTypeProxy)this.getTypeProxy()).getFinalComponentType();
        if (dims == indexes.length && finalCompType.isPrimitive()) {
            int id = ((IREMBeanProxy)((Object)finalCompType)).getID();
            switch (id) {
                case 5: {
                    return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayHelperGetByte()).invokeWithParms(null, parms);
                }
                case 1: {
                    return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayHelperGetBoolean()).invokeWithParms(null, parms);
                }
                case 7: {
                    return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayHelperGetChar()).invokeWithParms(null, parms);
                }
                case 9: {
                    return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayHelperGetDouble()).invokeWithParms(null, parms);
                }
                case 11: {
                    return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayHelperGetFloat()).invokeWithParms(null, parms);
                }
                case 3: {
                    return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayHelperGetInt()).invokeWithParms(null, parms);
                }
                case 15: {
                    return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayHelperGetLong()).invokeWithParms(null, parms);
                }
                case 13: {
                    return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayHelperGetShort()).invokeWithParms(null, parms);
                }
            }
        } else {
            return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayHelperGet()).invokeWithParms(null, parms);
        }
        return null;
    }

    public void set(IBeanProxy value, int index) throws ThrowableProxy {
        Object[] parms = new Object[]{this, new Integer(index), value};
        ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArraySet()).invokeWithParms(null, parms);
    }

    public void set(IBeanProxy value, int[] indexes) throws ThrowableProxy {
        Object[] parms = new Object[]{this, indexes, value};
        ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayHelperSet()).invokeWithParms(null, parms);
    }

    public int getLength() {
        if (this.fLength == -1) {
            this.fLength = ((IIntegerBeanProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayGetLength().invokeCatchThrowableExceptions(null, this)).intValue();
        }
        return this.fLength;
    }

    public IBeanProxy getCatchThrowableException(int index) {
        try {
            return this.get(index);
        }
        catch (ThrowableProxy e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
            this.fFactory.releaseProxy(e);
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IBeanProxy[] getSnapshot() throws ThrowableProxy {
        connect = this.fFactory.getFreeConnection();
        proxyFactory = (REMStandardBeanProxyFactory)this.fFactory.getBeanProxyFactory();
        proxyFactory.startTransaction();
        try {
            returnValue = new Commands.ValueObject();
            try {
                connect.getArrayContents(this.getID(), returnValue);
                var8_4 = this.processReturnValue(connect, returnValue);
                ** GOTO lbl36
            }
            catch (CommandErrorException e) {
                try {
                    proxyFactory.processErrorReturn(e);
                }
                catch (CommandException e) {
                    block11: {
                        if (!e.isRecoverable()) {
                            this.fFactory.closeConnection(connect);
                            connect = null;
                            connect = this.fFactory.getFreeConnection();
                            try {
                                connect.getArrayContents(this.getID(), returnValue);
                                var8_5 = this.processReturnValue(connect, returnValue);
                            }
                            catch (CommandException eAgain) {
                                this.fFactory.closeConnection(connect);
                                connect = null;
                                ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)eAgain));
lbl29:
                                // 2 sources

                                while (true) {
                                    var6_8 = null;
                                    proxyFactory.stopTransaction();
                                    if (connect == null) return null;
                                    this.fFactory.returnConnection(connect);
                                    return null;
                                }
                            }
                        }
                        break block11;
lbl36:
                        // 1 sources

                        var6_6 = null;
                        proxyFactory.stopTransaction();
                        if (connect == null) return var8_4;
                        this.fFactory.returnConnection(connect);
                        return var8_4;
                        var6_7 = null;
                        proxyFactory.stopTransaction();
                        if (connect == null) return var8_5;
                        this.fFactory.returnConnection(connect);
                        return var8_5;
                    }
                    ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
                    ** continue;
                }
            }
        }
        catch (Throwable var7_14) {
            var6_9 = null;
            proxyFactory.stopTransaction();
            if (connect == null) throw var7_14;
            this.fFactory.returnConnection(connect);
            throw var7_14;
        }
        {
            var6_10 = null;
            proxyFactory.stopTransaction();
            if (connect == null) return null;
            this.fFactory.returnConnection(connect);
            return null;
        }
    }

    private IBeanProxy[] processReturnValue(IREMConnection connection, Commands.ValueObject returnValue) throws CommandException, ThrowableProxy {
        BeanProxyValueSender valueSender = new BeanProxyValueSender((REMStandardBeanProxyFactory)this.fFactory.getBeanProxyFactory(), returnValue);
        connection.readProxyArrayValues(returnValue, valueSender, false);
        Exception e = valueSender.getException();
        if (e != null) {
            if (e instanceof ThrowableProxy) {
                throw (ThrowableProxy)e;
            }
            throw (CommandException)e;
        }
        Object[] vals = valueSender.getArray();
        IBeanProxy[] proxyArray = new IBeanProxy[Array.getLength(vals)];
        System.arraycopy(vals, 0, proxyArray, 0, proxyArray.length);
        return proxyArray;
    }
}

