/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.composites;

import java.util.Comparator;
import org.apache.maven.model.Dependency;

public class DependenciesComparator<T>
implements Comparator<T> {
    private boolean sortByGroups = true;

    @Override
    public int compare(T o1, T o2) {
        String[] gav1 = this.toGAV((Dependency)o1);
        String[] gav2 = this.toGAV((Dependency)o2);
        return this.compareGAVs(gav1, gav2);
    }

    protected String[] toGAV(Dependency dep) {
        String[] gav = new String[]{dep.getGroupId(), dep.getArtifactId(), dep.getVersion()};
        return gav;
    }

    protected int compareGAVs(String[] gav1, String[] gav2) {
        String g1 = gav1[0] == null ? "" : gav1[0];
        String g2 = gav2[0] == null ? "" : gav2[0];
        String a1 = gav1[1] == null ? "" : gav1[1];
        String a2 = gav2[1] == null ? "" : gav2[1];
        String v1 = gav1[2] == null ? "" : gav1[2];
        String v2 = gav2[2] == null ? "" : gav2[2];
        return this.compareDependencies(g1, a1, v1, g2, a2, v2);
    }

    protected int compareDependencies(String group1, String artifact1, String version1, String group2, String artifact2, String version2) {
        int comp = 0;
        if (this.sortByGroups && (comp = group1.compareTo(group2)) != 0) {
            return comp;
        }
        comp = artifact1.compareTo(artifact2);
        if (comp != 0) {
            return comp;
        }
        return version1.compareTo(version2);
    }

    public void setSortByGroups(boolean sortByGroups) {
        this.sortByGroups = sortByGroups;
    }
}

