/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.tools.schemaframework.ForeignKeyConstraint;

public class ForeignKeyMetadata
extends ORMetadata {
    protected String m_name;
    protected String m_constraintMode;
    protected String m_foreignKeyDefinition;

    public ForeignKeyMetadata() {
        super("<foreign-key>");
    }

    public ForeignKeyMetadata(ForeignKeyMetadata foreignKey) {
        super(foreignKey);
        this.m_name = foreignKey.getName();
        this.m_constraintMode = foreignKey.getConstraintMode();
        this.m_foreignKeyDefinition = foreignKey.getForeignKeyDefinition();
    }

    public ForeignKeyMetadata(MetadataAnnotation foreignKey, MetadataAccessor accessor) {
        super(foreignKey, accessor);
        this.m_name = foreignKey.getAttributeString("name");
        this.m_constraintMode = foreignKey.getAttributeString("value");
        this.m_foreignKeyDefinition = foreignKey.getAttributeString("foreignKeyDefinition");
    }

    public ForeignKeyMetadata(String xmlElement) {
        super(xmlElement);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof ForeignKeyMetadata) {
            ForeignKeyMetadata foreignKey = (ForeignKeyMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_name, foreignKey.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_foreignKeyDefinition, foreignKey.getForeignKeyDefinition())) {
                return false;
            }
            return this.valuesMatch(this.m_constraintMode, foreignKey.getConstraintMode());
        }
        return false;
    }

    public String getConstraintMode() {
        return this.m_constraintMode;
    }

    public String getForeignKeyDefinition() {
        return this.m_foreignKeyDefinition;
    }

    public String getName() {
        return this.m_name;
    }

    protected boolean isConstraintMode() {
        return this.m_constraintMode == null || this.m_constraintMode.equals("CONSTRAINT");
    }

    protected boolean isNoConstraintMode() {
        return this.m_constraintMode != null && this.m_constraintMode.equals("NO_CONSTRAINT");
    }

    protected boolean isProviderDefaultConstraintMode() {
        return this.m_constraintMode != null && this.m_constraintMode.equals("PROVIDER_DEFAULT");
    }

    public void process(DatabaseTable table) {
        if (!this.isProviderDefaultConstraintMode()) {
            ForeignKeyConstraint foreignKeyConstraint = new ForeignKeyConstraint();
            foreignKeyConstraint.setName(this.getName());
            foreignKeyConstraint.setForeignKeyDefinition(this.getForeignKeyDefinition());
            foreignKeyConstraint.setDisableForeignKey(this.isNoConstraintMode());
            table.addForeignKeyConstraint(foreignKeyConstraint);
        }
    }

    public void setConstraintMode(String constraintMode) {
        this.m_constraintMode = constraintMode;
    }

    public void setForeignKeyDefinition(String foreignKeyDefinition) {
        this.m_foreignKeyDefinition = foreignKeyDefinition;
    }

    public void setName(String name) {
        this.m_name = name;
    }
}

