/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.spi.java;

import java.lang.reflect.Member;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.jpa.jpql.Assert;
import org.eclipse.persistence.jpa.jpql.tools.spi.IEmbeddable;
import org.eclipse.persistence.jpa.jpql.tools.spi.IEntity;
import org.eclipse.persistence.jpa.jpql.tools.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.tools.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.tools.spi.IMappedSuperclass;
import org.eclipse.persistence.jpa.jpql.tools.spi.IMappingBuilder;
import org.eclipse.persistence.jpa.jpql.tools.spi.IType;
import org.eclipse.persistence.jpa.jpql.tools.spi.java.JavaEmbeddable;
import org.eclipse.persistence.jpa.jpql.tools.spi.java.JavaEntity;
import org.eclipse.persistence.jpa.jpql.tools.spi.java.JavaMappedSuperclass;
import org.eclipse.persistence.jpa.jpql.tools.spi.java.JavaType;
import org.eclipse.persistence.jpa.jpql.tools.spi.java.JavaTypeRepository;
import org.eclipse.persistence.jpa.jpql.tools.utility.iterable.SnapshotCloneIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaManagedTypeProvider
implements IManagedTypeProvider {
    private Map<String, IEmbeddable> embeddables;
    private Map<String, IEntity> entities;
    private Map<String, IManagedType> managedTypes;
    private Map<String, IMappedSuperclass> mappedSuperclasses;
    private IMappingBuilder<Member> mappingBuilder;
    private JavaTypeRepository typeRepository;

    public JavaManagedTypeProvider(IMappingBuilder<Member> mappingBuilder) {
        this.initialize(mappingBuilder);
    }

    public IEmbeddable addEmbeddable(Class<?> type) {
        IEmbeddable embeddable = this.buildEmbeddable(type);
        this.embeddables.put(type.getName(), embeddable);
        this.managedTypes.put(type.getName(), embeddable);
        return embeddable;
    }

    public IEntity addEntity(Class<?> type) {
        IEntity entity = this.buildEntity(type);
        this.entities.put(type.getName(), entity);
        this.managedTypes.put(type.getName(), entity);
        return entity;
    }

    public IMappedSuperclass addMappedSuperclass(Class<?> type) {
        IMappedSuperclass mappedSuperclass = this.buildMappedSuperclass(type);
        this.mappedSuperclasses.put(type.getName(), mappedSuperclass);
        this.managedTypes.put(type.getName(), mappedSuperclass);
        return mappedSuperclass;
    }

    protected IEmbeddable buildEmbeddable(Class<?> type) {
        return new JavaEmbeddable(this, (JavaType)this.getTypeRepository().getType((Class)type), this.mappingBuilder);
    }

    protected IEntity buildEntity(Class<?> type) {
        return new JavaEntity(this, (JavaType)this.getTypeRepository().getType((Class)type), this.mappingBuilder);
    }

    protected IMappedSuperclass buildMappedSuperclass(Class<?> type) {
        return new JavaMappedSuperclass(this, (JavaType)this.getTypeRepository().getType((Class)type), this.mappingBuilder);
    }

    @Override
    public Iterable<IEntity> entities() {
        return new SnapshotCloneIterable<IEntity>(this.entities.values());
    }

    @Override
    public IEmbeddable getEmbeddable(IType type) {
        return this.getEmbeddable(type.getName());
    }

    @Override
    public IEmbeddable getEmbeddable(String typeName) {
        return this.embeddables.get(typeName);
    }

    @Override
    public IEntity getEntity(IType type) {
        return this.getEntity(type.getName());
    }

    @Override
    public IEntity getEntity(String typeName) {
        return this.entities.get(typeName);
    }

    @Override
    public IEntity getEntityNamed(String entityName) {
        for (IEntity entity : this.entities.values()) {
            if (!entity.getName().equals(entityName)) continue;
            return entity;
        }
        return null;
    }

    @Override
    public IManagedType getManagedType(IType type) {
        return this.getManagedType(type.getName());
    }

    @Override
    public IManagedType getManagedType(String typeName) {
        return this.managedTypes.get(typeName);
    }

    @Override
    public IMappedSuperclass getMappedSuperclass(IType type) {
        return this.getMappedSuperclass(type.getName());
    }

    @Override
    public IMappedSuperclass getMappedSuperclass(String typeName) {
        return this.mappedSuperclasses.get(typeName);
    }

    protected IMappingBuilder<Member> getMappingBuilder() {
        return this.mappingBuilder;
    }

    @Override
    public JavaTypeRepository getTypeRepository() {
        if (this.typeRepository == null) {
            this.typeRepository = new JavaTypeRepository(this.getClass().getClassLoader());
        }
        return this.typeRepository;
    }

    protected void initialize() {
    }

    private void initialize(IMappingBuilder<Member> mappingBuilder) {
        Assert.isNotNull(mappingBuilder, "The IMappingBuilder cannot be null");
        this.mappingBuilder = mappingBuilder;
        this.entities = new HashMap<String, IEntity>();
        this.embeddables = new HashMap<String, IEmbeddable>();
        this.managedTypes = new HashMap<String, IManagedType>();
        this.mappedSuperclasses = new HashMap<String, IMappedSuperclass>();
        this.initialize();
    }

    @Override
    public Iterable<IManagedType> managedTypes() {
        return new SnapshotCloneIterable<IManagedType>(this.managedTypes.values());
    }
}

