/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.notifications.feed;

import com.sun.syndication.feed.module.DCModule;
import com.sun.syndication.feed.module.DCSubject;
import com.sun.syndication.feed.synd.SyndEntry;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.internal.commons.notifications.feed.ServiceMessage;

public class FeedEntry
extends ServiceMessage {
    private final SyndEntry source;

    public FeedEntry(String eventId, SyndEntry source) {
        super(eventId);
        this.source = source;
        this.setId(source.getUri());
        this.setTitle(source.getTitle());
        if (source.getDescription() != null) {
            this.setDescription(source.getDescription().getValue());
        }
        this.setUrl(source.getLink());
        this.setImage("dialog_messasge_info_image");
        this.setDate(source.getPublishedDate());
    }

    public FeedEntry(String eventId) {
        super(eventId);
        this.source = null;
    }

    public SyndEntry getSource() {
        return this.source;
    }

    public List<String> getFilters(String key) {
        Assert.isNotNull((Object)key);
        ArrayList<String> result = new ArrayList<String>();
        DCModule module = (DCModule)this.source.getModule("http://purl.org/dc/elements/1.1/");
        if (module != null && module.getSubjects() != null) {
            for (DCSubject category : module.getSubjects()) {
                String value = this.parseFilter(key, category.getValue());
                if (value == null) continue;
                result.add(value);
            }
        }
        return result;
    }

    public String getFilter(String key) {
        Assert.isNotNull((Object)key);
        DCModule module = (DCModule)this.source.getModule("http://purl.org/dc/elements/1.1/");
        if (module != null && module.getSubjects() != null) {
            for (DCSubject category : module.getSubjects()) {
                String value = this.parseFilter(key, category.getValue());
                if (value == null) continue;
                return value;
            }
        }
        return null;
    }

    private String parseFilter(String key, String category) {
        int i;
        if (category != null && (i = category.indexOf("=")) != -1 && category.substring(0, i).trim().equals(key)) {
            return category.substring(i + 1).trim();
        }
        return null;
    }
}

