/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.List;
import org.eclipse.debug.internal.ui.AbstractDebugCheckboxSelectionDialog;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.debug.ui.IJavaDebugUIConstants;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectSelectionDialog
extends AbstractDebugCheckboxSelectionDialog {
    private boolean fAddExportedEntries = true;
    private boolean fAddRequiredProjects = true;
    private List<IJavaProject> fProjects;

    public ProjectSelectionDialog(Shell parentShell, List<IJavaProject> projects) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setShowSelectAllButtons(true);
        this.fProjects = projects;
    }

    protected void addCustomFooterControls(Composite parent) {
        super.addCustomFooterControls(parent);
        final Button addExported = new Button(parent, 32);
        addExported.setText(ActionMessages.ProjectSelectionDialog_Add_exported_entries_of_selected_projects__1);
        addExported.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectSelectionDialog.this.fAddExportedEntries = addExported.getSelection();
            }
        });
        addExported.setSelection(this.fAddExportedEntries);
        addExported.setFont(parent.getFont());
        final Button addRequired = new Button(parent, 32);
        addRequired.setText(ActionMessages.ProjectSelectionDialog_Add_required_projects_of_selected_projects__2);
        addRequired.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectSelectionDialog.this.fAddRequiredProjects = addRequired.getSelection();
            }
        });
        addRequired.setSelection(this.fAddRequiredProjects);
        addRequired.setFont(parent.getFont());
    }

    public boolean isAddExportedEntries() {
        return this.fAddExportedEntries;
    }

    public boolean isAddRequiredProjects() {
        return this.fAddRequiredProjects;
    }

    protected String getDialogSettingsId() {
        return String.valueOf(IJavaDebugUIConstants.PLUGIN_ID) + ".PROJECT_SELECTION_DIALOG_SECTION";
    }

    protected String getHelpContextId() {
        return IJavaDebugHelpContextIds.SELECT_PROJECT_DIALOG;
    }

    protected Object getViewerInput() {
        return this.fProjects;
    }

    protected String getViewerLabel() {
        return ActionMessages.ProjectSelectionDialog_0;
    }

    protected StructuredViewer createViewer(Composite parent) {
        StructuredViewer viewer = super.createViewer(parent);
        viewer.setComparator((ViewerComparator)new JavaElementComparator());
        return viewer;
    }
}

