/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.source;

import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceModel;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationElementAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SourceAnnotation
extends SourceModel
implements Annotation {
    protected final AnnotatedElement annotatedElement;
    protected final DeclarationAnnotationAdapter daa;
    protected final AnnotationAdapter annotationAdapter;
    protected TextRange annotationTextRange;

    protected SourceAnnotation(JavaResourceModel parent, AnnotatedElement element, DeclarationAnnotationAdapter daa) {
        this(parent, element, daa, new ElementAnnotationAdapter(element, daa));
    }

    protected SourceAnnotation(JavaResourceModel parent, AnnotatedElement element, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent);
        this.annotatedElement = element;
        this.daa = daa;
        this.annotationAdapter = annotationAdapter;
    }

    @Override
    public TextRange getTextRange() {
        return this.getAnnotationTextRange();
    }

    @Override
    public void initialize(org.eclipse.jdt.core.dom.Annotation astAnnotation) {
        this.annotationTextRange = this.buildTextRange((ASTNode)astAnnotation);
        this.initialize((CompilationUnit)astAnnotation.getRoot());
    }

    @Override
    public void synchronizeWith(org.eclipse.jdt.core.dom.Annotation astAnnotation) {
        this.annotationTextRange = this.buildTextRange((ASTNode)astAnnotation);
        this.synchronizeWith((CompilationUnit)astAnnotation.getRoot());
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
    }

    @Override
    public org.eclipse.jdt.core.dom.Annotation getAstAnnotation(CompilationUnit astRoot) {
        return this.annotationAdapter.getAnnotation(astRoot);
    }

    @Override
    public void newAnnotation() {
        this.initialize((org.eclipse.jdt.core.dom.Annotation)this.annotationAdapter.newMarkerAnnotation());
    }

    @Override
    public void removeAnnotation() {
        this.annotationAdapter.removeAnnotation();
    }

    @Override
    public boolean isUnset() {
        return true;
    }

    protected DeclarationAnnotationElementAdapter<String> buildStringElementAdapter(String elementName) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(this.daa, elementName);
    }

    protected DeclarationAnnotationElementAdapter<Boolean> buildBooleanElementAdapter(String elementName) {
        return ConversionDeclarationAnnotationElementAdapter.forBooleans(this.daa, elementName);
    }

    protected DeclarationAnnotationElementAdapter<Integer> buildIntegerElementAdapter(String elementName) {
        return ConversionDeclarationAnnotationElementAdapter.forNumbers(this.daa, elementName);
    }

    protected AnnotationElementAdapter<String> buildStringElementAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new AnnotatedElementAnnotationElementAdapter<String>(this.annotatedElement, daea);
    }

    protected AnnotationElementAdapter<Boolean> buildBooleanElementAdapter(DeclarationAnnotationElementAdapter<Boolean> daea) {
        return new AnnotatedElementAnnotationElementAdapter<Boolean>(this.annotatedElement, daea);
    }

    protected AnnotationElementAdapter<Integer> buildIntegerElementAdapter(DeclarationAnnotationElementAdapter<Integer> daea) {
        return new AnnotatedElementAnnotationElementAdapter<Integer>(this.annotatedElement, daea);
    }

    protected CompilationUnit buildASTRoot() {
        return this.getJavaResourceCompilationUnit().buildASTRoot();
    }

    protected TextRange getAnnotationTextRange() {
        return this.annotationTextRange;
    }

    protected TextRange getAnnotationTextRange(org.eclipse.jdt.core.dom.Annotation astAnnotation) {
        return this.buildTextRange((ASTNode)astAnnotation);
    }

    protected TextRange getElementTextRange(DeclarationAnnotationElementAdapter<?> elementAdapter, org.eclipse.jdt.core.dom.Annotation astAnnotation) {
        return this.getElementTextRange(this.getAnnotationElementTextRange(elementAdapter, astAnnotation), astAnnotation);
    }

    protected List<TextRange> getElementTextRanges(DeclarationAnnotationElementAdapter<?> elementAdapter, org.eclipse.jdt.core.dom.Annotation astAnnotation) {
        return this.getElementTextRanges(this.getAnnotationElementTextRanges(elementAdapter, astAnnotation), astAnnotation);
    }

    protected TextRange getElementTextRange(IndexedDeclarationAnnotationElementAdapter<?> elementAdapter, int index, org.eclipse.jdt.core.dom.Annotation astAnnotation) {
        return this.getElementTextRange(this.getAnnotationElementTextRange(elementAdapter, index, astAnnotation), astAnnotation);
    }

    protected TextRange getElementTextRange(TextRange elementTextRange, org.eclipse.jdt.core.dom.Annotation astAnnotation) {
        return elementTextRange != null ? elementTextRange : this.getAnnotationTextRange(astAnnotation);
    }

    protected List<TextRange> getElementTextRanges(List<TextRange> elementTextRanges, org.eclipse.jdt.core.dom.Annotation astAnnotation) {
        return !elementTextRanges.isEmpty() ? elementTextRanges : Collections.singletonList(this.getAnnotationTextRange(astAnnotation));
    }

    protected boolean textRangeTouches(TextRange textRange, int pos) {
        return textRange != null && textRange.touches(pos);
    }

    protected TextRange getAnnotationElementTextRange(DeclarationAnnotationElementAdapter<?> adapter, org.eclipse.jdt.core.dom.Annotation astAnnotation) {
        return astAnnotation == null ? null : this.buildTextRange((ASTNode)this.getAnnotationElementExpression(adapter, astAnnotation));
    }

    protected List<TextRange> getAnnotationElementTextRanges(DeclarationAnnotationElementAdapter<?> adapter, org.eclipse.jdt.core.dom.Annotation astAnnotation) {
        return astAnnotation == null ? Collections.emptyList() : this.buildTextRanges((ASTNode)this.getAnnotationElementExpression(adapter, astAnnotation));
    }

    protected TextRange getAnnotationElementTextRange(IndexedDeclarationAnnotationElementAdapter<?> adapter, int index, org.eclipse.jdt.core.dom.Annotation astAnnotation) {
        return astAnnotation == null ? null : this.buildTextRange((ASTNode)this.getAnnotationElementExpression(adapter, index, astAnnotation));
    }

    protected Expression getAnnotationElementExpression(DeclarationAnnotationElementAdapter<?> adapter, org.eclipse.jdt.core.dom.Annotation astAnnotation) {
        return adapter.getExpression(astAnnotation);
    }

    protected Expression getAnnotationElementExpression(IndexedDeclarationAnnotationElementAdapter<?> adapter, int index, org.eclipse.jdt.core.dom.Annotation astAnnotation) {
        return adapter.selectExpression(astAnnotation, index);
    }

    protected TextRange buildTextRange(ASTNode astNode) {
        return astNode == null ? null : ASTTools.buildTextRange(astNode);
    }

    protected List<TextRange> buildTextRanges(ASTNode astNode) {
        return astNode == null ? Collections.emptyList() : ASTTools.buildTextRanges(astNode);
    }

    public void moveAnnotation(int newIndex) {
        this.getIndexedAnnotationAdapter().moveAnnotation(newIndex);
    }

    private IndexedAnnotationAdapter getIndexedAnnotationAdapter() {
        return (IndexedAnnotationAdapter)this.annotationAdapter;
    }
}

