/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.source;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAbstractType;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceEnumConstant;
import org.eclipse.jpt.common.core.internal.utility.jdt.JDTEnum;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceEnum;
import org.eclipse.jpt.common.core.resource.java.JavaResourceEnumConstant;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.jdt.Enum;
import org.eclipse.jpt.common.core.utility.jdt.Type;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementIterable;
import org.eclipse.jpt.common.utility.internal.reference.SimpleIntReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SourceEnum
extends SourceAbstractType<Enum>
implements JavaResourceEnum {
    private final Vector<JavaResourceEnumConstant> enumConstants = new Vector();

    static JavaResourceEnum newInstance(JavaResourceCompilationUnit javaResourceCompilationUnit, EnumDeclaration enumDeclaration) {
        JDTEnum _enum = new JDTEnum(enumDeclaration, javaResourceCompilationUnit.getCompilationUnit(), javaResourceCompilationUnit.getModifySharedDocumentCommandContext(), javaResourceCompilationUnit.getAnnotationEditFormatter());
        SourceEnum jre = new SourceEnum(javaResourceCompilationUnit, _enum);
        jre.initialize(enumDeclaration);
        return jre;
    }

    protected static JavaResourceEnum newInstance(JavaResourceCompilationUnit javaResourceCompilationUnit, Type declaringType, EnumDeclaration enumDeclaration, int occurrence) {
        JDTEnum _enum = new JDTEnum(declaringType, enumDeclaration, occurrence, javaResourceCompilationUnit.getCompilationUnit(), javaResourceCompilationUnit.getModifySharedDocumentCommandContext(), javaResourceCompilationUnit.getAnnotationEditFormatter());
        SourceEnum jre = new SourceEnum(javaResourceCompilationUnit, _enum);
        jre.initialize(enumDeclaration);
        return jre;
    }

    private SourceEnum(JavaResourceCompilationUnit javaResourceCompilationUnit, Enum _enum) {
        super(javaResourceCompilationUnit, _enum);
    }

    protected void initialize(EnumDeclaration enumDeclaration) {
        super.initialize((AbstractTypeDeclaration)enumDeclaration);
        this.initializeEnumConstants(enumDeclaration);
    }

    @Override
    public void synchronizeWith(EnumDeclaration enumDeclaration) {
        super.synchronizeWith((AbstractTypeDeclaration)enumDeclaration);
        this.syncEnumConstants(enumDeclaration);
    }

    @Override
    public void resolveTypes(EnumDeclaration enumDeclaration) {
        EnumConstantDeclaration[] enumConstantDeclarations = ((Enum)this.annotatedElement).getEnumConstants(enumDeclaration);
        int i = 0;
        for (JavaResourceEnumConstant enumConstant : this.getEnumConstants()) {
            enumConstant.resolveTypes(enumConstantDeclarations[i++]);
        }
    }

    @Override
    public JavaResourceAnnotatedElement.AstNodeType getAstNodeType() {
        return JavaResourceAnnotatedElement.AstNodeType.ENUM;
    }

    @Override
    public Iterable<JavaResourceEnumConstant> getEnumConstants() {
        return IterableTools.cloneLive(this.enumConstants);
    }

    private void addEnumConstant(JavaResourceEnumConstant enumConstant) {
        this.addItemToCollection(enumConstant, this.enumConstants, "enumConstants");
    }

    private JavaResourceEnumConstant getEnumConstant(String fieldName, int occurrence) {
        for (JavaResourceEnumConstant enumConstant : this.getEnumConstants()) {
            if (!enumConstant.isFor(fieldName, occurrence)) continue;
            return enumConstant;
        }
        return null;
    }

    private void removeEnumConstants(Collection<JavaResourceEnumConstant> remove) {
        this.removeItemsFromCollection(remove, this.enumConstants, "enumConstants");
    }

    private void initializeEnumConstants(EnumDeclaration enumDeclaration) {
        EnumConstantDeclaration[] enumConstantDeclarations = ((Enum)this.annotatedElement).getEnumConstants(enumDeclaration);
        CounterMap counters = new CounterMap(enumConstantDeclarations.length);
        EnumConstantDeclaration[] enumConstantDeclarationArray = enumConstantDeclarations;
        int n = enumConstantDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            EnumConstantDeclaration enumConstantDeclaration = enumConstantDeclarationArray[n2];
            String constantName = enumConstantDeclaration.getName().getFullyQualifiedName();
            int occurrence = counters.increment(constantName);
            this.enumConstants.add(this.buildEnumConstant(constantName, occurrence, enumConstantDeclaration));
            ++n2;
        }
    }

    private void syncEnumConstants(EnumDeclaration enumDeclaration) {
        EnumConstantDeclaration[] enumConstantDeclarations = ((Enum)this.annotatedElement).getEnumConstants(enumDeclaration);
        CounterMap counters = new CounterMap(enumConstantDeclarations.length);
        HashSet<JavaResourceEnumConstant> enumConstantsToRemove = new HashSet<JavaResourceEnumConstant>(this.enumConstants);
        EnumConstantDeclaration[] enumConstantDeclarationArray = enumConstantDeclarations;
        int n = enumConstantDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            int occurrence;
            EnumConstantDeclaration enumConstantDeclaration = enumConstantDeclarationArray[n2];
            String constantName = enumConstantDeclaration.getName().getFullyQualifiedName();
            JavaResourceEnumConstant enumConstant = this.getEnumConstant(constantName, occurrence = counters.increment(constantName));
            if (enumConstant == null) {
                this.addEnumConstant(this.buildEnumConstant(constantName, occurrence, enumConstantDeclaration));
            } else {
                enumConstantsToRemove.remove(enumConstant);
                enumConstant.synchronizeWith(enumConstantDeclaration);
            }
            ++n2;
        }
        this.removeEnumConstants(enumConstantsToRemove);
    }

    private JavaResourceEnumConstant buildEnumConstant(String fieldName, int occurrence, EnumConstantDeclaration enumConstantDeclaration) {
        return SourceEnumConstant.newInstance(this, (Enum)this.annotatedElement, fieldName, occurrence, this.getJavaResourceCompilationUnit(), enumConstantDeclaration);
    }

    @Override
    public Iterable<JavaResourceType> getTypes() {
        return EmptyIterable.instance();
    }

    @Override
    public Iterable<JavaResourceType> getAllTypes() {
        return EmptyIterable.instance();
    }

    @Override
    public Iterable<JavaResourceEnum> getEnums() {
        return EmptyIterable.instance();
    }

    @Override
    public Iterable<JavaResourceEnum> getAllEnums() {
        return new SingleElementIterable((Object)this);
    }

    private static class CounterMap {
        private final HashMap<Object, SimpleIntReference> counters;

        protected CounterMap(int initialCapacity) {
            this.counters = new HashMap(initialCapacity);
        }

        int increment(Object o) {
            SimpleIntReference counter = this.counters.get(o);
            if (counter == null) {
                counter = new SimpleIntReference();
                this.counters.put(o, counter);
            }
            counter.increment();
            return counter.getValue();
        }
    }
}

