/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility;

import org.eclipse.jpt.common.core.internal.utility.SimpleTextRange;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

public abstract class AbstractTextRange
implements TextRange {
    protected AbstractTextRange() {
    }

    public boolean includes(int index) {
        return this.getOffset() <= index && index < this.getEnd();
    }

    public boolean touches(int index) {
        return this.getOffset() <= index && index <= this.getEnd();
    }

    protected int getEnd() {
        return this.getOffset() + this.getLength();
    }

    public TextRange buildTextRange(int offset, int length, int lineNumber) {
        return offset == this.getOffset() && length == this.getLength() && lineNumber == this.getLineNumber() ? this : new SimpleTextRange(offset, length, lineNumber);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextRange)) {
            return false;
        }
        TextRange other = (TextRange)o;
        return other.getOffset() == this.getOffset() && other.getLength() == this.getLength() && other.getLineNumber() == this.getLineNumber();
    }

    public int hashCode() {
        return this.getOffset() ^ this.getLength() ^ this.getLineNumber();
    }

    public String toString() {
        String start = String.valueOf(this.getOffset());
        String end = String.valueOf(this.getEnd());
        String line = String.valueOf(this.getLineNumber());
        return ObjectTools.toString((Object)this, (CharSequence)(String.valueOf(start) + ", " + end + " [line " + line + ']'));
    }
}

