/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.internal.filtering;

import java.util.Arrays;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.wtp.EarPluginConfiguration;
import org.eclipse.m2e.wtp.ProjectUtils;
import org.eclipse.m2e.wtp.internal.filtering.AbstractResourceFilteringConfiguration;

public class EarResourceFilteringConfiguration
extends AbstractResourceFilteringConfiguration {
    private EarPluginConfiguration earPluginConfiguration;

    public EarResourceFilteringConfiguration(IMavenProjectFacade mavenProjectFacade) {
        super(mavenProjectFacade);
        this.earPluginConfiguration = new EarPluginConfiguration(mavenProjectFacade.getMavenProject());
        this.pluginConfiguration = this.earPluginConfiguration;
    }

    @Override
    public IPath getTargetFolder() {
        return EarResourceFilteringConfiguration.getTargetFolder(this.mavenProjectFacade.getMavenProject(), this.mavenProjectFacade.getProject());
    }

    public static IPath getTargetFolder(MavenProject mavenProject, IProject project) {
        return ProjectUtils.getM2eclipseWtpFolder(mavenProject, project).append("ear-resources");
    }

    @Override
    public List<Xpp3Dom> getResources() {
        if (!this.earPluginConfiguration.isFilteringDeploymentDescriptorsEnabled()) {
            return null;
        }
        String earContentDir = this.earPluginConfiguration.getEarContentDirectory(this.mavenProjectFacade.getProject());
        Xpp3Dom resource = new Xpp3Dom("resource");
        Xpp3Dom directory = new Xpp3Dom("directory");
        directory.setValue(earContentDir);
        resource.addChild(directory);
        Xpp3Dom filter = new Xpp3Dom("filtering");
        filter.setValue(Boolean.TRUE.toString());
        resource.addChild(filter);
        return Arrays.asList(resource);
    }
}

