/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.jface;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jpt.common.ui.jface.ItemExtendedLabelProvider;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractItemExtendedLabelProvider<I>
implements ItemExtendedLabelProvider {
    protected final I item;
    protected final ItemExtendedLabelProvider.Manager manager;
    protected volatile PropertyValueModel<ImageDescriptor> imageDescriptorModel;
    protected volatile PropertyChangeListener imageDescriptorListener;
    protected volatile PropertyValueModel<String> textModel;
    protected volatile PropertyChangeListener textListener;
    protected volatile PropertyValueModel<String> descriptionModel;
    protected volatile PropertyChangeListener descriptionListener;

    protected AbstractItemExtendedLabelProvider(I item, ItemExtendedLabelProvider.Manager manager) {
        if (item == null) {
            throw new NullPointerException();
        }
        if (manager == null) {
            throw new NullPointerException();
        }
        this.item = item;
        this.manager = manager;
    }

    @Override
    public final Image getImage() {
        ImageDescriptor descriptor = this.getImageDescriptor();
        return descriptor == null ? null : this.manager.getResourceManager().createImage(descriptor);
    }

    protected ImageDescriptor getImageDescriptor() {
        return (ImageDescriptor)this.getImageDescriptorModel().getValue();
    }

    protected synchronized PropertyValueModel<ImageDescriptor> getImageDescriptorModel() {
        if (this.imageDescriptorModel == null) {
            this.imageDescriptorModel = this.buildImageDescriptorModel();
            this.engageImageDescriptorModel();
        }
        return this.imageDescriptorModel;
    }

    protected PropertyValueModel<ImageDescriptor> buildImageDescriptorModel() {
        throw new UnsupportedOperationException();
    }

    protected void engageImageDescriptorModel() {
        this.imageDescriptorModel.addPropertyChangeListener("value", this.getImageDescriptorListener());
    }

    protected void disengageImageDescriptorModel() {
        this.imageDescriptorModel.removePropertyChangeListener("value", this.imageDescriptorListener);
    }

    protected void disposeImageDescriptorModel() {
        if (this.imageDescriptorModel != null) {
            this.disengageImageDescriptorModel();
            this.imageDescriptorModel = null;
        }
    }

    protected synchronized PropertyChangeListener getImageDescriptorListener() {
        if (this.imageDescriptorListener == null) {
            this.imageDescriptorListener = this.buildImageDescriptorListener();
        }
        return this.imageDescriptorListener;
    }

    protected PropertyChangeListener buildImageDescriptorListener() {
        return new ImageDescriptorListener();
    }

    void imageDescriptorChanged() {
        this.manager.updateLabel(this.item);
    }

    @Override
    public String getText() {
        return (String)this.getTextModel().getValue();
    }

    protected synchronized PropertyValueModel<String> getTextModel() {
        if (this.textModel == null) {
            this.textModel = this.buildTextModel();
            this.engageTextModel();
        }
        return this.textModel;
    }

    protected PropertyValueModel<String> buildTextModel() {
        throw new UnsupportedOperationException();
    }

    protected void engageTextModel() {
        this.textModel.addPropertyChangeListener("value", this.getTextListener());
    }

    protected void disengageTextModel() {
        this.textModel.removePropertyChangeListener("value", this.textListener);
    }

    protected void disposeTextModel() {
        if (this.textModel != null) {
            this.disengageTextModel();
            this.textModel = null;
        }
    }

    protected synchronized PropertyChangeListener getTextListener() {
        if (this.textListener == null) {
            this.textListener = this.buildTextListener();
        }
        return this.textListener;
    }

    protected PropertyChangeListener buildTextListener() {
        return new TextListener();
    }

    void textChanged() {
        this.manager.updateLabel(this.item);
    }

    @Override
    public String getDescription() {
        return (String)this.getDescriptionModel().getValue();
    }

    protected synchronized PropertyValueModel<String> getDescriptionModel() {
        if (this.descriptionModel == null) {
            this.descriptionModel = this.buildDescriptionModel();
            this.engageDescriptionModel();
        }
        return this.descriptionModel;
    }

    protected PropertyValueModel<String> buildDescriptionModel() {
        throw new UnsupportedOperationException();
    }

    protected void engageDescriptionModel() {
        this.descriptionModel.addPropertyChangeListener("value", this.getDescriptionListener());
    }

    protected void disengageDescriptionModel() {
        this.descriptionModel.removePropertyChangeListener("value", this.descriptionListener);
    }

    protected void disposeDescriptionModel() {
        if (this.descriptionModel != null) {
            this.disengageDescriptionModel();
            this.descriptionModel = null;
        }
    }

    protected synchronized PropertyChangeListener getDescriptionListener() {
        if (this.descriptionListener == null) {
            this.descriptionListener = this.buildDescriptionListener();
        }
        return this.descriptionListener;
    }

    protected PropertyChangeListener buildDescriptionListener() {
        return new DescriptionListener();
    }

    void descriptionChanged() {
        this.manager.updateDescription(this.item);
    }

    @Override
    public synchronized void dispose() {
        this.disposeImageDescriptorModel();
        this.disposeTextModel();
        this.disposeDescriptionModel();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.item);
    }

    class DescriptionListener
    extends PropertyChangeAdapter {
        DescriptionListener() {
        }

        public void propertyChanged(PropertyChangeEvent event) {
            AbstractItemExtendedLabelProvider.this.descriptionChanged();
        }
    }

    class ImageDescriptorListener
    extends PropertyChangeAdapter {
        ImageDescriptorListener() {
        }

        public void propertyChanged(PropertyChangeEvent event) {
            AbstractItemExtendedLabelProvider.this.imageDescriptorChanged();
        }
    }

    class TextListener
    extends PropertyChangeAdapter {
        TextListener() {
        }

        public void propertyChanged(PropertyChangeEvent event) {
            AbstractItemExtendedLabelProvider.this.textChanged();
        }
    }
}

